# Reading This IG - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Reading This IG**

## Reading This IG

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Underlying Technologies

This guide is based on the [HL7 FHIR](http://hl7.org/fhir/R4/index.html) standard. This architecture is intended to maximize the number of provider and payer systems that conform to this guide, as well as to allow for easy growth and extensibility of system capabilities in the future.

Implementers of this specification therefore need to understand some basic information about these referenced specifications.

#### FHIR

This implementation guide uses terminology, notations and design principles that are specific to FHIR. Before reading this implementation guide, it's important to be familiar with some of the basic principles of FHIR as well as general guidance on how to read FHIR specifications. Readers who are unfamiliar with FHIR are encouraged to read (or at least skim) the following prior to reading the rest of this implementation guide.

* [FHIR Overview](http://hl7.org/fhir/R4/overview.html)
* [Developer's Introduction](http://hl7.org/fhir/R4/overview-dev.html) (or [Clinical Introduction](http://hl7.org/fhir/R4/overview-clinical.html))
* [FHIR Data Types](http://hl7.org/fhir/R4/datatypes.html)
* [Using Codes](http://hl7.org/fhir/R4/terminologies.html)
* [References Between Resources](http://hl7.org/fhir/R4/references.html)
* [How to Read Resource & Profile Definitions](http://hl7.org/fhir/R4/formats.html) and additional [IG reading guidance](https://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html)
* [Base Resource](http://hl7.org/fhir/R4/resource.html)

This implementation guide supports the [R4](http://hl7.org/fhir/R4/index.html) version of the FHIR standard and builds on the US Core [3.1.1 (USCDI v1)](http://hl7.org/fhir/us/core/STU3.1.1), [6.1 (USCDI v3)](http://hl7.org/fhir/us/core/STU6.1) and [7.0 (USCDI v4)](http://hl7.org/fhir/us/core/STU7) implementation guides and implementers need to familiarize themselves with the profiles in those guides. The profiles in this IG conform with all three releases of US Core.

This IG also draws on content from the [Da Vinci Health Record Exchange (HRex)](http://hl7.org/fhir/us/davinci-hrex/STU1.1) and [Subscriptions R5 Backport](http://hl7.org/fhir/uv/subscriptions-backport/STU1.1) implementation guides.

Implementers should also familiarize themselves with the FHIR resources used within the guide:

| | |
| :--- | :--- |
| [Bundle](http://hl7.org/fhir/R4/bundle.html) | Used when delivering collections of resources in several API calls |
| [CapabilityStatement](http://hl7.org/fhir/R4/capabilitystatement.html) | Used to define conformance expectations for this guide |
| [Claim](http://hl7.org/fhir/R4/claim.html) | The resource type used by a providers to provide a Good Faith Estimate of services or products |
| [CodeSystem](http://hl7.org/fhir/R4/codesystem.html) | Used to define custom codes specific to this guide |
| [Composition](http://hl7.org/fhir/R4/composition.html)[Composition] | Used in document bundles to provide a single coherent statement of meaning of what is in the document and the relationship of top-level resources in the bundle |
| [Coverage](http://hl7.org/fhir/R4/coverage.html) | Used to identify the member and the relevant insurance coverage to a payer |
| [DeviceRequest](http://hl7.org/fhir/R4/devicerequest.html) | One of the resources that may be used in a request to contribute a GFE explaining what services or products are needed |
| [DocumentReference](http://hl7.org/fhir/R4/documentreference.html) | A reference to estimate documents that provides metadata about the document so that the document can be discovered, managed, and notifications can be subscribed to |
| [ExplanationOfBenefit](http://hl7.org/fhir/R4/explanationofbenefit.html) | The resource type used by a payer to provide the Advanced Explanation Of Benefit for insured members |
| [Location](http://hl7.org/fhir/R4/location.html) | Supporting information used to identify a proposed location for services or products to be performed or delivered |
| [Organization](http://hl7.org/fhir/R4/organization.html) | Used when identifying organizational providers or facilities in GFE Coordination Tasks and involved in the services or products listed in the GFEs, and payers for which an AEOB is being requested |
| [Medication](http://hl7.org/fhir/R4/medication.html) | Supporting information for medication requests |
| [MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html) | One of the resources that may be used in a request to contribute a GFE explaining what services or products are needed |
| [NutritionOrder](http://hl7.org/fhir/R4/nutritionorder.html) | One of the resources that may be used in a request to contribute a GFE explaining what services or products are needed |
| [OperationDefinition](http://hl7.org/fhir/R4/operationdefinition.html) | Defines the parameters and requirements for an operation. THis guide defined a few use case specific operations |
| [OperationOutcome](http://hl7.org/fhir/R4/operationoutcome.html) | Provides sets of error, warning and information messages that provide detailed information about the outcome of an attempted system operation. |
| [Patient](http://hl7.org/fhir/R4/patient.html) | Demographic information relevant to all requests |
| [Practitioner](http://hl7.org/fhir/R4/practitioner.html) | Used when identifying individual practitioner providers or facilities in GFE Coordination Tasks and involved in the services or products listed in the GFEs |
| [PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html) | Used when identifying practitioner provider roles in GFE Coordination Tasks |
| [SearchParameter](http://hl7.org/fhir/R4/searchparameter.html) | Defines the a searchable element defined by this IG used for searching and subscriptions |
| [ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html) | One of the resources that may be used in a request to contribute a GFE explaining what services or products are needed |
| [StructureDefinition](http://hl7.org/fhir/R4/structuredefinition.html) | Used when profiling resources and defining extensions |
| [Subscription](http://hl7.org/fhir/R4/subscription.html) | A resource used to define a push-based subscription from a server to another system. |
| [SubscriptionTopic](https://hl7.org/fhir/R5/subscriptiontopic.html) | A resource used define a set of events that a client can subscribe to. This resource is defined in FHIR 4B and later versions. Be aware that this resource is not supported by FHIR R4 systems. Subscription Topics in R4 can be defined using a Basic profile resource with extensions. |
| [Task](http://hl7.org/fhir/R4/task.html) | Used to manage dispatching to GFE contributing providers |
| [ValueSet](http://hl7.org/fhir/R4/valueset.html) | Used to define collections of codes used by PCT profiles |
| [VisionPrescription](http://hl7.org/fhir/R4/visionprescription.html) | One of the resources that may be used in a request to contribute a GFE explaining what services or products are needed |

## Relationship to Other Implementation Guides

### Good Faith Estimate Coordination Relationships

### Good Faith Estimate Relationships

### Advanced Explanation Of Benefit Relationships

### US Core

Provider billing and payer claims adjudication systems for those profiles defined by US Core **SHALL** use the specification defined by [US Core](/index.md) in exchanging information with payers. Implementers should be familiar with this specification. Claim, ExplanationOfBenefit and Coverage resource profiles are not defined by US Core.

Da Vinci PCT implementations **SHALL** conform to the US Core IG [General Guidance](http://hl7.org/fhir/us/core/STU7/general-guidance.html) requirements where US Core IG resources are used.

### Da Vinci HRex

Provider billing and payer systems **SHALL** use the specification defined by the Da Vinci HRex IG [Da Vinci HRex IG](/index.md) when exchanging information, as defined by [the Privacy and Security section of this IG](security.md). Implementers should be familiar with this specification.

