# Project and Participants - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Project and Participants**

## Project and Participants

| |
| :--- |
| *Page standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) |

### Da Vinci

[Da Vinci](https://www.hl7.org/about/davinci/index.cfm) is an HL7-sponsored project that brings together U.S. payers, providers, and technology suppliers to help payers and providers improve clinical, quality, cost, and care management outcomes using FHIR-related technologies. The project organizes meetings (face-to-face and conference calls) and connectathons to find ways to leverage FHIR technologies to support and integrate value-based care (VBC) data exchange across communities. Da Vinci identifies value-based care use cases of interest to its members and to the broader community.

The process that Da Vinci has adopted includes:

1. identifying business, clinical, technical, and testing requirements
1. developing and balloting a FHIR-based implementation guide (IG)
1. developing reference implementations (RIs) to demonstrate that the concepts in the IG are possible to implement
1. piloting the standard
1. supporting the production use of the IG to enable exchange of data to support interoperability for value-based care

All Da Vinci work adheres to a common set of [guiding principles](http://hl7.org/fhir/us/davinci-hrex/STU1.1/davinci-guiding-principles.html).

Additional information about Da Vinci, its members, the use cases, and the implementation guides being developed can all be found on the [HL7 website](http://www.hl7.org/about/davinci). Meeting minutes and other materials can be found on the [Da Vinci Confluence page](https://confluence.hl7.org/display/DVP).

### The Da Vinci PCT project

Project participants have included major EHR vendors, payers, provider organizations, and others. The first standard for trial use version of the specification was published in 2023 and the specification has undergone considerable testing at various Connectathons and has started to be picked up in pilot implementations since then. Further details about the project, including minutes of meetings can be found on the [project Confluence page](https://confluence.hl7.org/spaces/DVP/pages/116460399/Patient+Cost+Transparency+PCT).

### Credits

 **Primary Authors:**

* Corey Spears (Lantana Consulting Group)
* Rick Geimer (Lantana Consulting Group)
* Larry Decelles (The MITRE Corporation)
* Gary Gryan (The MITRE Corporation)
* Caleb Wan (The MITRE Corporation)

**Technical Editing:**

* Yolanda Liu (The MITRE Corporation)
* Joe Minieri (The MITRE Corporation)
* Kristin Schrock (Lantana Consulting Group)

**Da Vinci Project Coordination and Core Team:**

* Vanessa Candelora (Point-of-Care Partners)
* Viet Nguyen (Stratametrics, LLC)
* Jocelyn Keegan (Point-of-Care Partners)
* Robert Dieterle (EnableCare, LLC)
* Phung Matthews (Point-of-Care Partners)
* Mary Kay McDaniel (Markam)
* Lloyd McKenzie (Dogwood Health Consulting)
* Denise St. Clair (Global Alliant, Inc.)
* Crystal Kallem (Point-of-Care Partners)

**Test Lead:**

* Ryan Moehrke (AEGIS)

**Da Vinci Member Leadership Provided By:**

* Alice O'Carroll (Florida Blue)
* Jacob Woodford (Epic)
* Luke Rockenbach (Providence)
* Zackery Welch (Providence)
* Tina Mintyala (Providence)
* Jill Elder (Providence)

**This IG was developed under the auspices of the Financial Management Work Group.**

Special thanks to the numerous Da Vinci members and community who have participated on conference calls, provided reviews and feedback, supported sample data gathering, reference implementation development, and testing including, but not limited to:

* Aegis (Carie Hammond)
* Aetna, a CVS Health company (Office of Interoperability)
* American Hospital Association (Terrence Cunningham, Andrea Preisler)  
* American Medical Association (Celine Lefebvre, Emma Andelson, Heather McComas)
* b.well (Adam Culbertson, Logan Edwards)
* Blue Cross Blue Shield Association (Patricia B Taylor, Samuel Undine, Michael Gould, Gail Kocher)
* Cambia Health Solutions (Hong Huang, Pat Waller)
* careviso (Brandon Blais,  Rachelle Galant, Perry Dimas, Andrew Mignatti)  
* Cleveland Clinic (Jaime Lampshire)
* Consumers' Checkbook/Center for the Study of Services (Eric Ellsworth)
* Edifecs (Kevin Day, Artem Sopin, Maxim Abramsky)
* Elevance Health (Chris Cioffi, Ranjith Kandur)
* Epic (Jacob Woodford, Spencer Utley)
* Flexpa (Joshua Kelly)
* Florida Blue (Alice O’Carroll, Court Collins, Charles Porter, Scott Ogden, Gangadhara Daka, Avani Shandilya, Javier del Pino)
* HealthLX (David Riddle)
* Hospital for Special Surgery (Sarah Cutcliffe, Ross Sadler)
* Kryruus Health (Kevin Rill)
* Nachimson Advisors (Stanley Nachimson)
* Optum (Linda Michaelsen, David Potochniak)
* Smile CDR Inc. (Cait O'Donnell, Joseph Quinn, and Sophie Tekeste)
* The MITRE Corporation (FHIR Shorthand Team)
* Weill Cornell Medicine (Jill Vincente, Jarrett Cox)

> If you are interested in participating in the PCT project, information about our calls, minutes of past discussions, and other information can be found[here](https://confluence.hl7.org/pages/viewpage.action?pageId=116460399)on our HL7 Confluence page.

