# hl7.fhir.us.davinci-pct#2.0.0: Patient Cost Transparency Implementation Guide

## Pages

* [Home Page](index.md)
* [SubscriptionTopic - GFE Available for Subject Notification](SubscriptionTopic-davinci-pct-gfe-available-subject-notification.md)
* [Security](security.md)
* [Reading This IG](reading_this_ig.md)
* [](SubscriptionTopic-davinci-pct-gfe-coordination-task-notification.change.history.md)
* [SubscriptionTopic - GFE Available for Author Notification](SubscriptionTopic-davinci-pct-gfe-available-author-notification.md)
* [SubscriptionTopic - AEOB Available for Author Notification - TTL Representation](SubscriptionTopic-davinci-pct-aeob-available-author-notification.ttl.md)
* [SubscriptionTopic - GFE Available for Subject Notification - JSON Representation](SubscriptionTopic-davinci-pct-gfe-available-subject-notification.json.md)
* [SubscriptionTopic - GFE Coordination Task Notification](SubscriptionTopic-davinci-pct-gfe-coordination-task-notification.md)
* [SubscriptionTopic - AEOB Available for Author Notification](SubscriptionTopic-davinci-pct-aeob-available-author-notification.md)
* [SubscriptionTopic - GFE Available for Subject Notification - XML Representation](SubscriptionTopic-davinci-pct-gfe-available-subject-notification.xml.md)
* [](SubscriptionTopic-davinci-pct-gfe-available-author-notification.change.history.md)
* [SubscriptionTopic - GFE Coordination Task Notification - XML Representation](SubscriptionTopic-davinci-pct-gfe-coordination-task-notification.xml.md)
* [](SubscriptionTopic-davinci-pct-aeob-available-author-notification.change.history.md)
* [Good Faith Estimate (GFE) Submission and AEOB Overview](gfe_submission_and_aeob_overview.md)
* [Good Faith Estimate (GFE) Coordination Overview (Multi-Provider)](gfe_coordination_overview.md)
* [Good Faith Estimate (GFE) Coordination Specification (Multi-Provider)](gfe_coordination_specification.md)
* [SubscriptionTopic - GFE Coordination Task Notification - TTL Representation](SubscriptionTopic-davinci-pct-gfe-coordination-task-notification.ttl.md)
* [SubscriptionTopic - AEOB Available for Subject Notification - XML Representation](SubscriptionTopic-davinci-pct-aeob-available-subject-notification.xml.md)
* [SubscriptionTopic - AEOB Available for Author Notification - XML Representation](SubscriptionTopic-davinci-pct-aeob-available-author-notification.xml.md)
* [Patient Access to GFE and AEOB](patient_access_support.md)
* [Downloads](downloads.md)
* [SubscriptionTopic - GFE Coordination Task Notification - JSON Representation](SubscriptionTopic-davinci-pct-gfe-coordination-task-notification.json.md)
* [SubscriptionTopic - AEOB Available for Author Notification - JSON Representation](SubscriptionTopic-davinci-pct-aeob-available-author-notification.json.md)
* [SubscriptionTopic - GFE Available for Author Notification - XML Representation](SubscriptionTopic-davinci-pct-gfe-available-author-notification.xml.md)
* [SubscriptionTopic - AEOB Available for Subject Notification](SubscriptionTopic-davinci-pct-aeob-available-subject-notification.md)
* [Change Log](change_log.md)
* [Formal Specification](formal_specification.md)
* [Project and Participants](projects_and_participants.md)
* [SubscriptionTopic - GFE Available for Subject Notification - TTL Representation](SubscriptionTopic-davinci-pct-gfe-available-subject-notification.ttl.md)
* [Terminology Licensure](terminology_licensure.md)
* [Good Faith Estimate (GFE) Submission and AEOB Specification](gfe_submission_and_aeob_specification.md)
* [SubscriptionTopic - GFE Available for Author Notification - JSON Representation](SubscriptionTopic-davinci-pct-gfe-available-author-notification.json.md)
* [SubscriptionTopic - AEOB Available for Subject Notification - TTL Representation](SubscriptionTopic-davinci-pct-aeob-available-subject-notification.ttl.md)
* [](SubscriptionTopic-davinci-pct-gfe-available-subject-notification.change.history.md)
* [Artifacts Summary](artifacts.md)
* [Use Case and Actors](use_cases.md)
* [SubscriptionTopic - AEOB Available for Subject Notification - JSON Representation](SubscriptionTopic-davinci-pct-aeob-available-subject-notification.json.md)
* [SubscriptionTopic - GFE Available for Author Notification - TTL Representation](SubscriptionTopic-davinci-pct-gfe-available-author-notification.ttl.md)
* [](SubscriptionTopic-davinci-pct-aeob-available-subject-notification.change.history.md)

## Resources

### CodeSystems

* [PCT AEOB Process Note Code System](CodeSystem-PCTAEOBProcessNoteCS.md)
* [PCT Adjudication Code System](CodeSystem-PCTAdjudication.md)
* [PCT Adjudication Category CodeSystem](CodeSystem-PCTAdjudicationCategoryCS.md)
* [PCT Packet Section Codes](CodeSystem-PCTDocumentSection.md)
* [PCT Document Types](CodeSystem-PCTDocumentTypeTemporaryTrialUse.md)
* [PCT Estimate Type Code System](CodeSystem-PCTEstimateTypeSummaryCSTemporaryTrialUse.md)
* [PCT Financial Type Code System](CodeSystem-PCTFinancialType.md)
* [PCT GFE Request Type Codes Code System](CodeSystem-PCTGFERequestTypeCSTemporaryTrialUse.md)
* [PCT Network Status](CodeSystem-PCTNetworkStatusCS.md)
* [PCT Organization Contact Purpose Type Code System](CodeSystem-PCTOrgContactPurposeType.md)
* [PCT Procedure Type](CodeSystem-PCTProcedureType.md)
* [PCT GFE Supporting Info Type Code System](CodeSystem-PCTSupportingInfoType.md)
* [PCT GFE Request Task Business Status Code System](CodeSystem-PCTTaskBusinessStatusCSTemporaryTrialUse.md)
* [PCT GFE Request Task Status Reason Code Code System](CodeSystem-PCTTaskStatusReasonCSTemporaryTrialUse.md)

### ValueSets

* [NUBC Point Of Origin](ValueSet-AHANUBCPointOfOriginVS.md)
* [NUBC Priority (Type) of Admission or Visit](ValueSet-AHANUBCPriorityTypeOfAdmissionOrVisitVS.md)
* [ICD-10 Procedure Codes](ValueSet-ICD10ProcedureCodes.md)
* [PCT AEOB Process Note Types](ValueSet-PCTAEOBProcessNoteVS.md)
* [PCT GFE Item Adjudication Value Set](ValueSet-PCTAdjudicationCategoryVS.md)
* [PCT Adjudication Value Set](ValueSet-PCTAdjudicationVS.md)
* [PCT Adjustment Reason](ValueSet-PCTAdjustmentReasonVS.md)
* [PCT benefitBalance.category codes](ValueSet-PCTBenefitBalanceCategoryVS.md)
* [PCT Care Team Role Value Set](ValueSet-PCTCareTeamRoleVS.md)
* [Provider GFE Contributor Task Status Codes](ValueSet-PCTContributorTaskStatusCodes.md)
* [PCT GFE Contributor Task Status Reason Codes ValueSet](ValueSet-PCTContributorTaskStatusReasonCodes.md)
* [GFE Coordination Task Status Codes](ValueSet-PCTCoordinationTaskStatusCodes.md)
* [PCT GFE Request Coordination Task Status Reason Codes ValueSet](ValueSet-PCTCoordinationTaskStatusReasonCodes.md)
* [PCT ICD-10 Diagnostic Codes](ValueSet-PCTDiagnosticCodes.md)
* [PCT Financial Type Value Set](ValueSet-PCTFinancialTypeVS.md)
* [PCT GFE CMS Place of Service Value Set](ValueSet-PCTGFECMSPOS.md)
* [PCT GFE Item CPT - HCPCS Value Set](ValueSet-PCTGFEItemCptHcpcsVS.md)
* [PCT GFE Item NDC Value Set](ValueSet-PCTGFEItemNDCVS.md)
* [PCT GFE NUBC Revenue Value Set](ValueSet-PCTGFEItemRevenueVS.md)
* [PCT GFE Request Type Codes ValueSet](ValueSet-PCTGFERequestTypeVS.md)
* [PCT GFE Task Relationship](ValueSet-PCTGFETaskRelationship.md)
* [PCT GFE NUBC Uniform Billing (UB-04) Type of Bill Value Set](ValueSet-PCTGFETypeOfBillVS.md)
* [PCT Organization Contact Purpose Value Set](ValueSet-PCTOrgContactPurposeTypeVS.md)
* [PCT Organization Type Value Set](ValueSet-PCTOrganizationTypeVS.md)
* [PCT Payer Benefit Payment Status](ValueSet-PCTPayerBenefitPaymentStatusVS.md)
* [PCT Payer Provider Network Status](ValueSet-PCTPayerProviderNetworkStatusVS.md)
* [PCT CMS HCPCS and AMA CPT Procedure Surgical Codes](ValueSet-PCTProcedureSurgicalCodes.md)
* [PCT Procedure Type Value Set](ValueSet-PCTProcedureTypeVS.md)
* [PCT Supporting Info Type Value Set](ValueSet-PCTSupportingInfoTypeVS.md)
* [PCT Task Attachment Mime Types](ValueSet-PCTTaskAttachmentContentType.md)
* [PCT GFE Request Task Business Status ValueSet](ValueSet-PCTTaskBusinessStatusCodes.md)
* [PCT Total Value Set](ValueSet-PCTTotal.md)
* [US Claim DRG Codes](ValueSet-USClaimDRGCodes.md)
* [Claim Medical Product or Service Value Set](ValueSet-USClaimMedicalProductOrServiceCodes.md)

### Resource Profiles

* [PCT AEOB Adjudication Error](StructureDefinition-davinci-pct-aeob-adjudication-error.md)
* [Subscription - AEOB Available for Author Notification](StructureDefinition-davinci-pct-aeob-available-author-subscription.md)
* [Subscription - AEOB Available for Subject Notification](StructureDefinition-davinci-pct-aeob-available-subject-subscription.md)
* [PCT AEOB Complete](StructureDefinition-davinci-pct-aeob-complete.md)
* [PCT AEOB Composition](StructureDefinition-davinci-pct-aeob-composition.md)
* [PCT AEOB Packet Document Reference](StructureDefinition-davinci-pct-aeob-documentreference.md)
* [PCT AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md)
* [PCT Advanced EOB Summary](StructureDefinition-davinci-pct-aeob-summary.md)
* [PCT Advanced EOB](StructureDefinition-davinci-pct-aeob.md)
* [PCT Coverage](StructureDefinition-davinci-pct-coverage.md)
* [PCT GFE DeviceRequest](StructureDefinition-davinci-pct-devicerequest.md)
* [Subscription - GFE Available for Author Notification](StructureDefinition-davinci-pct-gfe-available-author-subscription.md)
* [Subscription - GFE Available for Subject Notification](StructureDefinition-davinci-pct-gfe-available-subject-subscription.md)
* [PCT GFE Bundle](StructureDefinition-davinci-pct-gfe-bundle.md)
* [PCT GFE Composition](StructureDefinition-davinci-pct-gfe-composition.md)
* [PCT GFE Contributor Task](StructureDefinition-davinci-pct-gfe-contributor-task.md)
* [PCT GFE Coordination Bundle](StructureDefinition-davinci-pct-gfe-coordination-bundle.md)
* [PCT GFE Coordination Task](StructureDefinition-davinci-pct-gfe-coordination-task.md)
* [PCT GFE Packet Document Reference](StructureDefinition-davinci-pct-gfe-documentreference.md)
* [PCT GFE Information Bundle](StructureDefinition-davinci-pct-gfe-information-bundle.md)
* [PCT Good Faith Estimate Institutional](StructureDefinition-davinci-pct-gfe-institutional.md)
* [PCT GFE Missing Bundle](StructureDefinition-davinci-pct-gfe-missing-bundle.md)
* [PCT GFE Packet](StructureDefinition-davinci-pct-gfe-packet.md)
* [PCT Good Faith Estimate Professional](StructureDefinition-davinci-pct-gfe-professional.md)
* [PCT Good Faith Estimate  Summary](StructureDefinition-davinci-pct-gfe-summary.md)
* [Subscription - GFE Coordination Task Update Notification](StructureDefinition-davinci-pct-gfe-task-update-subscription.md)
* [PCT GFE Validation Error](StructureDefinition-davinci-pct-gfe-validation-error.md)
* [PCT GFE MedicationRequest](StructureDefinition-davinci-pct-medicationrequest.md)
* [PCT Organization](StructureDefinition-davinci-pct-organization.md)
* [PCT Practitioner](StructureDefinition-davinci-pct-practitioner.md)
* [PCT Service Location](StructureDefinition-davinci-pct-service-location.md)
* [PCT GFE ServiceRequest](StructureDefinition-davinci-pct-servicerequest.md)

### Extensions

* [Significant condition involved](StructureDefinition-estimateCondition.md)
* [Significant Procedures and/or products involved](StructureDefinition-estimateProcedureOrService.md)
* [GFEBillingProviderLineItemCtrlNum](StructureDefinition-gfeBillingProviderLineItemCtrlNum.md)
* [GFEConsentForBalanceBilling](StructureDefinition-gfeConsentForBalanceBilling.md)
* [GFEDisclaimer](StructureDefinition-gfeDisclaimer.md)
* [GFE Reference](StructureDefinition-gfeReference.md)
* [GFERelatedTask](StructureDefinition-gfeRelatedTask.md)
* [GFEServiceLinkingInfo](StructureDefinition-gfeServiceLinkingInfo.md)
* [In Network Provider Options Link](StructureDefinition-inNetworkProviderOptionsLink.md)
* [Planned Service Period](StructureDefinition-plannedServicePeriod.md)
* [ProcessNote Class](StructureDefinition-processNoteClass.md)
* [ProviderEventMethodology](StructureDefinition-providerEventMethodology.md)
* [ProviderTaxonomy](StructureDefinition-providerTaxonomy.md)
* [ReferralNumber](StructureDefinition-referralNumber.md)
* [Benefit Remaining](StructureDefinition-remaining-benefit.md)
* [Request Initiation Time](StructureDefinition-requestInitiationTime.md)
* [RequestOriginationType](StructureDefinition-requestOriginationType.md)
* [Self-Pay Declared](StructureDefinition-selfPayDeclared.md)
* [Service Description](StructureDefinition-serviceDescription.md)
* [Subject To Medical Management](StructureDefinition-subjectToMedicalMgmt.md)

### Basics

* [davinci-pct-aeob-available-author-notification](Basic-davinci-pct-aeob-available-author-notification.md)
* [davinci-pct-aeob-available-subject-notification](Basic-davinci-pct-aeob-available-subject-notification.md)
* [davinci-pct-gfe-available-author-notification](Basic-davinci-pct-gfe-available-author-notification.md)
* [davinci-pct-gfe-available-subject-notification](Basic-davinci-pct-gfe-available-subject-notification.md)
* [davinci-pct-gfe-coordination-task-notification](Basic-davinci-pct-gfe-coordination-task-notification.md)

### CapabilityStatements

* [Patient Cost Transparency Implementation Guide Coordination Platform Capability Statement](CapabilityStatement-davinci-pct-coordination-platform.md)
* [Patient Cost Transparency Implementation Guide Coordination Requester Capability Statement](CapabilityStatement-davinci-pct-coordination-requester.md)
* [Patient Cost Transparency Implementation Guide GFE Contributor Capability Statement](CapabilityStatement-davinci-pct-gfe-contributor.md)
* [Patient Cost Transparency Implementation Guide Provider Capability Statement](CapabilityStatement-davinci-pct-gfe-provider.md)
* [Patient Cost Transparency Implementation Guide Payer Capability Statement](CapabilityStatement-davinci-pct.md)

### ImplementationGuides

* [Patient Cost Transparency Implementation Guide](index.md)

### OperationDefinitions

* [Good Faith Estimate Coordination Request](OperationDefinition-GFE-coordination-request.md)
* [Retrieve GFE Packet](OperationDefinition-GFE-retrieve.md)
* [Submit a GFE resource for the creation of an AEOB](OperationDefinition-GFE-submit.md)

### SearchParameters

* [DocumentReferenceDocStatus](SearchParameter-DocumentReference-doc-status.md)
* [AEOBDateOfService](SearchParameter-aeob-date-of-service.md)
* [PacketPlannedPeriodOfService](SearchParameter-packet-PlannedPeriodOfService.md)
* [PacketCondition](SearchParameter-packet-condition.md)
* [PacketLinkingIdentifier](SearchParameter-packet-linking-identifier.md)
* [PacketProcedureOrService](SearchParameter-packet-procedure-or-service.md)
* [PacketRequestInitiationTime](SearchParameter-packet-request-initiation-time.md)
* [RelatedTask](SearchParameter-related-task.md)
* [TaskRequestedPeriod](SearchParameter-task-requested-period.md)

### Examples

* [PCT-AEOB-Packet-1 (Bundle)](Bundle-PCT-AEOB-Packet-1.md)
* [PCT-GFE-Bundle-Inst-1 (Bundle)](Bundle-PCT-GFE-Bundle-Inst-1.md)
* [PCT-GFE-Bundle-Prof-1 (Bundle)](Bundle-PCT-GFE-Bundle-Prof-1.md)
* [PCT-GFE-Coordination-Bundle-1 (Bundle)](Bundle-PCT-GFE-Coordination-Bundle-1.md)
* [PCT-GFE-Information-Bundle-1 (Bundle)](Bundle-PCT-GFE-Information-Bundle-1.md)
* [PCT-GFE-Missing-Bundle-1 (Bundle)](Bundle-PCT-GFE-Missing-Bundle-1.md)
* [PCT-GFE-Packet-Inst-1 (Bundle)](Bundle-PCT-GFE-Packet-Inst-1.md)
* [PCT-GFE-Packet-Prof-1 (Bundle)](Bundle-PCT-GFE-Packet-Prof-1.md)
* [PCT-GFE-Institutional-1 (Claim)](Claim-PCT-GFE-Institutional-1.md)
* [PCT-GFE-Institutional-MRI (Claim)](Claim-PCT-GFE-Institutional-MRI.md)
* [PCT-GFE-Professional-MRI (Claim)](Claim-PCT-GFE-Professional-MRI.md)
* [PCT-GFE-Summary-1 (Claim)](Claim-PCT-GFE-Summary-1.md)
* [PCT-GFE-Summary-MRI (Claim)](Claim-PCT-GFE-Summary-MRI.md)
* [coverage1001 (Coverage)](Coverage-coverage1001.md)
* [selfpaycoverage2001 (Coverage)](Coverage-selfpaycoverage2001.md)
* [PCT-DeviceRequest-1 (DeviceRequest)](DeviceRequest-PCT-DeviceRequest-1.md)
* [PCT-AEOB-DocumentReference-1 (DocumentReference)](DocumentReference-PCT-AEOB-DocumentReference-1.md)
* [PCT-GFE-DocumentReference-Inst-1 (DocumentReference)](DocumentReference-PCT-GFE-DocumentReference-Inst-1.md)
* [PCT-GFE-DocumentReference-Prof-1 (DocumentReference)](DocumentReference-PCT-GFE-DocumentReference-Prof-1.md)
* [PCT-AEOB-1 (ExplanationOfBenefit)](ExplanationOfBenefit-PCT-AEOB-1.md)
* [PCT-AEOB-Summary-1 (ExplanationOfBenefit)](ExplanationOfBenefit-PCT-AEOB-Summary-1.md)
* [Hospital (Location)](Location-PCT-ServiceLocation-1.md)
* [PCT-MedicationRequest-1 (MedicationRequest)](MedicationRequest-PCT-MedicationRequest-1.md)
* [PCT-AEOB-Adjudication-Error-Example-1 (OperationOutcome)](OperationOutcome-PCT-AEOB-Adjudication-Error-Example-1.md)
* [PCT-AEOB-Complete-Example-1 (OperationOutcome)](OperationOutcome-PCT-AEOB-Complete-Example-1.md)
* [PCT-GFE-Validation-Error-Example-1 (OperationOutcome)](OperationOutcome-PCT-GFE-Validation-Error-Example-1.md)
* [GFE Service Help INC. (Organization)](Organization-Submitter-Org-1.md)
* [Umbrella Insurance Company (Organization)](Organization-org1001.md)
* [Boston Radiology Center (Organization)](Organization-org1002.md)
* [patient1001 (Patient)](Patient-patient1001.md)
* [Submitter-Practitioner-1 (Practitioner)](Practitioner-Submitter-Practitioner-1.md)
* [prac001 (Practitioner)](Practitioner-prac001.md)
* [prac002 (Practitioner)](Practitioner-prac002.md)
* [PCT-ServiceRequest-1 (ServiceRequest)](ServiceRequest-PCT-ServiceRequest-1.md)
* [example-aeob-available-author-subscription-full (Subscription)](Subscription-example-aeob-available-author-subscription-full.md)
* [example-aeob-available-author-subscription-id-only (Subscription)](Subscription-example-aeob-available-author-subscription-id-only.md)
* [example-aeob-available-subject-subscription (Subscription)](Subscription-example-aeob-available-subject-subscription.md)
* [example-gfe-available-author-subscription-full (Subscription)](Subscription-example-gfe-available-author-subscription-full.md)
* [example-gfe-available-author-subscription-id-only (Subscription)](Subscription-example-gfe-available-author-subscription-id-only.md)
* [example-gfe-available-subject-subscription-full (Subscription)](Subscription-example-gfe-available-subject-subscription-full.md)
* [example-gfe-task-subscription-partof (Subscription)](Subscription-example-gfe-task-subscription-partof.md)
* [example-gfe-task-subscription (Subscription)](Subscription-example-gfe-task-subscription.md)
* [PCT-GFE-Contributor-Replacement-Task-1 (Task)](Task-PCT-GFE-Contributor-Replacement-Task-1.md)
* [PCT-GFE-Contributor-Replacement-Task-2 (Task)](Task-PCT-GFE-Contributor-Replacement-Task-2.md)
* [PCT-GFE-Contributor-Task-1 (Task)](Task-PCT-GFE-Contributor-Task-1.md)
* [PCT-GFE-Contributor-Task-2 (Task)](Task-PCT-GFE-Contributor-Task-2.md)
* [PCT-GFE-Coordination-Replacement-Task-1 (Task)](Task-PCT-GFE-Coordination-Replacement-Task-1.md)
* [PCT-GFE-Coordination-Task-1 (Task)](Task-PCT-GFE-Coordination-Task-1.md)
