# Patient Cost Transparency Implementation Guide Home Page - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Patient Cost Transparency Implementation Guide Home Page**

## Patient Cost Transparency Implementation Guide Home Page

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct | *Version*:2.0.0 | |
| *IG Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PatientCostTransparency |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4 | | |

> This specification is a Standard for Trial Use. It is expected to continue to evolve and improve through HL7® FHIR® Connectathon testing and feedback from early adopters.This IG has two workflows that can be sequenced together. The first is focused on a payer receiving a good faith estimate (GFE) from a provider and returning an Advanced Explanation of Benefits (AEOB) to a patient. With STU2, this specification includes guidance on how multiple providers can work together to provide one collective GFE for easier patient understanding of their overall estimated cost for a planned service including all related services or items that may be billed by a different provider. See[Change Log](change_log.md)for additional information. The IG STU2 content relating to the GFE Coordination is marked as DRAFT throughout this guide. The Da Vinci PCT open community of providers, payers, health IT including EHRs, revenue cycle experts, billing specialists, cost estimator experts, clearinghouse experts, and others that have provided requirements and vetted design decisions, recognize that the GFE coordination process is new. Testing this content provides the opportunity to gain feedback broadly and enable better insights as the business process evolves to advance a standard for trial use.Feedback is welcome and may be submitted through the[FHIR change tracker](http://hl7.org/fhir-issues)indicating "US Da Vinci Patient Cost Transparency (PCT)(FHIR)" as the specification.This implementation guide (IG) is dependent on other specifications. Please submit any comments you have on these base specifications as follows:
* Feedback on the FHIR core specification should be submitted to the [FHIR change tracker](http://hl7.org/fhir-issues) with "FHIR Core" as the specification. 
* Feedback on the US core profiles should be submitted to the [FHIR change tracker](http://hl7.org/fhir-issues) with "US Core" as the specification. 
Individuals interested in participating in the Patient Cost Transparency project or other HL7 Da Vinci projects can find information about Da Vinci[here](http://www.hl7.org/about/davinci).

### Overview

This IG provides detailed guidance to support providers and payers exchanging financial information for specific items and services using FHIR-based standards. This exchange involves a provider or group of providers submitting a Good Faith Estimate (GFE) to a patient (if self-pay or uninsured) or a payer. A payer can then generate an Advanced Explanation of Benefits (AEOB) for a patient (and optionally be returned to the submitting provider). The AEOB from the payer, will also include the GFE used to inform the AEOB generation.

When there are multiple providers involved in a patient’s service, these providers may need to coordinate in order to produce one comprehensive GFE. This IG provides guidance on how this collaborative GFE creation process can leverage FHIR. Information about the cost of healthcare items or services may enable better decision making by the patient in consultation with the provider.

The trigger for PCT is at the time of a patient “request” for an estimate or a “scheduled service”.

This IG will reference where possible the “standards” defined by US Core, the Health Record exchange ([HRex](https://hl7.org/fhir/us/davinci-hrex/)) Library/Framework IG, other FHIR IGs, and other industry standards where applicable.

This IG is informed by the [No Surprises Act (see Division BB, Title I, Sections 111 and 112)](https://www.ftc.gov/legal-library/browse/statutes/no-surprises-act-2021-consolidated-appropriations-act), which was enacted as part of the Consolidated Appropriations Act, 2021. The No Surprises Act specifically requires that a provider or providers share a GFE with a patient when the patient is self-pay/uninsured or with a payer for insured patients when the patient schedules a service or requests an estimate. When the payer receives a GFE, the payer must make an AEOB available to a patient in advance of the service.

Understanding the need for multiple providers to be able to work together to produce a single GFE in support of the law, this IG provides guidance on how to create this GFE using FHIR. This IG introduces a GFE coordination workflow that leverages a Coordinating Platform. The Coordinating Platform could be any number of systems - a practice management system, an EHR, a portal, a third party system, etc. When a patient contacts a provider to schedule a service or request an estimate for a service, the provider or facility who schedules the service or receives the request is the convening provider or convening facility per current CMS regulation for uninsured/self-pay patients.

> NOTE: At this time, the Departments have exercised enforcement discretion allowing providers to send separate GFEs to a patient or payer. Further federal regulation on this is anticipated. If the GFE Coordination Workflow is not an option for gathering all of the GFE Bundles from the contributing providers, this Implementation Guide provides a means for separate individual GFE Packet submissions to be linked for a payer to assemble. Helping patients get the best, most usable information to make informed decisions about their care is the objective. If specific guidance is issued that requires adjustments to this IG, the IG will be updated.

The IG supports different methods of information sharing between payers and providers and payers and patients. In this way, the IG can support providers and payers as they work to meet the legislative and future regulatory requirement as well as enable information sharing valuable to supporting patient care. Since the law does not require an API to share these data, the method used to share the required information – an API, a portal, email, etc. – is the decision of the parties engaged in the process. Should future rulemaking mandate a specific scenario, this IG can be revised accordingly.

By using the FHIR standard and implementing this guide, providers and payers can enhance their existing technologies, where applicable, for estimating patient costs securely and efficiently using common open web technologies. The anticipated benefit of using FHIR APIs is to streamline the process of creating a single comprehensive GFE for self-pay/uninsured patients and a single AEOB for insured and to enable applications of the patients’ choice to give greater transparency into patient-specific estimated costs of expected healthcare items and services.

FHIR is being used for consumer access to healthcare related data at significant scale today, and there are regulatory requirements in the form of the CMS Patient Access API for FHIR support for the related use case of post adjudicated claims, namely CARIN for Blue Button®. Use of an industry standard would keep the barrier to stakeholder adoption relatively low.

> Note: The scope of this guide does not include coordination of benefits or more than one coverage. This does not serve as a replacement for eligibility, scheduling, prior authorization or other financial and administrative use cases.

Acronyms used in this IG can be found [here](#terms-and-concepts). The reader of this IG should become familiar with these before reading this IG.

### General Workflow

This guide breaks the process into two main parts in support of the patient cost transparency use case:

1. [GFE Coordination Workflow (Multi-Provider) ](gfe_coordination_overview.md)- Supports the ability for a provider to notify, request, and collect one or more GFEs from other providers that may participate in a set of procedures related to patient’s period of care for which a GFE is required, either to provide to the patient and/or to submit to a payer.
1. [GFE Submission and AEOB Workflow](gfe_submission_and_aeob_overview.md)- Supports the ability for a provider to submit GFE Packets to a payer for them to process and produce an[AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md)to the patient and optionally to the provider. This submission may include GFEs from multiple providers gathered using FHIR separately or a consolidated GFE is gathered in the[GFE Coordination Workflow](gfe_coordination_overview.md).

**Good Faith Estimate and Advanced Explanation of Benefit High Level Workflow** ![](PCT_HighLevelWorkflow.png)

**Figure 1: PCT High Level Workflow Diagram**

#### GFE Submit Workflow

**AEOB Interaction Diagram Steps (High Level View)**

1. A patient schedules a service or requests an estimate for a service which triggers the composition of a GFE.
1. If multiple providers are involved, the Providers involved in the service coordinate on their individual charges and services for the Good Faith Estimate through the[GFE Coordination Workflow](gfe_coordination_overview.md). For self-pay or uninsured patients, the GFE can be made available to the patient at this step.
1. For insured patients, one or more GFEs in a FHIR Bundle resource ([GFE Packet](StructureDefinition-davinci-pct-gfe-packet.md)) is submitted (via the[gfe-submit operation](OperationDefinition-GFE-submit.md)) to the payer’s endpoint for AEOB creation.
1. The payer would then process, applying contracts and benefits, and produce the[AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md).
1. The patient and provider may receive a subscription notification of availability of the AEOB Packet and can retrieve the[AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md)via FHIR query.

> Note: Communication to the patient could be direct from the provider or the payer or through a third-party app via an API.

### Content and Organization

This implementation guide (and the menu for it) is organized into the following sections:

* **Background** - Supporting informative pages that covers the use cases and actors, but does not set conformance expectations 
* [Reading this IG](reading_this_ig.md) points to key pages in the FHIR spec and other source specifications that must be understood to understand this guide
* [Use Cases and Actors](use_cases.md) describes the intent of the implementation guide, gives examples of its use, and provides a high-level overview of expected process flow as well as a description of the business and technical actors involved.
* [GFE Coordination Overview](gfe_coordination_overview.md) describes the use case and workflow of the Good Faith Estimate (GFE) multiple provider coordination use case that describes how providers using varying technologies can coordinate to gather their constituent GFEs to pull together into a single GFE Packet.
* [GFE Submission and AEOB Overview](gfe_submission_and_aeob_overview.md) describes the use case and workflow for a provider to submit a GFE Packet to a payer to request an Advanced Explanation of Benefits (AEOB) for their patient and making that AEOB available.
* [Project and Participants](projects_and_participants.md) gives a high-level overview of Da Vinci and identifies the individuals and organizations involved in developing this implementation guide
 
* **Specification** - Pages that set conformance expectations 
* [Conformance Expectations](formal_specification.md) defines base language and expectations for declaring conformance with the guide
* [GFE Coordination Specification](gfe_coordination_specification.md) describes the conformance requirements for implementers of the multiple provider using varying technologies can coordinate to the creation of a single a single GFE Packet.
* [GFE Submission and AEOB Specification](gfe_submission_and_aeob_specification.md) describes the conformance requirements for a provider submitting a GFE Packet for an insured patient to a payer for an AEOB to be created and made available.
* [Privacy, Safety, and Security](security.md) covers considerations around data access, protection, and similar concepts that apply to all implementations
 
* **FHIR Artifacts** 
* [Artifacts Overview](artifacts.md) introduces and provides links to the profiles, search parameters and other FHIR artifacts used in this implementation guide
 
* **Base Specs** - Quick links to the various specifications this guide derives from
* **Support** - Links to help with use of this guide 
* **Discussion Forum** is a place to ask questions about the guide, discuss potential issues, and search through prior discussions
* **Project Page** includes information about project calls, agendas, past minutes, and instructions for how to participate
* **Implementer Support** provides information about reference implementations, resources for testing, known errata, regulatory considerations, and practical implementation pathways
* **Specification Dashboard** shows new and historical issues that have been logged against the specification, proposed dispositions, unapplied changes, etc.
* **Propose a Change** allows formal submission of requests for change to the specification. (Consider raising the issue on the discussion forum first.)
* [Downloads](downloads.md) allows downloading this and other specifications, as well as other useful files
 

### Terms and Concepts

| | |
| :--- | :--- |
| AEOB | The Consolidated Appropriations Act includes provisions whereby group health plans and health insurance issuers, based on charges, billing and diagnostic codes provided by the provider(s), provide an Advanced Explanation of Benefits for scheduled services or upon request to give patients transparency into their estimated healthcare costs. AEOBs need to include which providers are expected to provide treatment, the network status of providers, good faith estimates of cost, cost-sharing and progress towards meeting deductibles and out-of-pocket maximums, as well as whether a service is subject to medical management and relevant disclaimers of estimates; for example, the disclaimer might state that the information provided in the notification is only an estimate based on the items and services reasonably expected, at the time of scheduling (or requesting) and is subject to change. For a complete breakdown of what needs to be included in the AEOB see 42 U.S. Code 300gg-111(f)(1)(A) through (H). |
| CAAConsolidated Appropriations Act | Also called["H.R. 133".](https://www.ftc.gov/legal-library/browse/statutes/no-surprises-act-2021-consolidated-appropriations-act)The CARES (Coronavirus Aid, Relief, and Economic Security) Act implemented a variety of programs to address issues related to the onset of the COVID-19 pandemic.The Consolidated Appropriations Act continued many of these programs by adding new phases, new allocations, and new guidance to address issues related to the continuation of the COVID-19 pandemic. Title I (the No Surprises Act) of Division BB of the Consolidated Appropriations Act, 2021 establishes new protections from surprise billing and excessive cost sharing for consumers receiving healthcare items/services.The Consolidated Appropriations Act (2021) was passed by Congress on December 21, 2020 and signed into law on December 27, 2020. |
| GFE | The Good Faith Estimate is a notification of reasonably expected charges and billing codes for a scheduled or requested item or service. For a complete breakdown of what needs to be included in the GFE see[42 U.S. Code 300gg-136](https://www.law.cornell.edu/uscode/text/42/300gg-136) |
| HIPAA | The Health Insurance Portability and Accountability Act of 1996 (HIPAA) is a federal law that requires the creation of national standards to protect sensitive patient health information from being disclosed without the patient’s consent or knowledge. The US Department of Health and Human Services (HHS) issued the HIPAA Privacy Rule to implement the requirements of HIPAA. The HIPAA Security Rule protects a subset of information covered by the Privacy Rule. |

### Dependencies

This guide is based on the [FHIR R4](http://hl7.org/fhir/R4/) specification that is mandated for use in the U.S.

In addition, this guide also relies on several ancestor implementation guides:

| | | |
| :--- | :--- | :--- |
| [Da Vinci Health Record Exchange (HRex)](http://hl7.org/fhir/us/davinci-hrex/STU1.1) | [1.1.0](https://simplifier.net/packages/hl7.fhir.us.davinci-hrex/1.1.0) |  |
| [FHIR Extensions Pack](http://hl7.org/fhir/extensions/5.2.0) | [5.2.0](https://simplifier.net/packages/hl7.fhir.uv.extensions.r4/5.2.0) | Automatically added as a dependency - all IGs depend on the HL7 Extension Pack |
| [5.1.0](https://simplifier.net/packages/hl7.fhir.uv.extensions.r4/5.1.0) | Imported by Da Vinci Health Record Exchange (HRex) (and potentially others) | |
| [FHIR R4 package : Core](http://hl7.org/fhir/R4) | [4.0.1](https://simplifier.net/packages/hl7.fhir.r4.core/4.0.1) | Imported by FHIR Extensions Pack (and potentially others) |
| [HL7 Terminology (THO)](http://terminology.hl7.org/5.5.0) | [6.5.0](https://simplifier.net/packages/hl7.terminology.r4/6.5.0) |  |
| [6.1.0](https://simplifier.net/packages/hl7.terminology.r4/6.1.0) | Imported by Da Vinci Health Record Exchange (HRex) (and potentially others) | |
| [5.5.0](https://simplifier.net/packages/hl7.terminology.r4/5.5.0) | Imported by US Core (and potentially others) | |
| [5.0.0](https://simplifier.net/packages/hl7.terminology.r4/5.0.0) | Imported by Subscriptions R5 Backport (and potentially others) | |
| [Public Health Information Network Vocabulary Access and Distribution System (PHIN VADS)](http://fhir.org/packages/us.cdc.phinvads) | [0.12.0](https://simplifier.net/packages/us.cdc.phinvads/0.12.0) | Imported by US Core (and potentially others) |
| [SMART App Launch](http://hl7.org/fhir/smart-app-launch/STU2) | [2.0.0](https://simplifier.net/packages/hl7.fhir.uv.smart-app-launch/2.0.0) | Imported by US Core (and potentially others) |
| [Structured Data Capture](http://hl7.org/fhir/uv/sdc/STU3) | [3.0.0](https://simplifier.net/packages/hl7.fhir.uv.sdc/3.0.0) | Imported by US Core (and potentially others) |
| [Subscriptions R5 Backport](http://hl7.org/fhir/uv/subscriptions-backport/STU1.1) | [1.1.0](https://simplifier.net/packages/hl7.fhir.uv.subscriptions-backport.r4/1.1.0) |  |
| [US Core](http://hl7.org/fhir/us/core/STU7) | [7.0.0](https://simplifier.net/packages/hl7.fhir.us.core/7.0.0) | Needed for systems supporting USCDI v4 |
| [6.1.0](https://simplifier.net/packages/hl7.fhir.us.core/6.1.0) | Needed for systems supporting USCDI v3 | |
| [3.1.1](https://simplifier.net/packages/hl7.fhir.us.core/3.1.1) | Needed for systems supporting USCDI v1 | |
| [Value Set Authority Center (VSAC)](http://fhir.org/packages/us.nlm.vsac) | [0.19.0](https://simplifier.net/packages/us.nlm.vsac/0.19.0) | Imported by Da Vinci Health Record Exchange (HRex) (and potentially others) |
| [0.18.0](https://simplifier.net/packages/us.nlm.vsac/0.18.0) | Imported by US Core (and potentially others) | |

This implementation guide defines additional constraints and usage expectations above and beyond the information found in these base specifications.

### Intellectual Property Considerations

This implementation guide and the underlying FHIR specification are licensed as public domain under the [FHIR license](http://hl7.org/fhir/R4/license.html#license). The license page also describes rules for the use of the FHIR name and logo.

This publication includes IP covered under the following statements.

* © Copyright 2022 American Medical Association

* [NUCC Provider Taxonomy](http://tx.fhir.org/r4/ValueSet/nucc-provider-taxonomy): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 11 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md),[PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md),[PCTPractitioner](StructureDefinition-davinci-pct-practitioner.md)and[ProviderTaxonomy](StructureDefinition-providerTaxonomy.md)


* All X12 products are subject to this IP policy, including published and draft works.X12 is the only organization authorized to grant permission for use of X12 products. Users of all X12 products should make sure that they understand the permissible uses, as well as the limitations on such usage, as outlined below.Additional IP information can be found [here](https://x12.org/products/ip-use) Send an email to ip@x12.org to request permission to reproduce X12 IP. Include your name, organization, title, address, city, state, zip, email, a detailed description of the Submitted Artifact, including the underlying or cited X12 Product, and a detailed description of the intended audience and planned distribution method for the Artifact.Additional information on X12 licensing program can be found [here](https://x12.org/products/licensing-program) To purchase code list subscriptions call (425) 562-2245 or email admin@wpc-edi.com.

* [X12 Claim Adjustment Reason Codes](http://terminology.hl7.org/6.5.0/CodeSystem-X12ClaimAdjustmentReasonCodes.html): [PCTAdjustmentReasonVS](ValueSet-PCTAdjustmentReasonVS.md) and [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md)


* All X12 work products are copyrighted. Any use of any X12 work product must be compliant with US Copyright laws and X12 Intellectual Property policies.Please see [[https://x12.org/products/licensing-program](https://x12.org/products/licensing-program)](https://x12.org/products/licensing-program) 

* [X12 Service Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-X12ServiceTypeCodes.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md)...Show 4 more,[ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)and[PCTBenefitBalanceCategoryVS](ValueSet-PCTBenefitBalanceCategoryVS.md)


* CMS maintains HIPPS. There are no known constraints on the use of HIPPS.

* [Health Insurance Prospective Payment System (HIPPS)](http://terminology.hl7.org/6.5.0/CodeSystem-HIPPS.html): [EstimateProcedureOrService](StructureDefinition-estimateProcedureOrService.md), [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md)...Show 4 more,[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md),[PCTServiceRequest](StructureDefinition-davinci-pct-servicerequest.md)and[USClaimMedicalProductOrServiceCodes](ValueSet-USClaimMedicalProductOrServiceCodes.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AEOBAdjudicationError](StructureDefinition-davinci-pct-aeob-adjudication-error.md), [AEOBComplete](StructureDefinition-davinci-pct-aeob-complete.md)...Show 120 more,[AEOBDateOfService](SearchParameter-aeob-date-of-service.md),[AHANUBCPointOfOriginVS](ValueSet-AHANUBCPointOfOriginVS.md),[AHANUBCPriorityTypeOfAdmissionOrVisitVS](ValueSet-AHANUBCPriorityTypeOfAdmissionOrVisitVS.md),[CoordinationPlatformPatientCostTransparencyCapabilityStatement](CapabilityStatement-davinci-pct-coordination-platform.md),[CoordinationRequesterPatientCostTransparencyCapabilityStatement](CapabilityStatement-davinci-pct-gfe-provider.md),[DocumentReferenceDocStatus](SearchParameter-DocumentReference-doc-status.md),[EstimateCondition](StructureDefinition-estimateCondition.md),[EstimateProcedureOrService](StructureDefinition-estimateProcedureOrService.md),[GFEBillingProviderLineItemCtrlNum](StructureDefinition-gfeBillingProviderLineItemCtrlNum.md),[GFEConsentForBalanceBilling](StructureDefinition-gfeConsentForBalanceBilling.md),[GFEContributorPatientCostTransparencyCapabilityStatement](CapabilityStatement-davinci-pct-gfe-contributor.md),[GFECoordinationRequest](OperationDefinition-GFE-coordination-request.md),[GFEDisclaimer](StructureDefinition-gfeDisclaimer.md),[GFEReference](StructureDefinition-gfeReference.md),[GFERelatedTask](StructureDefinition-gfeRelatedTask.md),[GFERetrieve](OperationDefinition-GFE-retrieve.md),[GFEServiceLinkingInfo](StructureDefinition-gfeServiceLinkingInfo.md),[GFESubmit](OperationDefinition-GFE-submit.md),[GFEValidationError](StructureDefinition-davinci-pct-gfe-validation-error.md),[ICD10ProcedureCodes](ValueSet-ICD10ProcedureCodes.md),[OutOfNetworkProviderInfo](StructureDefinition-inNetworkProviderOptionsLink.md),[PCTAEOBAvailableAuthorSubscription](StructureDefinition-davinci-pct-aeob-available-author-subscription.md),[PCTAEOBAvailableAuthorSubscriptionTopic](SubscriptionTopic-davinci-pct-aeob-available-author-notification.md),[PCTAEOBAvailableSubjectSubscription](StructureDefinition-davinci-pct-aeob-available-subject-subscription.md),[PCTAEOBAvailableSubjectSubscriptionTopic](SubscriptionTopic-davinci-pct-aeob-available-subject-notification.md),[PCTAEOBPacket](StructureDefinition-davinci-pct-aeob-packet.md),[PCTAEOBProcessNoteCS](CodeSystem-PCTAEOBProcessNoteCS.md),[PCTAEOBProcessNoteVS](ValueSet-PCTAEOBProcessNoteVS.md),[PCTAdjudication](CodeSystem-PCTAdjudication.md),[PCTAdjudicationCategoryCS](CodeSystem-PCTAdjudicationCategoryCS.md),[PCTAdjudicationCategoryVS](ValueSet-PCTAdjudicationCategoryVS.md),[PCTAdjudicationVS](ValueSet-PCTAdjudicationVS.md),[PCTAdjustmentReasonVS](ValueSet-PCTAdjustmentReasonVS.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTAdvancedEOBComposition](StructureDefinition-davinci-pct-aeob-composition.md),[PCTAdvancedEOBDocumentReference](StructureDefinition-davinci-pct-aeob-documentreference.md),[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md),[PCTBenefitBalanceCategoryVS](ValueSet-PCTBenefitBalanceCategoryVS.md),[PCTCareTeamRoleVS](ValueSet-PCTCareTeamRoleVS.md),[PCTContributorTaskStatusCodes](ValueSet-PCTContributorTaskStatusCodes.md),[PCTContributorTaskStatusReasonCodes](ValueSet-PCTContributorTaskStatusReasonCodes.md),[PCTCoordinationTaskStatusCodes](ValueSet-PCTCoordinationTaskStatusCodes.md),[PCTCoordinationTaskStatusReasonCodes](ValueSet-PCTCoordinationTaskStatusReasonCodes.md),[PCTCoverage](StructureDefinition-davinci-pct-coverage.md),[PCTDeviceRequest](StructureDefinition-davinci-pct-devicerequest.md),[PCTDiagnosticCodes](ValueSet-PCTDiagnosticCodes.md),[PCTDocumentSection](CodeSystem-PCTDocumentSection.md),[PCTDocumentTypeTemporaryTrialUse](CodeSystem-PCTDocumentTypeTemporaryTrialUse.md),[PCTEstimateTypeSummaryCSTemporaryTrialUse](CodeSystem-PCTEstimateTypeSummaryCSTemporaryTrialUse.md),[PCTFinancialType](CodeSystem-PCTFinancialType.md),[PCTFinancialTypeVS](ValueSet-PCTFinancialTypeVS.md),[PCTGFEAvailableAuthorSubscription](StructureDefinition-davinci-pct-gfe-available-author-subscription.md),[PCTGFEAvailableAuthorSubscriptionTopic](SubscriptionTopic-davinci-pct-gfe-available-author-notification.md),[PCTGFEAvailableSubjectSubscription](StructureDefinition-davinci-pct-gfe-available-subject-subscription.md),[PCTGFEAvailableSubjectSubscriptionTopic](SubscriptionTopic-davinci-pct-gfe-available-subject-notification.md),[PCTGFEBundle](StructureDefinition-davinci-pct-gfe-bundle.md),[PCTGFECMSPOS](ValueSet-PCTGFECMSPOS.md),[PCTGFEComposition](StructureDefinition-davinci-pct-gfe-composition.md),[PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md),[PCTGFECoordinationBundle](StructureDefinition-davinci-pct-gfe-coordination-bundle.md),[PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md),[PCTGFECoordinationTaskSubscriptionTopic](SubscriptionTopic-davinci-pct-gfe-coordination-task-notification.md),[PCTGFEDocumentReference](StructureDefinition-davinci-pct-gfe-documentreference.md),[PCTGFEInformationBundle](StructureDefinition-davinci-pct-gfe-information-bundle.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEItemCptHcpcsVS](ValueSet-PCTGFEItemCptHcpcsVS.md),[PCTGFEItemNDCVS](ValueSet-PCTGFEItemNDCVS.md),[PCTGFEItemRevenueVS](ValueSet-PCTGFEItemRevenueVS.md),[PCTGFEMissingBundle](StructureDefinition-davinci-pct-gfe-missing-bundle.md),[PCTGFEPacket](StructureDefinition-davinci-pct-gfe-packet.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md),[PCTGFERequestTypeCSTemporaryTrialUse](CodeSystem-PCTGFERequestTypeCSTemporaryTrialUse.md),[PCTGFERequestTypeVS](ValueSet-PCTGFERequestTypeVS.md),[PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md),[PCTGFETaskRelationship](ValueSet-PCTGFETaskRelationship.md),[PCTGFETaskUpdateSubscription](StructureDefinition-davinci-pct-gfe-task-update-subscription.md),[PCTGFETypeOfBillVS](ValueSet-PCTGFETypeOfBillVS.md),[PCTMedicationRequest](StructureDefinition-davinci-pct-medicationrequest.md),[PCTNetworkStatusCS](CodeSystem-PCTNetworkStatusCS.md),[PCTOrgContactPurposeType](CodeSystem-PCTOrgContactPurposeType.md),[PCTOrgContactPurposeTypeVS](ValueSet-PCTOrgContactPurposeTypeVS.md),[PCTOrganization](StructureDefinition-davinci-pct-organization.md),[PCTOrganizationTypeVS](ValueSet-PCTOrganizationTypeVS.md),[PCTPayerBenefitPaymentStatusVS](ValueSet-PCTPayerBenefitPaymentStatusVS.md),[PCTPayerProviderNetworkStatusVS](ValueSet-PCTPayerProviderNetworkStatusVS.md),[PCTPractitioner](StructureDefinition-davinci-pct-practitioner.md),[PCTProcedureSurgicalCodes](ValueSet-PCTProcedureSurgicalCodes.md),[PCTProcedureType](CodeSystem-PCTProcedureType.md),[PCTProcedureTypeVS](ValueSet-PCTProcedureTypeVS.md),[PCTServiceLocation](StructureDefinition-davinci-pct-service-location.md),[PCTServiceRequest](StructureDefinition-davinci-pct-servicerequest.md),[PCTSupportingInfoType](CodeSystem-PCTSupportingInfoType.md),[PCTSupportingInfoTypeVS](ValueSet-PCTSupportingInfoTypeVS.md),[PCTTaskAttachmentContentType](ValueSet-PCTTaskAttachmentContentType.md),[PCTTaskBusinessStatusCSTemporaryTrialUse](CodeSystem-PCTTaskBusinessStatusCSTemporaryTrialUse.md),[PCTTaskBusinessStatusCodes](ValueSet-PCTTaskBusinessStatusCodes.md),[PCTTaskStatusReasonCSTemporaryTrialUse](CodeSystem-PCTTaskStatusReasonCSTemporaryTrialUse.md),[PCTTotal](ValueSet-PCTTotal.md),[PacketCondition](SearchParameter-packet-condition.md),[PacketLinkingIdentifier](SearchParameter-packet-linking-identifier.md),[PacketPlannedPeriodOfService](SearchParameter-packet-PlannedPeriodOfService.md),[PacketProcedureOrService](SearchParameter-packet-procedure-or-service.md),[PacketRequestInitiationTime](SearchParameter-packet-request-initiation-time.md),[PatientCostTransparency](index.md),[PatientCostTransparencyCapabilityStatement](CapabilityStatement-davinci-pct.md),[PlannedServicePeriod](StructureDefinition-plannedServicePeriod.md),[ProcessNoteClass](StructureDefinition-processNoteClass.md),[ProviderEventMethodology](StructureDefinition-providerEventMethodology.md),[ProviderTaxonomy](StructureDefinition-providerTaxonomy.md),[ReferralNumber](StructureDefinition-referralNumber.md),[RelatedTask](SearchParameter-related-task.md),[RemainingBenefit](StructureDefinition-remaining-benefit.md),[RequestInitiationTime](StructureDefinition-requestInitiationTime.md),[RequestOriginationType](StructureDefinition-requestOriginationType.md),[SelfPayDeclared](StructureDefinition-selfPayDeclared.md),[ServiceDescription](StructureDefinition-serviceDescription.md),[SubjectToMedicalMgmt](StructureDefinition-subjectToMedicalMgmt.md),[TaskRequestedPeriod](SearchParameter-task-requested-period.md),[USClaimDRGCodes](ValueSet-USClaimDRGCodes.md)and[USClaimMedicalProductOrServiceCodes](ValueSet-USClaimMedicalProductOrServiceCodes.md)


* Licensing information can be found [here](https://www.nubc.org/license) These codes are listed within the UB-04 Data Specifications Manual. The Official UB-04 Data Specifications Manual, copyrighted by the American Hospital Association, is the only official source of UB-04 billing information adopted by the National Uniform Billing Committee. No other publication—governmental or private/commercial—can be considered authoritative. The AHA wants to make you aware that the use of codes, descriptions, or any other content contained in the manual to be used in a software application, publication, or any other derivative work must be properly licensed by the AHA. If your organization uses or intends to use any of the codes or other related content from the manual in this manner, please contact the AHA’s licensing manager, Tim Carlson, at 312.893.6816 or tcarlson@aha.org

* [AHA NUBC Revenue Codes](http://terminology.hl7.org/6.5.0/CodeSystem-AHANUBCRevenueCodes.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 7 more,[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md)and[PCTGFEItemRevenueVS](ValueSet-PCTGFEItemRevenueVS.md)
* [AHA NUBC Type Of Bill Codes](http://terminology.hl7.org/6.5.0/CodeSystem-AHANUBCTypeOfBill.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 6 more,[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md)and[PCTGFETypeOfBillVS](ValueSet-PCTGFETypeOfBillVS.md)


* The Centers for Medicare & Medicaid Services (CMS) maintain MS-DRGs used throughout the US health care industry. The CMS MS-DRGs are free to use without restriction.

* [Medicare Severity Diagnosis Related Groups (MS-DRGs)](http://terminology.hl7.org/6.5.0/CodeSystem-MSDRG.html): [PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md) and [USClaimDRGCodes](ValueSet-USClaimDRGCodes.md)


* This CodeSystem is not copyrighted.

* [PCT AEOB Process Note Code System](CodeSystem-PCTAEOBProcessNoteCS.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md), [ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md), [PCTAEOBProcessNoteVS](ValueSet-PCTAEOBProcessNoteVS.md) and [ProcessNoteClass](StructureDefinition-processNoteClass.md)
* [PCT Adjudication Code System](CodeSystem-PCTAdjudication.md): [PCTAdjudicationVS](ValueSet-PCTAdjudicationVS.md), [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md) and [PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)
* [PCT Packet Section Codes](CodeSystem-PCTDocumentSection.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md), [Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md), [PCTAdvancedEOBComposition](StructureDefinition-davinci-pct-aeob-composition.md) and [PCTGFEComposition](StructureDefinition-davinci-pct-gfe-composition.md)
* [PCT Document Types](CodeSystem-PCTDocumentTypeTemporaryTrialUse.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Coordination-Bundle-1](Bundle-PCT-GFE-Coordination-Bundle-1.md)...Show 13 more,[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[DocumentReference/PCT-AEOB-DocumentReference-1](DocumentReference-PCT-AEOB-DocumentReference-1.md),[DocumentReference/PCT-GFE-DocumentReference-Inst-1](DocumentReference-PCT-GFE-DocumentReference-Inst-1.md),[DocumentReference/PCT-GFE-DocumentReference-Prof-1](DocumentReference-PCT-GFE-DocumentReference-Prof-1.md),[PCTAdvancedEOBComposition](StructureDefinition-davinci-pct-aeob-composition.md),[PCTAdvancedEOBDocumentReference](StructureDefinition-davinci-pct-aeob-documentreference.md),[PCTGFEComposition](StructureDefinition-davinci-pct-gfe-composition.md),[PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md),[PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md),[PCTGFEDocumentReference](StructureDefinition-davinci-pct-gfe-documentreference.md),[Task/PCT-GFE-Coordination-Replacement-Task-1](Task-PCT-GFE-Coordination-Replacement-Task-1.md)and[Task/PCT-GFE-Coordination-Task-1](Task-PCT-GFE-Coordination-Task-1.md)
* [PCT Estimate Type Code System](CodeSystem-PCTEstimateTypeSummaryCSTemporaryTrialUse.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 8 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Summary-1](Claim-PCT-GFE-Summary-1.md),[Claim/PCT-GFE-Summary-MRI](Claim-PCT-GFE-Summary-MRI.md),[ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md),[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)and[PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md)
* [PCT Financial Type Code System](CodeSystem-PCTFinancialType.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md)...Show 4 more,[ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)and[PCTFinancialTypeVS](ValueSet-PCTFinancialTypeVS.md)
* [PCT GFE Request Type Codes Code System](CodeSystem-PCTGFERequestTypeCSTemporaryTrialUse.md): [Bundle/PCT-GFE-Coordination-Bundle-1](Bundle-PCT-GFE-Coordination-Bundle-1.md), [Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md)...Show 11 more,[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md),[PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md),[PCTGFERequestTypeVS](ValueSet-PCTGFERequestTypeVS.md),[RequestOriginationType](StructureDefinition-requestOriginationType.md),[Task/PCT-GFE-Contributor-Replacement-Task-1](Task-PCT-GFE-Contributor-Replacement-Task-1.md),[Task/PCT-GFE-Contributor-Replacement-Task-2](Task-PCT-GFE-Contributor-Replacement-Task-2.md),[Task/PCT-GFE-Contributor-Task-1](Task-PCT-GFE-Contributor-Task-1.md),[Task/PCT-GFE-Contributor-Task-2](Task-PCT-GFE-Contributor-Task-2.md),[Task/PCT-GFE-Coordination-Replacement-Task-1](Task-PCT-GFE-Coordination-Replacement-Task-1.md)and[Task/PCT-GFE-Coordination-Task-1](Task-PCT-GFE-Coordination-Task-1.md)
* [PCT Network Status](CodeSystem-PCTNetworkStatusCS.md): [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md), [PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md), [PCTPayerBenefitPaymentStatusVS](ValueSet-PCTPayerBenefitPaymentStatusVS.md), [PCTPayerProviderNetworkStatusVS](ValueSet-PCTPayerProviderNetworkStatusVS.md) and [PCTTotal](ValueSet-PCTTotal.md)
* [PCT Organization Contact Purpose Type Code System](CodeSystem-PCTOrgContactPurposeType.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 4 more,[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[GFE Service Help INC.](Organization-Submitter-Org-1.md),[PCTOrgContactPurposeTypeVS](ValueSet-PCTOrgContactPurposeTypeVS.md)and[PCTOrganization](StructureDefinition-davinci-pct-organization.md)
* [PCT Procedure Type](CodeSystem-PCTProcedureType.md): [PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md), [PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md), [PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md) and [PCTProcedureTypeVS](ValueSet-PCTProcedureTypeVS.md)
* [PCT GFE Supporting Info Type Code System](CodeSystem-PCTSupportingInfoType.md): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 6 more,[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md)and[PCTSupportingInfoTypeVS](ValueSet-PCTSupportingInfoTypeVS.md)
* [PCT GFE Request Task Business Status Code System](CodeSystem-PCTTaskBusinessStatusCSTemporaryTrialUse.md): [PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md), [PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md) and [PCTTaskBusinessStatusCodes](ValueSet-PCTTaskBusinessStatusCodes.md)
* [PCT GFE Request Task Status Reason Code Code System](CodeSystem-PCTTaskStatusReasonCSTemporaryTrialUse.md): [PCTContributorTaskStatusReasonCodes](ValueSet-PCTContributorTaskStatusReasonCodes.md), [PCTCoordinationTaskStatusReasonCodes](ValueSet-PCTCoordinationTaskStatusReasonCodes.md), [PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md) and [PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md)...Show 9 more,[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[DocumentReference/PCT-AEOB-DocumentReference-1](DocumentReference-PCT-AEOB-DocumentReference-1.md),[DocumentReference/PCT-GFE-DocumentReference-Inst-1](DocumentReference-PCT-GFE-DocumentReference-Inst-1.md),[DocumentReference/PCT-GFE-DocumentReference-Prof-1](DocumentReference-PCT-GFE-DocumentReference-Prof-1.md),[PCTAdvancedEOBComposition](StructureDefinition-davinci-pct-aeob-composition.md),[PCTAdvancedEOBDocumentReference](StructureDefinition-davinci-pct-aeob-documentreference.md),[PCTGFEComposition](StructureDefinition-davinci-pct-gfe-composition.md),[PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md)and[PCTGFEDocumentReference](StructureDefinition-davinci-pct-gfe-documentreference.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Adjudication Value Codes](http://terminology.hl7.org/6.5.0/CodeSystem-adjudication.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md)...Show 5 more,[ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md),[PCTAdjudicationCategoryVS](ValueSet-PCTAdjudicationCategoryVS.md),[PCTAdjudicationVS](ValueSet-PCTAdjudicationVS.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md)and[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)
* [Benefit Term Codes](http://terminology.hl7.org/6.5.0/CodeSystem-benefit-term.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md), [ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md), [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md) and [PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)
* [Unit Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-benefit-unit.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md), [ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md), [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md) and [PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md)
* [Claim Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-claim-type.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 10 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md)and[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md)
* [Claim Care Team Role Codes](http://terminology.hl7.org/6.5.0/CodeSystem-claimcareteamrole.html): [PCTCareTeamRoleVS](ValueSet-PCTCareTeamRoleVS.md), [PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md), [PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md) and [PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md)
* [Contact entity type](http://terminology.hl7.org/6.5.0/CodeSystem-contactentity-type.html): [PCTOrgContactPurposeTypeVS](ValueSet-PCTOrgContactPurposeTypeVS.md) and [PCTOrganization](StructureDefinition-davinci-pct-organization.md)
* [Coverage Class Codes](http://terminology.hl7.org/6.5.0/CodeSystem-coverage-class.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 7 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Coverage/coverage1001](Coverage-coverage1001.md)and[PCTCoverage](StructureDefinition-davinci-pct-coverage.md)
* [Coverage Copay Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-coverage-copay-type.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 7 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Coverage/coverage1001](Coverage-coverage1001.md)and[PCTCoverage](StructureDefinition-davinci-pct-coverage.md)
* [DataAbsentReason](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html): [EstimateProcedureOrService](StructureDefinition-estimateProcedureOrService.md), [PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md)...Show 4 more,[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md),[PCTServiceRequest](StructureDefinition-davinci-pct-servicerequest.md)and[USClaimMedicalProductOrServiceCodes](ValueSet-USClaimMedicalProductOrServiceCodes.md)
* [Diagnosis Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-diagnosistype.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 11 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[Claim/PCT-GFE-Summary-1](Claim-PCT-GFE-Summary-1.md),[Claim/PCT-GFE-Summary-MRI](Claim-PCT-GFE-Summary-MRI.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md)and[PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md)
* [Example Diagnosis Related Group Codes](http://terminology.hl7.org/6.5.0/CodeSystem-ex-diagnosisrelatedgroup.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 8 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[Claim/PCT-GFE-Summary-1](Claim-PCT-GFE-Summary-1.md)and[Claim/PCT-GFE-Summary-MRI](Claim-PCT-GFE-Summary-MRI.md)
* [Example Procedure Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-ex-procedure-type.html): [PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md), [PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md), [PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md) and [PCTProcedureTypeVS](ValueSet-PCTProcedureTypeVS.md)
* [Medical Management Type](http://terminology.hl7.org/6.5.0/CodeSystem-medical-management-type.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md) and [SubjectToMedicalMgmt](StructureDefinition-subjectToMedicalMgmt.md)
* [Organization type](http://terminology.hl7.org/6.5.0/CodeSystem-organization-type.html): [Boston Radiology Center](Organization-org1002.md), [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md)...Show 8 more,[Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md),[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[GFE Service Help INC.](Organization-Submitter-Org-1.md)and[Umbrella Insurance Company](Organization-org1001.md)
* [Payee Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-payeetype.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 6 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md)and[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md)
* [Process Priority Codes](http://terminology.hl7.org/6.5.0/CodeSystem-processpriority.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 14 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[Claim/PCT-GFE-Summary-1](Claim-PCT-GFE-Summary-1.md),[Claim/PCT-GFE-Summary-MRI](Claim-PCT-GFE-Summary-MRI.md),[ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTAdvancedEOBSummary](StructureDefinition-davinci-pct-aeob-summary.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md)and[PCTGFESummary](StructureDefinition-davinci-pct-gfe-summary.md)
* [SubscriberPolicyholder Relationship Codes](http://terminology.hl7.org/6.5.0/CodeSystem-subscriber-relationship.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 7 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Coverage/coverage1001](Coverage-coverage1001.md)and[Coverage/selfpaycoverage2001](Coverage-selfpaycoverage2001.md)
* [identifierType](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0203.html): [Boston Radiology Center](Organization-org1002.md), [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md)...Show 21 more,[Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md),[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md),[Claim/PCT-GFE-Institutional-1](Claim-PCT-GFE-Institutional-1.md),[Claim/PCT-GFE-Institutional-MRI](Claim-PCT-GFE-Institutional-MRI.md),[Claim/PCT-GFE-Professional-MRI](Claim-PCT-GFE-Professional-MRI.md),[ExplanationOfBenefit/PCT-AEOB-1](ExplanationOfBenefit-PCT-AEOB-1.md),[GFE Service Help INC.](Organization-Submitter-Org-1.md),[PCTAdvancedEOB](StructureDefinition-davinci-pct-aeob.md),[PCTCoverage](StructureDefinition-davinci-pct-coverage.md),[PCTGFEContributorTask](StructureDefinition-davinci-pct-gfe-contributor-task.md),[PCTGFECoordinationTask](StructureDefinition-davinci-pct-gfe-coordination-task.md),[PCTGFEInstitutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCTGFEProfessional](StructureDefinition-davinci-pct-gfe-professional.md),[PCTOrganization](StructureDefinition-davinci-pct-organization.md),[PCTPractitioner](StructureDefinition-davinci-pct-practitioner.md),[Practitioner/Submitter-Practitioner-1](Practitioner-Submitter-Practitioner-1.md)and[Umbrella Insurance Company](Organization-org1001.md)
* [ActRelationshipType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActRelationshipType.html): [GFERelatedTask](StructureDefinition-gfeRelatedTask.md), [PCTGFETaskRelationship](ValueSet-PCTGFETaskRelationship.md), [Task/PCT-GFE-Contributor-Replacement-Task-1](Task-PCT-GFE-Contributor-Replacement-Task-1.md), [Task/PCT-GFE-Contributor-Replacement-Task-2](Task-PCT-GFE-Contributor-Replacement-Task-2.md) and [Task/PCT-GFE-Coordination-Replacement-Task-1](Task-PCT-GFE-Coordination-Replacement-Task-1.md)
* [MaritalStatus](http://terminology.hl7.org/6.5.0/CodeSystem-v3-MaritalStatus.html): [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md)...Show 6 more,[Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md),[Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md),[Bundle/PCT-GFE-Missing-Bundle-1](Bundle-PCT-GFE-Missing-Bundle-1.md),[Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md),[Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md)and[Patient/patient1001](Patient-patient1001.md)
* [RoleCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-RoleCode.html): [Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md) and [Hospital](Location-PCT-ServiceLocation-1.md)


* Using RxNorm codes of type SAB=RXNORM as this specification describes does not require a UMLS license. Access to the full set of RxNorm definitions, and/or additional use of other RxNorm structures and information requires a UMLS license. The use of RxNorm in this specification is pursuant to HL7's status as a licensee of the NLM UMLS. HL7's license does not convey the right to use RxNorm to any users of this specification; implementers must acquire a license to use RxNorm in their own right.

* [RxNorm](http://terminology.hl7.org/6.5.0/CodeSystem-v3-rxNorm.html): [MedicationRequest/PCT-MedicationRequest-1](MedicationRequest-PCT-MedicationRequest-1.md)


