# PCT-GFE-Coordination-Replacement-Task-1 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT-GFE-Coordination-Replacement-Task-1**

## Example Task: PCT-GFE-Coordination-Replacement-Task-1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT GFE Coordination Task](StructureDefinition-davinci-pct-gfe-coordination-task.md)

**Request Initiation Time**: 2024-03-28 11:01:00+0500

**Extension Definition for Task.requestedPeriod for Version 5.0**: ?? --> 2024-03-31 11:01:00+0500

**Planned Service Period**: 2024-04-29 10:00:00+0500 --> 2024-04-29 11:00:00+0500

> **GFERelatedTask**
* relationship: replaces
* related: [Task GFE Coordination Task](Task-PCT-GFE-Coordination-Task-1.md)
* description: 

Change to Planned period of Service

**status**: Requested

**intent**: order

**code**: GFE Coordination Task

**requester**: [Organization GFE Service Help INC.](Organization-Submitter-Org-1.md)

**reasonCode**: Scheduled Service Request

### Inputs

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Value[x]** |
| * | GFE Information Bundle | [Bundle: identifier = http://example.com/identifiers/bundle#59688475-2324-3242-2347384711; type = collection; timestamp = 2024-03-27 11:01:00+0500](Bundle-PCT-GFE-Information-Bundle-1.md) |



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "PCT-GFE-Coordination-Replacement-Task-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-coordination-task"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/requestInitiationTime",
      "valueInstant" : "2024-03-28T11:01:00+05:00"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Task.requestedPeriod",
      "valuePeriod" : {
        "end" : "2024-03-31T11:01:00+05:00"
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/plannedServicePeriod",
      "valuePeriod" : {
        "start" : "2024-04-29T10:00:00+05:00",
        "end" : "2024-04-29T11:00:00+05:00"
      }
    },
    {
      "extension" : [
        {
          "url" : "relationship",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActRelationshipType",
                "version" : "4.0.0",
                "code" : "RPLC",
                "display" : "replaces"
              }
            ]
          }
        },
        {
          "url" : "related",
          "valueReference" : {
            "reference" : "Task/PCT-GFE-Coordination-Task-1"
          }
        },
        {
          "url" : "description",
          "valueMarkdown" : "Change to Planned period of Service"
        }
      ],
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeRelatedTask"
    }
  ],
  "status" : "requested",
  "intent" : "order",
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse",
        "code" : "gfe-coordination-task"
      }
    ]
  },
  "requester" : {
    "reference" : "Organization/Submitter-Org-1"
  },
  "reasonCode" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse",
        "code" : "scheduled-request"
      }
    ]
  },
  "input" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentTypeTemporaryTrialUse",
            "code" : "gfe-information-bundle"
          }
        ],
        "text" : "GFE Information Bundle"
      },
      "valueReference" : {
        "reference" : "Bundle/PCT-GFE-Information-Bundle-1"
      }
    }
  ]
}

```
