# PCT-GFE-Contributor-Task-1 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT-GFE-Contributor-Task-1**

## Example Task: PCT-GFE-Contributor-Task-1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT GFE Contributor Task](StructureDefinition-davinci-pct-gfe-contributor-task.md)

**Request Initiation Time**: 2024-03-27 11:01:00+0500

**Extension Definition for Task.requestedPeriod for Version 5.0**: ?? --> 2024-03-30 11:01:00+0500

**Planned Service Period**: 2024-04-27 10:00:00+0500 --> 2024-04-27 11:00:00+0500

**partOf**: [Task GFE Coordination Task](Task-PCT-GFE-Coordination-Task-1.md)

**status**: Received

**intent**: order

**code**: GFE Contributor Task

**requester**: [Organization GFE Service Help INC.](Organization-Submitter-Org-1.md)

**owner**: [Organization GFE Service Help INC.](Organization-Submitter-Org-1.md)



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "PCT-GFE-Contributor-Task-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-contributor-task"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/requestInitiationTime",
      "valueInstant" : "2024-03-27T11:01:00+05:00"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Task.requestedPeriod",
      "valuePeriod" : {
        "end" : "2024-03-30T11:01:00+05:00"
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/plannedServicePeriod",
      "valuePeriod" : {
        "start" : "2024-04-27T10:00:00+05:00",
        "end" : "2024-04-27T11:00:00+05:00"
      }
    }
  ],
  "partOf" : [
    {
      "reference" : "Task/PCT-GFE-Coordination-Task-1"
    }
  ],
  "status" : "received",
  "intent" : "order",
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse",
        "code" : "gfe-contributor-task"
      }
    ]
  },
  "requester" : {
    "reference" : "Organization/Submitter-Org-1"
  },
  "owner" : {
    "reference" : "Organization/Submitter-Org-1"
  }
}

```
