# example-gfe-task-subscription - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **example-gfe-task-subscription**

## Example Subscription: example-gfe-task-subscription

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [Subscription - GFE Coordination Task Update Notification](StructureDefinition-davinci-pct-gfe-task-update-subscription.md)

**status**: Active

**end**: 2025-05-20 03:33:12+0000

**reason**: Test of PCT Subscriptions

**criteria**: http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-gfe-coordination-task-notification

### Channels

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Type** | **Endpoint** | **Payload** |
| * | Rest Hook | [https://example.com/fhir/r4/$subscription-hook](https://example.com/fhir/r4/$subscription-hook) | application/fhir+json |



## Resource Content

```json
{
  "resourceType" : "Subscription",
  "id" : "example-gfe-task-subscription",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-task-update-subscription"
    ]
  },
  "status" : "active",
  "end" : "2025-05-20T03:33:12.7238087+00:00",
  "reason" : "Test of PCT Subscriptions",
  "criteria" : "http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-gfe-coordination-task-notification",
  "_criteria" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-filter-criteria",
        "valueString" : "Task?requester=Organization/Submitter-Org-1"
      }
    ]
  },
  "channel" : {
    "type" : "rest-hook",
    "endpoint" : "https://example.com/fhir/r4/$subscription-hook",
    "payload" : "application/fhir+json",
    "_payload" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-payload-content",
          "valueCode" : "full-resource"
        }
      ]
    }
  }
}

```
