# Request Initiation Time - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Request Initiation Time**

## Extension: Request Initiation Time 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/requestInitiationTime | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:RequestInitiationTime |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.44 | | |

Instant from which the request is being initiated.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [PCT AEOB Composition](StructureDefinition-davinci-pct-aeob-composition.md), [PCT AEOB Packet Document Reference](StructureDefinition-davinci-pct-aeob-documentreference.md), [PCT GFE Composition](StructureDefinition-davinci-pct-gfe-composition.md), [PCT GFE Contributor Task](StructureDefinition-davinci-pct-gfe-contributor-task.md)...Show 2 more,[PCT GFE Coordination Task](StructureDefinition-davinci-pct-gfe-coordination-task.md)and[PCT GFE Packet Document Reference](StructureDefinition-davinci-pct-gfe-documentreference.md)
* Examples for this Extension: [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md), [Bundle/PCT-GFE-Coordination-Bundle-1](Bundle-PCT-GFE-Coordination-Bundle-1.md), [Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md), [Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md)...Show 9 more,[DocumentReference/PCT-AEOB-DocumentReference-1](DocumentReference-PCT-AEOB-DocumentReference-1.md),[DocumentReference/PCT-GFE-DocumentReference-Inst-1](DocumentReference-PCT-GFE-DocumentReference-Inst-1.md),[DocumentReference/PCT-GFE-DocumentReference-Prof-1](DocumentReference-PCT-GFE-DocumentReference-Prof-1.md),[Task/PCT-GFE-Contributor-Replacement-Task-1](Task-PCT-GFE-Contributor-Replacement-Task-1.md),[Task/PCT-GFE-Contributor-Replacement-Task-2](Task-PCT-GFE-Contributor-Replacement-Task-2.md),[Task/PCT-GFE-Contributor-Task-1](Task-PCT-GFE-Contributor-Task-1.md),[Task/PCT-GFE-Contributor-Task-2](Task-PCT-GFE-Contributor-Task-2.md),[Task/PCT-GFE-Coordination-Replacement-Task-1](Task-PCT-GFE-Coordination-Replacement-Task-1.md)and[Task/PCT-GFE-Coordination-Task-1](Task-PCT-GFE-Coordination-Task-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/requestInitiationTime)

**Changes since version 1.1.0:**

* New Content

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-requestInitiationTime.csv), [Excel](StructureDefinition-requestInitiationTime.xlsx), [Schematron](StructureDefinition-requestInitiationTime.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "requestInitiationTime",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/requestInitiationTime",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.44"
    }
  ],
  "version" : "2.0.0",
  "name" : "RequestInitiationTime",
  "title" : "Request Initiation Time",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Instant from which the request is being initiated.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Task"
    },
    {
      "type" : "element",
      "expression" : "DocumentReference"
    },
    {
      "type" : "element",
      "expression" : "Composition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Request Initiation Time",
        "definition" : "Instant from which the request is being initiated."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/requestInitiationTime"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Estimate Request instant",
        "comment" : "Instant from which the event that triggered the need for an estimate took place. For the GFE request made to a provider or set of providers to fulfill, this is the date and time the patient or their representative made the request or the time of the service scheduling activity (as opposed to the planned time of service). For an AEOB request made to a payer to fulfill, this is the time in which the GFE submission was made to the payer.",
        "min" : 1,
        "type" : [
          {
            "code" : "instant"
          }
        ]
      }
    ]
  }
}

```
