# PCT Practitioner - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT Practitioner**

## Resource Profile: PCT Practitioner 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PCTPractitioner |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.20 | | |

 
The PCT Practitioner profile builds upon the US Core Practitioner profile. It is used to convey information about the practitioner who will be providing services to the patient as described on the GFE. 

**Usages:**

* Use this Profile: [PCT AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md), [PCT GFE Bundle](StructureDefinition-davinci-pct-gfe-bundle.md), [PCT GFE Information Bundle](StructureDefinition-davinci-pct-gfe-information-bundle.md), [PCT GFE Missing Bundle](StructureDefinition-davinci-pct-gfe-missing-bundle.md) and [PCT GFE Packet](StructureDefinition-davinci-pct-gfe-packet.md)
* Refer to this Profile: [PCT AEOB Composition](StructureDefinition-davinci-pct-aeob-composition.md), [PCT AEOB Packet Document Reference](StructureDefinition-davinci-pct-aeob-documentreference.md), [PCT Advanced EOB](StructureDefinition-davinci-pct-aeob.md), [PCT GFE Composition](StructureDefinition-davinci-pct-gfe-composition.md)...Show 6 more,[PCT GFE Contributor Task](StructureDefinition-davinci-pct-gfe-contributor-task.md),[PCT GFE Coordination Task](StructureDefinition-davinci-pct-gfe-coordination-task.md),[PCT GFE Packet Document Reference](StructureDefinition-davinci-pct-gfe-documentreference.md),[PCT Good Faith Estimate Institutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCT Good Faith Estimate Professional](StructureDefinition-davinci-pct-gfe-professional.md)and[PCT Good Faith Estimate Summary](StructureDefinition-davinci-pct-gfe-summary.md)
* Examples for this Profile: [Practitioner/Submitter-Practitioner-1](Practitioner-Submitter-Practitioner-1.md), [Practitioner/prac001](Practitioner-prac001.md) and [Practitioner/prac002](Practitioner-prac002.md)
* CapabilityStatements using this Profile: [Patient Cost Transparency Implementation Guide Coordination Platform Capability Statement](CapabilityStatement-davinci-pct-coordination-platform.md), [Patient Cost Transparency Implementation Guide Coordination Requester Capability Statement](CapabilityStatement-davinci-pct-coordination-requester.md) and [Patient Cost Transparency Implementation Guide Payer Capability Statement](CapabilityStatement-davinci-pct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-practitioner)

**Changes since version 1.1.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-practitioner.csv), [Excel](StructureDefinition-davinci-pct-practitioner.xlsx), [Schematron](StructureDefinition-davinci-pct-practitioner.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-practitioner",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.20"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTPractitioner",
  "title" : "PCT Practitioner",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "The PCT Practitioner profile builds upon the US Core Practitioner profile. It is used to convey information about the practitioner who will be providing services to the patient as described on the GFE.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|7.0.0",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner.identifier:NPI",
        "path" : "Practitioner.identifier",
        "sliceName" : "NPI",
        "short" : "The National Provider Identifier assigned to the provider.",
        "max" : "1"
      },
      {
        "id" : "Practitioner.identifier:ETIN",
        "path" : "Practitioner.identifier",
        "sliceName" : "ETIN",
        "short" : "The submitter's Electronic Transmitter Identification Number.",
        "min" : 0,
        "max" : "1",
        "patternIdentifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                "code" : "ETIN"
              }
            ]
          }
        },
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:tin",
        "path" : "Practitioner.identifier",
        "sliceName" : "tin",
        "short" : "Tax ID Number",
        "min" : 0,
        "max" : "1",
        "patternIdentifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                "code" : "TAX"
              }
            ]
          }
        },
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name.given",
        "path" : "Practitioner.name.given",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Practitioner.qualification.code",
        "path" : "Practitioner.qualification.code",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-NUCCProviderCodes|3.0.0"
        }
      }
    ]
  }
}

```
