# PCT Organization - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT Organization**

## Resource Profile: PCT Organization 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PCTOrganization |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.19 | | |

 
The PCT Organization profile builds upon the US Core Organization profile. It is used to convey a payer, provider, payee, or service facility organization. 

**Usages:**

* Use this Profile: [PCT AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md), [PCT GFE Bundle](StructureDefinition-davinci-pct-gfe-bundle.md), [PCT GFE Information Bundle](StructureDefinition-davinci-pct-gfe-information-bundle.md), [PCT GFE Missing Bundle](StructureDefinition-davinci-pct-gfe-missing-bundle.md) and [PCT GFE Packet](StructureDefinition-davinci-pct-gfe-packet.md)
* Refer to this Profile: [PCT AEOB Composition](StructureDefinition-davinci-pct-aeob-composition.md), [PCT AEOB Packet Document Reference](StructureDefinition-davinci-pct-aeob-documentreference.md), [PCT Advanced EOB Summary](StructureDefinition-davinci-pct-aeob-summary.md), [PCT Advanced EOB](StructureDefinition-davinci-pct-aeob.md)...Show 8 more,[PCT Coverage](StructureDefinition-davinci-pct-coverage.md),[PCT GFE Composition](StructureDefinition-davinci-pct-gfe-composition.md),[PCT GFE Contributor Task](StructureDefinition-davinci-pct-gfe-contributor-task.md),[PCT GFE Coordination Task](StructureDefinition-davinci-pct-gfe-coordination-task.md),[PCT GFE Packet Document Reference](StructureDefinition-davinci-pct-gfe-documentreference.md),[PCT Good Faith Estimate Institutional](StructureDefinition-davinci-pct-gfe-institutional.md),[PCT Good Faith Estimate Professional](StructureDefinition-davinci-pct-gfe-professional.md)and[PCT Good Faith Estimate Summary](StructureDefinition-davinci-pct-gfe-summary.md)
* Examples for this Profile: [GFE Service Help INC.](Organization-Submitter-Org-1.md), [Umbrella Insurance Company](Organization-org1001.md) and [Boston Radiology Center](Organization-org1002.md)
* CapabilityStatements using this Profile: [Patient Cost Transparency Implementation Guide Coordination Platform Capability Statement](CapabilityStatement-davinci-pct-coordination-platform.md), [Patient Cost Transparency Implementation Guide Coordination Requester Capability Statement](CapabilityStatement-davinci-pct-coordination-requester.md) and [Patient Cost Transparency Implementation Guide Payer Capability Statement](CapabilityStatement-davinci-pct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-organization)

**Changes since version 1.1.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-organization.csv), [Excel](StructureDefinition-davinci-pct-organization.xlsx), [Schematron](StructureDefinition-davinci-pct-organization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-organization",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile",
      "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|3.1.1"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.19"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTOrganization",
  "title" : "PCT Organization",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "The PCT Organization profile builds upon the US Core Organization profile. It is used to convey a payer, provider, payee, or service facility organization.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org/fhir/us/davinci-hrex/StructureDefinition/hrex-organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization.identifier:NPI",
        "path" : "Organization.identifier",
        "sliceName" : "NPI",
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:CLIA",
        "path" : "Organization.identifier",
        "sliceName" : "CLIA",
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:tin",
        "path" : "Organization.identifier",
        "sliceName" : "tin",
        "short" : "Tax ID Number",
        "patternIdentifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                "code" : "TAX"
              }
            ]
          },
          "system" : "urn:oid:2.16.840.1.113883.4.4"
        }
      },
      {
        "id" : "Organization.identifier:ETIN",
        "path" : "Organization.identifier",
        "sliceName" : "ETIN",
        "short" : "Electronic Transmitter Identification Number.",
        "min" : 0,
        "max" : "1",
        "patternIdentifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                "code" : "ETIN"
              }
            ]
          }
        },
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:payerid",
        "path" : "Organization.identifier",
        "sliceName" : "payerid",
        "min" : 0,
        "max" : "1",
        "patternIdentifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                "code" : "PAYERID"
              }
            ]
          }
        },
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:payerid.value",
        "path" : "Organization.identifier.value",
        "min" : 1
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "min" : 1,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTOrganizationTypeVS"
        }
      },
      {
        "id" : "Organization.address.country",
        "path" : "Organization.address.country",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/iso3166-1-2"
        }
      },
      {
        "id" : "Organization.contact",
        "path" : "Organization.contact",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "purpose"
            }
          ],
          "description" : "Slice based on $this value",
          "ordered" : false,
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Organization.contact.purpose",
        "path" : "Organization.contact.purpose",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTOrgContactPurposeTypeVS"
        }
      },
      {
        "id" : "Organization.contact:gfeServiceHotline",
        "path" : "Organization.contact",
        "sliceName" : "gfeServiceHotline",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Organization.contact:gfeServiceHotline.purpose",
        "path" : "Organization.contact.purpose",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTOrgContactPurposeType",
              "code" : "GFERELATED"
            }
          ]
        }
      },
      {
        "id" : "Organization.contact:gfeServiceHotline.name",
        "path" : "Organization.contact.name",
        "min" : 1
      },
      {
        "id" : "Organization.contact:gfeServiceHotline.telecom",
        "path" : "Organization.contact.telecom",
        "min" : 1
      }
    ]
  }
}

```
