# PCT GFE MedicationRequest - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT GFE MedicationRequest**

## Resource Profile: PCT GFE MedicationRequest 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-medicationrequest | *Version*:2.0.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:PCTMedicationRequest |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.49 | | |

 
The PCT MedicationRequest including details about a medication for which a GFE is being requested. 

The following profile relates to the Good Faith Estimate (GFE) Coordination workflow and is marked as **DRAFT**. This content has not yet met the requisite level of testing to be balloted as trial-use. However, this part of the specification has been reviewed by the Da Vinci Patient Cost Transparency (PCT) open community of providers, payers, and health information technology (IT) vendors and was determined to be at a sufficient level of development to be included in this publication for the purposes of soliciting feedback from, and enabling testing by, the larger implementation community with the intention of bringing the content related to the GFE Coordination workflow to full standard for trial use (STU) status in a future version. Feedback is welcome and may be submitted through the [FHIR change tracker](http://hl7.org/fhir-issues) indicating "US Da Vinci Patient Cost Transparency (PCT)(FHIR)" as the specification.

**Usages:**

* Use this Profile: [PCT GFE Information Bundle](StructureDefinition-davinci-pct-gfe-information-bundle.md) and [PCT GFE Missing Bundle](StructureDefinition-davinci-pct-gfe-missing-bundle.md)
* Examples for this Profile: [MedicationRequest/PCT-MedicationRequest-1](MedicationRequest-PCT-MedicationRequest-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-medicationrequest)

**Changes since version 1.1.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-medicationrequest.csv), [Excel](StructureDefinition-davinci-pct-medicationrequest.xlsx), [Schematron](StructureDefinition-davinci-pct-medicationrequest.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-medicationrequest",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-medicationrequest",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.49"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTMedicationRequest",
  "title" : "PCT GFE MedicationRequest",
  "status" : "draft",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "The PCT MedicationRequest including details about a medication for which a GFE is being requested.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest|7.0.0",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest.status",
        "path" : "MedicationRequest.status",
        "patternCode" : "active"
      },
      {
        "id" : "MedicationRequest.intent",
        "path" : "MedicationRequest.intent",
        "patternCode" : "proposal"
      },
      {
        "id" : "MedicationRequest.doNotPerform",
        "path" : "MedicationRequest.doNotPerform",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.subject",
        "path" : "MedicationRequest.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ]
      }
    ]
  }
}

```
