# PCT GFE Packet - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT GFE Packet**

## Resource Profile: PCT GFE Packet 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-packet | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:PCTGFEPacket |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.61 | | |

 
PCT GFE Packet that contains GFE Bundles from GFE contributors. This document type bundle of GFE Bundles from GFE contributors that can then be made available to the patient or sent to a payer for insurance estimation. The scope of this guide does not include coordination of benefits or more than one coverage. This does not serve as a replacement for eligibility, prior authorization or other financial and administrative use cases. 

**Usages:**

* Examples for this Profile: [Bundle/PCT-GFE-Packet-Inst-1](Bundle-PCT-GFE-Packet-Inst-1.md) and [Bundle/PCT-GFE-Packet-Prof-1](Bundle-PCT-GFE-Packet-Prof-1.md)
* CapabilityStatements using this Profile: [Patient Cost Transparency Implementation Guide Coordination Platform Capability Statement](CapabilityStatement-davinci-pct-coordination-platform.md), [Patient Cost Transparency Implementation Guide Coordination Requester Capability Statement](CapabilityStatement-davinci-pct-coordination-requester.md), [Patient Cost Transparency Implementation Guide Provider Capability Statement](CapabilityStatement-davinci-pct-gfe-provider.md) and [Patient Cost Transparency Implementation Guide Payer Capability Statement](CapabilityStatement-davinci-pct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-gfe-packet)

**Changes since version 1.1.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-gfe-packet.csv), [Excel](StructureDefinition-davinci-pct-gfe-packet.xlsx), [Schematron](StructureDefinition-davinci-pct-gfe-packet.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-gfe-packet",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-packet",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.61"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTGFEPacket",
  "title" : "PCT GFE Packet",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "PCT GFE Packet that contains GFE Bundles from GFE contributors. This document type bundle of GFE Bundles from GFE contributors that can then be made available to the patient or sent to a payer for insurance estimation. The scope of this guide does not include coordination of benefits or more than one coverage. This does not serve as a replacement for eligibility, prior authorization or other financial and administrative use cases.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "constraint" : [
          {
            "key" : "pct-gfe-packet-1",
            "severity" : "error",
            "human" : "SHALL have a initiating provider or initiating organization, but not both.",
            "expression" : "Bundle.entry.resource.ofType(Practitioner).exists() or Bundle.entry.resource.ofType(Organization).exists()",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-packet"
          },
          {
            "key" : "pct-gfe-packet-2",
            "severity" : "error",
            "human" : "All references resources SHALL be contained within the Bundle",
            "expression" : "Bundle.entry.resource.descendants().reference.where($this.startsWith('#').not()).all((%resource.entry.fullUrl.join('|')&'|').contains(($this&'|')))",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-packet"
          }
        ]
      },
      {
        "id" : "Bundle.identifier",
        "path" : "Bundle.identifier",
        "min" : 1
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "fixedCode" : "document"
      },
      {
        "id" : "Bundle.timestamp",
        "path" : "Bundle.timestamp",
        "min" : 1
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resource"
            }
          ],
          "description" : "Slice different resources included in the bundle",
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "Bundle.entry.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.search",
        "path" : "Bundle.entry.search",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.request",
        "path" : "Bundle.entry.request",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.response",
        "path" : "Bundle.entry.response",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:composition",
        "path" : "Bundle.entry",
        "sliceName" : "composition",
        "short" : "SHALL have a PCTGFEComposition resource",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:composition.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Composition",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-composition"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:patient",
        "path" : "Bundle.entry",
        "sliceName" : "patient",
        "short" : "SHALL have the patient subject of care and may have a separate subscriber",
        "min" : 1,
        "max" : "2"
      },
      {
        "id" : "Bundle.entry:patient.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Patient",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:coverage",
        "path" : "Bundle.entry",
        "sliceName" : "coverage",
        "short" : "MAY have one Coverage. SHALL be present submitted to a payer in the $gfe-submit operation.",
        "definition" : "SHALL be present submitted to a payer in the $gfe-submit operation.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:coverage.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Coverage",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:organization",
        "path" : "Bundle.entry",
        "sliceName" : "organization",
        "short" : "SHALL have an initiating provider or initiating organization, but not both. May also have a payer organization. Payer Organization SHALL be present when being submitted to a payer in the $gfe-submit operation.",
        "definition" : "GFE Packet initiating provider organization and/or an associated Payer. A Payer Organization SHALL be present when being submitted to a payer in the $gfe-submit operation. An initiating provider SHALL be present as an initiating provider organization (an entry in this slice) or an initiating provider practitioner (practitioner slice), but not both.",
        "min" : 0,
        "max" : "2",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:organization.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitioner",
        "path" : "Bundle.entry",
        "sliceName" : "practitioner",
        "short" : "SHALL have a initiating provider or initiating organization, but not both.",
        "definition" : "GFE Packet initiating provider practitioner. An initiating provider SHALL be present as an initiating provider practitioner (in this slice) or an initiating provider organization (an entry in the organization slice), but not both.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:practitioner.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Practitioner",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:gfeBundle",
        "path" : "Bundle.entry",
        "sliceName" : "gfeBundle",
        "short" : "MAY include GFE contributor specific GFE bundle or information about a unfulfilled GFE request (GFE Missing Bundle)",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:gfeBundle.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Bundle",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-bundle",
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-missing-bundle"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:attachment",
        "path" : "Bundle.entry",
        "sliceName" : "attachment",
        "short" : "MAY have attachments as DocumentReference resource(s)",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:attachment.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "DocumentReference"
          }
        ]
      }
    ]
  }
}

```
