# PCT GFE Information Bundle - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT GFE Information Bundle**

## Resource Profile: PCT GFE Information Bundle 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-information-bundle | *Version*:2.0.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:PCTGFEInformationBundle |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.16 | | |

 
PCT GFE Information Bundle that contains the information necessary for GFE contributors to create their estimates. This bundle may for all GFE Contributors or specific to a single contributor and may include, but is not limited to, the Patient Resource, request resources (such as ServiceRequest, MedicationRequest, and DeviceRequest), Service location information, Coverage and Payer Organization resources (if applicable). 

The following profile relates to the Good Faith Estimate (GFE) Coordination workflow and is marked as **DRAFT**. This content has not yet met the requisite level of testing to be balloted as trial-use. However, this part of the specification has been reviewed by the Da Vinci Patient Cost Transparency (PCT) open community of providers, payers, and health information technology (IT) vendors and was determined to be at a sufficient level of development to be included in this publication for the purposes of soliciting feedback from, and enabling testing by, the larger implementation community with the intention of bringing the content related to the GFE Coordination workflow to full standard for trial use (STU) status in a future version. Feedback is welcome and may be submitted through the [FHIR change tracker](http://hl7.org/fhir-issues) indicating "US Da Vinci Patient Cost Transparency (PCT)(FHIR)" as the specification.

**Usages:**

* Use this Profile: [PCT GFE Coordination Bundle](StructureDefinition-davinci-pct-gfe-coordination-bundle.md)
* Examples for this Profile: [Bundle/PCT-GFE-Information-Bundle-1](Bundle-PCT-GFE-Information-Bundle-1.md)
* CapabilityStatements using this Profile: [Patient Cost Transparency Implementation Guide Coordination Platform Capability Statement](CapabilityStatement-davinci-pct-coordination-platform.md), [Patient Cost Transparency Implementation Guide Coordination Requester Capability Statement](CapabilityStatement-davinci-pct-coordination-requester.md) and [Patient Cost Transparency Implementation Guide GFE Contributor Capability Statement](CapabilityStatement-davinci-pct-gfe-contributor.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-gfe-information-bundle)

**Changes since version 1.1.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-gfe-information-bundle.csv), [Excel](StructureDefinition-davinci-pct-gfe-information-bundle.xlsx), [Schematron](StructureDefinition-davinci-pct-gfe-information-bundle.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-gfe-information-bundle",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-information-bundle",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.16"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTGFEInformationBundle",
  "title" : "PCT GFE Information Bundle",
  "status" : "draft",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "PCT GFE Information Bundle that contains the information necessary for GFE contributors to create their estimates. This bundle may for all GFE Contributors or  specific to a single contributor and may include, but is not limited to, the Patient Resource, request resources (such as ServiceRequest, MedicationRequest, and DeviceRequest), Service location information, Coverage and Payer Organization resources (if applicable).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "constraint" : [
          {
            "key" : "pct-gfe-information-bundle-1",
            "severity" : "error",
            "human" : "All references resources SHALL be contained within the Bundle",
            "expression" : "Bundle.entry.resource.descendants().reference.where($this.startsWith('#').not()).all((%resource.entry.fullUrl.join('|')&'|').contains(($this&'|')))",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-information-bundle"
          }
        ]
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "fixedCode" : "collection"
      },
      {
        "id" : "Bundle.timestamp",
        "path" : "Bundle.timestamp",
        "min" : 1
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resource"
            }
          ],
          "description" : "Slice different resources included in the bundle",
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Bundle.entry.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.search",
        "path" : "Bundle.entry.search",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.request",
        "path" : "Bundle.entry.request",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.response",
        "path" : "Bundle.entry.response",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:patient",
        "path" : "Bundle.entry",
        "sliceName" : "patient",
        "short" : "SHALL have the patient subject of care and may have a separate subscriber",
        "min" : 1,
        "max" : "2"
      },
      {
        "id" : "Bundle.entry:patient.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Patient",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:coverage",
        "path" : "Bundle.entry",
        "sliceName" : "coverage",
        "short" : "MAY have one Coverage",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:coverage.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Coverage",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:organization",
        "path" : "Bundle.entry",
        "sliceName" : "organization",
        "short" : "MAY have the payer organization and may have provider organization(s)",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:organization.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:service-location",
        "path" : "Bundle.entry",
        "sliceName" : "service-location",
        "short" : "MAY have Service Location(s)",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:service-location.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Location",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-service-location"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitioner",
        "path" : "Bundle.entry",
        "sliceName" : "practitioner",
        "short" : "MAY have the provider Practitioner(s)",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:practitioner.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Practitioner",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitioner-role",
        "path" : "Bundle.entry",
        "sliceName" : "practitioner-role",
        "short" : "MAY have the provider PractitionerRole(s)",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:practitioner-role.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "PractitionerRole",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole|7.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:requested-items-service",
        "path" : "Bundle.entry",
        "sliceName" : "requested-items-service",
        "short" : "Items the request is about - PCTServiceRequest",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:requested-items-service.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "ServiceRequest",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-servicerequest"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:requested-items-medication",
        "path" : "Bundle.entry",
        "sliceName" : "requested-items-medication",
        "short" : "Items the request is about - PCTMedicationRequest",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:requested-items-medication.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "MedicationRequest",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-medicationrequest"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:requested-items-device",
        "path" : "Bundle.entry",
        "sliceName" : "requested-items-device",
        "short" : "Items the request is about - PCTDeviceRequest",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:requested-items-device.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "DeviceRequest",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-devicerequest"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:requested-items-nutrition",
        "path" : "Bundle.entry",
        "sliceName" : "requested-items-nutrition",
        "short" : "Items the request is about - NutritionOrder",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:requested-items-nutrition.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "NutritionOrder"
          }
        ]
      },
      {
        "id" : "Bundle.entry:requested-items-vision",
        "path" : "Bundle.entry",
        "sliceName" : "requested-items-vision",
        "short" : "Items the request is about - VisionPrescription",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:requested-items-vision.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "VisionPrescription"
          }
        ]
      },
      {
        "id" : "Bundle.entry:attachment",
        "path" : "Bundle.entry",
        "sliceName" : "attachment",
        "short" : "MAY have attachments as DocumentReference resource(s)",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:attachment.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "DocumentReference"
          }
        ]
      }
    ]
  }
}

```
