# PCT GFE Packet Document Reference - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT GFE Packet Document Reference**

## Resource Profile: PCT GFE Packet Document Reference 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-documentreference | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:PCTGFEDocumentReference |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.59 | | |

 
PCT GFE Packet Document Reference that enables searching and subscriptions for GFE Packets. 

**Usages:**

* Examples for this Profile: [DocumentReference/PCT-GFE-DocumentReference-Inst-1](DocumentReference-PCT-GFE-DocumentReference-Inst-1.md) and [DocumentReference/PCT-GFE-DocumentReference-Prof-1](DocumentReference-PCT-GFE-DocumentReference-Prof-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-gfe-documentreference)

**Changes since version 1.1.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-gfe-documentreference.csv), [Excel](StructureDefinition-davinci-pct-gfe-documentreference.xlsx), [Schematron](StructureDefinition-davinci-pct-gfe-documentreference.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-gfe-documentreference",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-documentreference",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.59"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTGFEDocumentReference",
  "title" : "PCT GFE Packet Document Reference",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "PCT GFE Packet Document Reference that enables searching and subscriptions for GFE Packets.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "fhircomposition",
      "uri" : "http://hl7.org/fhir/composition",
      "name" : "FHIR Composition"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "xds",
      "uri" : "http://ihe.net/xds",
      "name" : "XDS metadata equivalent"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DocumentReference",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|7.0.0",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DocumentReference",
        "path" : "DocumentReference"
      },
      {
        "id" : "DocumentReference.extension",
        "path" : "DocumentReference.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "DocumentReference.extension:requestInitiationTime",
        "path" : "DocumentReference.extension",
        "sliceName" : "requestInitiationTime",
        "short" : "Estimate Request instant (instance service was scheduled or estimate requested)",
        "comment" : "Instant from which the request is being initiated. For patient initiated requests, this is the date and time the patient or their representative made the request. For a newly scheduled service, this represents the time of the scheduling activity (as opposed to the planned time of service). For all other requests, the time of the event that triggered the need for an estimate.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/requestInitiationTime"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.extension:gfeServiceLinkingInfo",
        "path" : "DocumentReference.extension",
        "sliceName" : "gfeServiceLinkingInfo",
        "short" : "GFE Service Linking Information including planned period of service and a GFE linking identifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeServiceLinkingInfo"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.extension:procedureOrService",
        "path" : "DocumentReference.extension",
        "sliceName" : "procedureOrService",
        "short" : "Primary Procedures and/or products involved in the estimates",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/estimateProcedureOrService"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.extension:condition",
        "path" : "DocumentReference.extension",
        "sliceName" : "condition",
        "short" : "Primary diagnoses involved in the estimates",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/estimateCondition"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.docStatus",
        "path" : "DocumentReference.docStatus",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.type.coding",
        "path" : "DocumentReference.type.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "description" : "Slice defining composition as an estimate - type coding",
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "DocumentReference.type.coding:estimate",
        "path" : "DocumentReference.type.coding",
        "sliceName" : "estimate",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://loinc.org",
          "code" : "111480-0"
        },
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.category:estimate",
        "path" : "DocumentReference.category",
        "sliceName" : "estimate",
        "short" : "Estimate category",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentTypeTemporaryTrialUse",
              "code" : "estimate"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.date",
        "path" : "DocumentReference.date",
        "constraint" : [
          {
            "key" : "pct-datetime-to-seconds",
            "severity" : "error",
            "human" : "Datetime must be at least to seconds.",
            "expression" : "$this is dateTime implies $this.toString().length() >= 19",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-documentreference"
          }
        ]
      },
      {
        "id" : "DocumentReference.author",
        "path" : "DocumentReference.author",
        "short" : "All involved authoring parties, including all Good Faith Estimate (GFE) providers",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization",
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.relatesTo",
        "path" : "DocumentReference.relatesTo",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "description" : "Slice different relationships",
          "rules" : "open"
        },
        "short" : "Relationship to other GFE packet. Required if this estimate is replacing another."
      },
      {
        "id" : "DocumentReference.relatesTo:replaces",
        "path" : "DocumentReference.relatesTo",
        "sliceName" : "replaces",
        "short" : "Relationship to other GFE packets. Required if this estimate is replacing another.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.relatesTo:replaces.code",
        "path" : "DocumentReference.relatesTo.code",
        "patternCode" : "replaces"
      },
      {
        "id" : "DocumentReference.content",
        "path" : "DocumentReference.content",
        "max" : "1"
      },
      {
        "id" : "DocumentReference.content.format",
        "path" : "DocumentReference.content.format",
        "patternCoding" : {
          "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentTypeTemporaryTrialUse",
          "code" : "pct-gfe-packet"
        }
      }
    ]
  }
}

```
