# PCT GFE Bundle - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT GFE Bundle**

## Resource Profile: PCT GFE Bundle 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-bundle | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PCTGFEBundle |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.9 | | |

 
PCT GFE Bundle that contains all resources for a Good faith estimate submitted by a single GFE contributing provider. Organizations for both the provider and payer MAY be included. This single contributing provider GFE Bundle may be included in a set of GFE bundles from other providers in a GFE Packet that can then be made available to the patient or sent to a payer for insurance estimation. The scope of this guide does not include coordination of benefits for more than one coverage. This does not serve as a replacement for eligibility, prior authorization or other financial and administrative use cases. 

**Usages:**

* Use this Profile: [PCT AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md) and [PCT GFE Packet](StructureDefinition-davinci-pct-gfe-packet.md)
* Refer to this Profile: [PCT AEOB Composition](StructureDefinition-davinci-pct-aeob-composition.md), [PCT GFE Composition](StructureDefinition-davinci-pct-gfe-composition.md) and [GFE Reference](StructureDefinition-gfeReference.md)
* Examples for this Profile: [Bundle/PCT-GFE-Bundle-Inst-1](Bundle-PCT-GFE-Bundle-Inst-1.md) and [Bundle/PCT-GFE-Bundle-Prof-1](Bundle-PCT-GFE-Bundle-Prof-1.md)
* CapabilityStatements using this Profile: [Patient Cost Transparency Implementation Guide Coordination Platform Capability Statement](CapabilityStatement-davinci-pct-coordination-platform.md), [Patient Cost Transparency Implementation Guide Coordination Requester Capability Statement](CapabilityStatement-davinci-pct-coordination-requester.md), [Patient Cost Transparency Implementation Guide GFE Contributor Capability Statement](CapabilityStatement-davinci-pct-gfe-contributor.md), [Patient Cost Transparency Implementation Guide Provider Capability Statement](CapabilityStatement-davinci-pct-gfe-provider.md) and [Patient Cost Transparency Implementation Guide Payer Capability Statement](CapabilityStatement-davinci-pct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-gfe-bundle)

**Changes since version 1.1.0:**

* The resource metadata has changed (description)

* The data elements list has changed

* One or more text definitions, invariants or bindings have changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-gfe-bundle.csv), [Excel](StructureDefinition-davinci-pct-gfe-bundle.xlsx), [Schematron](StructureDefinition-davinci-pct-gfe-bundle.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-gfe-bundle",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-bundle",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.9"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTGFEBundle",
  "title" : "PCT GFE Bundle",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "PCT GFE Bundle that contains all resources for a Good faith estimate submitted by a single GFE contributing provider. Organizations for both the provider and payer MAY be included. This single contributing provider GFE Bundle may be included in a set of GFE bundles from other providers in a GFE Packet that can then be made available to the patient or sent to a payer for insurance estimation. The scope of this guide does not include coordination of benefits for more than one coverage. This does not serve as a replacement for eligibility, prior authorization or other financial and administrative use cases.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "constraint" : [
          {
            "key" : "pct-gfe-bundle-1",
            "severity" : "error",
            "human" : "SHALL have a submitting provider or submitting organization, but not both.",
            "expression" : "Bundle.entry.resource.ofType(Practitioner).exists() or Bundle.entry.resource.ofType(Organization).exists()",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-bundle"
          },
          {
            "key" : "pct-gfe-bundle-2",
            "severity" : "error",
            "human" : "All references resources SHALL be contained within the Bundle",
            "expression" : "Bundle.entry.resource.descendants().reference.where($this.startsWith('#').not()).all((%resource.entry.fullUrl.join('|')&'|').contains(($this&'|')))",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-bundle"
          },
          {
            "key" : "pct-gfe-bundle-3",
            "severity" : "error",
            "human" : "The first entry SHALL be an estimate-summary GFE",
            "expression" : "Bundle.entry[0].resource.ofType(Claim).type.coding.where(code='estimate-summary' and system='http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTEstimateTypeSummaryCSTemporaryTrialUse').exists()",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-bundle"
          }
        ]
      },
      {
        "id" : "Bundle.identifier",
        "path" : "Bundle.identifier",
        "min" : 1
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "fixedCode" : "collection"
      },
      {
        "id" : "Bundle.timestamp",
        "path" : "Bundle.timestamp",
        "min" : 1
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resource"
            }
          ],
          "description" : "Slice different resources included in the bundle",
          "rules" : "open"
        },
        "min" : 3
      },
      {
        "id" : "Bundle.entry.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.search",
        "path" : "Bundle.entry.search",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.request",
        "path" : "Bundle.entry.request",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.response",
        "path" : "Bundle.entry.response",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:gfe",
        "path" : "Bundle.entry",
        "sliceName" : "gfe",
        "short" : "SHALL have one or more PCTGFEProfessional or PCTGFEInstitutional resource(s)",
        "min" : 2,
        "max" : "*",
        "condition" : ["pct-gfe-bundle-3"]
      },
      {
        "id" : "Bundle.entry:gfe.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Claim",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-summary",
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-professional",
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-institutional"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:patient",
        "path" : "Bundle.entry",
        "sliceName" : "patient",
        "short" : "SHALL have the patient subject of care and may have a separate subscriber",
        "min" : 1,
        "max" : "2"
      },
      {
        "id" : "Bundle.entry:patient.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Patient",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:coverage",
        "path" : "Bundle.entry",
        "sliceName" : "coverage",
        "short" : "MAY have one Coverage",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:coverage.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Coverage",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:organization",
        "path" : "Bundle.entry",
        "sliceName" : "organization",
        "short" : "SHALL have a submitting provider or submitting organization, but not both. May also have a payer organization.",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:organization.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitioner",
        "path" : "Bundle.entry",
        "sliceName" : "practitioner",
        "short" : "SHALL have a submitting provider or submitting organization, but not both.",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:practitioner.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Practitioner",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:attachment",
        "path" : "Bundle.entry",
        "sliceName" : "attachment",
        "short" : "MAY have attachments as DocumentReference resource(s)",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:attachment.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "DocumentReference"
          }
        ]
      }
    ]
  }
}

```
