# PCT Coverage - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT Coverage**

## Resource Profile: PCT Coverage 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PCTCoverage |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.8 | | |

 
PCT Coverage is a profile for capturing data that reflect a payer's coverage that was effective as of the proposed date of service or the date of admission of the GFE. 

**Usages:**

* Use this Profile: [PCT AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md), [PCT GFE Bundle](StructureDefinition-davinci-pct-gfe-bundle.md), [PCT GFE Information Bundle](StructureDefinition-davinci-pct-gfe-information-bundle.md), [PCT GFE Missing Bundle](StructureDefinition-davinci-pct-gfe-missing-bundle.md) and [PCT GFE Packet](StructureDefinition-davinci-pct-gfe-packet.md)
* Refer to this Profile: [PCT Advanced EOB Summary](StructureDefinition-davinci-pct-aeob-summary.md), [PCT Advanced EOB](StructureDefinition-davinci-pct-aeob.md), [PCT GFE Composition](StructureDefinition-davinci-pct-gfe-composition.md), [PCT Good Faith Estimate Institutional](StructureDefinition-davinci-pct-gfe-institutional.md)...Show 2 more,[PCT Good Faith Estimate Professional](StructureDefinition-davinci-pct-gfe-professional.md)and[PCT Good Faith Estimate Summary](StructureDefinition-davinci-pct-gfe-summary.md)
* Examples for this Profile: [Coverage/coverage1001](Coverage-coverage1001.md) and [Coverage/selfpaycoverage2001](Coverage-selfpaycoverage2001.md)
* CapabilityStatements using this Profile: [Patient Cost Transparency Implementation Guide Payer Capability Statement](CapabilityStatement-davinci-pct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-coverage)

**Changes since version 1.1.0:**

* The resource metadata has changed (description)

* The data elements list has changed

* One or more text definitions, invariants or bindings have changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-coverage.csv), [Excel](StructureDefinition-davinci-pct-coverage.xlsx), [Schematron](StructureDefinition-davinci-pct-coverage.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-coverage",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.8"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTCoverage",
  "title" : "PCT Coverage",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "PCT Coverage is a profile for capturing data that reflect a payer's coverage that was effective as of the proposed date of service or the date of admission of the GFE.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "cdanetv4",
      "uri" : "http://www.cda-adc.ca/en/services/cdanet/",
      "name" : "Canadian Dental Association eclaims standard"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "cpha3pharm",
      "uri" : "http://www.pharmacists.ca/",
      "name" : "Canadian Pharmacy Associaiton eclaims standard"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Coverage",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-coverage|7.0.0",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Coverage",
        "path" : "Coverage",
        "constraint" : [
          {
            "key" : "pct-coverage-1",
            "severity" : "error",
            "human" : "Coverage: class element SHALL be present if coverage-0kind is insurance",
            "expression" : "extension.where(url='http://hl7.org/fhir/5.0/StructureDefinition/extension-Coverage.kind'and value = 'insurance').exists() implies class.exists()",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
          },
          {
            "key" : "pct-coverage-2",
            "severity" : "error",
            "human" : "Coverage: period element SHALL be present if coverage-0kind is insurance",
            "expression" : "extension.where(url='http://hl7.org/fhir/5.0/StructureDefinition/extension-Coverage.kind'and value = 'insurance').exists() implies period.exists()",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
          }
        ]
      },
      {
        "id" : "Coverage.extension",
        "path" : "Coverage.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Coverage.extension:coverage-kind",
        "path" : "Coverage.extension",
        "sliceName" : "coverage-kind",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-Coverage.kind"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Coverage.extension:coverage-kind.value[x]",
        "path" : "Coverage.extension.value[x]",
        "min" : 1
      },
      {
        "id" : "Coverage.extension:self-pay-declared",
        "path" : "Coverage.extension",
        "sliceName" : "self-pay-declared",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/selfPayDeclared"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Coverage.type",
        "path" : "Coverage.type",
        "short" : "Coverage category such as medical or accident. A coverage.type of `81` (Self-pay) MAY be used to imply that the patient has no coverage or that an individual or organization other than an insurer is taking responsibility for payment for a portion of the health care costs."
      },
      {
        "id" : "Coverage.subscriber",
        "path" : "Coverage.subscriber",
        "short" : "Required if subscriber is a person that is not the beneficiary. When date of birth or gender are not known, omit Patient.birthDate and set Patient.gender to unknown."
      },
      {
        "id" : "Coverage.subscriber.display",
        "path" : "Coverage.subscriber.display",
        "short" : "Provide the name of the subscriber in Coverage.subscriber.display concatenating the subscriber's prefix, given name, family name and suffix (in this order), each separated by a single space. If discrete name parts are required, a Patient resource SHALL be pointed to in Coverage.subscriber.reference."
      },
      {
        "id" : "Coverage.subscriberId",
        "path" : "Coverage.subscriberId",
        "min" : 1
      },
      {
        "id" : "Coverage.subscriberId.extension",
        "path" : "Coverage.subscriberId.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Coverage.subscriberId.extension:dataAbsentReason",
        "path" : "Coverage.subscriberId.extension",
        "sliceName" : "dataAbsentReason",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/data-absent-reason|5.2.0"
            ]
          }
        ]
      },
      {
        "id" : "Coverage.subscriberId.extension:dataAbsentReason.value[x]",
        "path" : "Coverage.subscriberId.extension.value[x]",
        "short" : "Use Data Absent Reason (DAR) extension with a value of 'not-applicable' for self-pay or uninsured",
        "patternCode" : "not-applicable"
      },
      {
        "id" : "Coverage.beneficiary",
        "path" : "Coverage.beneficiary",
        "short" : "Patient or Plan Beneficiary"
      },
      {
        "id" : "Coverage.payor",
        "path" : "Coverage.payor",
        "short" : "Issuer of the policy. For Self-pay or uninsured this should be a reference to a patient or related person resource",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson|7.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Coverage.class",
        "path" : "Coverage.class"
      },
      {
        "id" : "Coverage.class.name",
        "path" : "Coverage.class.name",
        "min" : 1
      },
      {
        "id" : "Coverage.class:group",
        "path" : "Coverage.class",
        "sliceName" : "group"
      },
      {
        "id" : "Coverage.class:group.name",
        "path" : "Coverage.class.name",
        "min" : 1
      },
      {
        "id" : "Coverage.class:plan",
        "path" : "Coverage.class",
        "sliceName" : "plan"
      },
      {
        "id" : "Coverage.class:plan.name",
        "path" : "Coverage.class.name",
        "min" : 1
      },
      {
        "id" : "Coverage.costToBeneficiary.type",
        "path" : "Coverage.costToBeneficiary.type",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/coverage-copay-type|1.0.1"
        }
      }
    ]
  }
}

```
