# PCT Advanced EOB Summary - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT Advanced EOB Summary**

## Resource Profile: PCT Advanced EOB Summary 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-summary | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:PCTAdvancedEOBSummary |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.5 | | |

 
This profile is used for exchanging a summary of Advanced Explanation of Benefit (AEOB) information, including costs and benefits, of all of the Advanced EOB data contained within an AEOB Packet. 

#### Notes on Fields

* .created: .created values convey the date and time the estimate was calculated, based on what was known about the state of the member’s benefits and accumulators for a given benefit period/plan year at that point in time (the .created date and time). 
* The gfeReference Extension is used to point to the GFE Bundle for which the originating GFE is contained. This along with the .claim.identifier can be used to identify the originating GFE this AEOB addresses. Note that it is common for there to be a one-to-one relationship between an AEOB and a GFE, however, this is not always the case.
* .benefitPeriod: .benefitPeriod values convey the term of benefits (a.k.a. "plan year") that the benefits used to calculate the estimate were based on. 
* .total.amount: Eligible amount = submitted amount - the noncovered amount - discount. The subscriber pays the member liability = deductible + coinsurance + copay + noncovered (if applicable). The eligible amount - the member liability is the potential payer's payment amount to the provider or the subscriber.
* .total.amount and .benefitbalance work together to reflect the expected member’s costs across all the Advanced EOB resources in this AEOB Packet(s). This means that all accumulations to deductible, out-of-pocket maximum, and other limits are collectively reflective of all GFEs in the GFE Packet(s), giving the Patient a comprehensive estimate for all expected service(s) or item(s) from one or more providers.
* .benefitbalance: benefit.balance shows the estimated balance by benefit category as if the expected item(s) or service(s) included in this estimate were applied. The .allowed value would reflect current allowed total limits for the specific category, unit, and term (e.g. Physical Therapy, Individual, annual.) The .used and .remaining would reflect current known balance plus or minus, respectively, the current estimate's expected item(s) or service(s) impact on the patient's benefit balance.
* total:submitted, total:memberliability, and total:eligible work together to communicate the high level summary to a patient. total:submitted is used to indicate the expected total amount submitted from the provider (charges). total:memberliability is used to indicate the expected amount the patient owes, and as stated above, the total:eligible - total:memberliability is the expected payer's payment amount.
* Working together .created values and .benefitPeriod values explicitly convey the temporal context for the state of benefits and accumulators that were used to calculate the estimate communicated in an advanced EOB. The state of a member’s benefits and accumulators for a given benefit period or the benefit period in effect may change between the date that an estimate is generated (.created) and when the services being estimated are actually rendered (e.g., the actual date of service), resulting in a difference between the estimated vs. actual cost to the member. 
* The .processnote data element is used to communicate disclaimers and specific information for this estimate to the patient. Processnote should include notes to meet legislative, legal, or otherwise required disclaimers. Notes should be clear and as specific to the situation at hand as possible including any additional assumptions and requirements. Examples of the types of information payers can use the processnote for include: 
* Disclaimer that the information provided in the notification is only an estimate based on the items and services reasonably expected, at the time of scheduling (or requesting) and is subject to change.
* Disclaimer that that coverage for such item or service is subject to a medical management technique, like prior authorization.
* Additional information about Prior Authorization, any assumptions made such as that the estimate is calculated assuming any applicable prior auth is approved and that the estimate may be higher if approval conditions are not met. If available, Payers could include Coverage Requirements Discovery (CRD) response information for improved patient transparency and information sharing.
* Unique assumptions about diagnosis code(s) impact on estimate accuracy, e.g. Diagnosis code was not specified. This estimate is based on assumption that this service is diagnostic and thus the patient responsibility may be higher than if the diagnosis was for preventative services.
* Additional information indicating that the AEOB contains one or more out of network providers and thus patient responsibility may be higher than if an in-network provider was chosen.
 

**Usages:**

* Use this Profile: [PCT AEOB Packet](StructureDefinition-davinci-pct-aeob-packet.md)
* Refer to this Profile: [PCT AEOB Composition](StructureDefinition-davinci-pct-aeob-composition.md)
* Examples for this Profile: [ExplanationOfBenefit/PCT-AEOB-Summary-1](ExplanationOfBenefit-PCT-AEOB-Summary-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-aeob-summary)

**Changes since version 1.1.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-aeob-summary.csv), [Excel](StructureDefinition-davinci-pct-aeob-summary.xlsx), [Schematron](StructureDefinition-davinci-pct-aeob-summary.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-aeob-summary",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-summary",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.5"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTAdvancedEOBSummary",
  "title" : "PCT Advanced EOB Summary",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "This profile is used for exchanging a summary of Advanced Explanation of Benefit (AEOB) information, including costs and benefits, of all of the Advanced EOB data contained within an AEOB Packet.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ExplanationOfBenefit",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ExplanationOfBenefit",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ExplanationOfBenefit.extension",
        "path" : "ExplanationOfBenefit.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "ExplanationOfBenefit.extension:serviceDescription",
        "path" : "ExplanationOfBenefit.extension",
        "sliceName" : "serviceDescription",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.extension:outOfNetworkProviderInfo",
        "path" : "ExplanationOfBenefit.extension",
        "sliceName" : "outOfNetworkProviderInfo",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/inNetworkProviderOptionsLink"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.type",
        "path" : "ExplanationOfBenefit.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTEstimateTypeSummaryCSTemporaryTrialUse",
              "code" : "estimate-summary"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.subType",
        "path" : "ExplanationOfBenefit.subType",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.use",
        "path" : "ExplanationOfBenefit.use",
        "patternCode" : "predetermination"
      },
      {
        "id" : "ExplanationOfBenefit.patient",
        "path" : "ExplanationOfBenefit.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.billablePeriod",
        "path" : "ExplanationOfBenefit.billablePeriod",
        "short" : "The full Period of Care for all services or products included in the estimate from the first event to the last event.",
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.created",
        "path" : "ExplanationOfBenefit.created",
        "short" : "The date and time this summary was generated.",
        "comment" : "The date and time this summary was generated based on what was known at that point in time."
      },
      {
        "id" : "ExplanationOfBenefit.enterer",
        "path" : "ExplanationOfBenefit.enterer",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.insurer",
        "path" : "ExplanationOfBenefit.insurer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
            ]
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.provider.extension",
        "path" : "ExplanationOfBenefit.provider.extension",
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.provider.extension:dataAbsentReason",
        "path" : "ExplanationOfBenefit.provider.extension",
        "sliceName" : "dataAbsentReason",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/data-absent-reason|5.2.0"
            ]
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.provider.extension:dataAbsentReason.value[x]",
        "path" : "ExplanationOfBenefit.provider.extension.value[x]",
        "patternCode" : "not-applicable"
      },
      {
        "id" : "ExplanationOfBenefit.provider.reference",
        "path" : "ExplanationOfBenefit.provider.reference",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.provider.type",
        "path" : "ExplanationOfBenefit.provider.type",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.provider.identifier",
        "path" : "ExplanationOfBenefit.provider.identifier",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.provider.display",
        "path" : "ExplanationOfBenefit.provider.display",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.priority",
        "path" : "ExplanationOfBenefit.priority",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/process-priority"
        }
      },
      {
        "id" : "ExplanationOfBenefit.fundsReserveRequested",
        "path" : "ExplanationOfBenefit.fundsReserveRequested",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.fundsReserve",
        "path" : "ExplanationOfBenefit.fundsReserve",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.prescription",
        "path" : "ExplanationOfBenefit.prescription",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.originalPrescription",
        "path" : "ExplanationOfBenefit.originalPrescription",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.payee",
        "path" : "ExplanationOfBenefit.payee",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.referral",
        "path" : "ExplanationOfBenefit.referral",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.facility",
        "path" : "ExplanationOfBenefit.facility",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.claim",
        "path" : "ExplanationOfBenefit.claim",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.preAuthRef",
        "path" : "ExplanationOfBenefit.preAuthRef",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.preAuthRefPeriod",
        "path" : "ExplanationOfBenefit.preAuthRefPeriod",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.supportingInfo",
        "path" : "ExplanationOfBenefit.supportingInfo",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.precedence",
        "path" : "ExplanationOfBenefit.precedence",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.insurance.coverage",
        "path" : "ExplanationOfBenefit.insurance.coverage",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
            ]
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.item",
        "path" : "ExplanationOfBenefit.item",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.addItem",
        "path" : "ExplanationOfBenefit.addItem",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.adjudication",
        "path" : "ExplanationOfBenefit.adjudication",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.total",
        "path" : "ExplanationOfBenefit.total",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "category"
            }
          ],
          "description" : "Slice based on value value",
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 3
      },
      {
        "id" : "ExplanationOfBenefit.total.category",
        "path" : "ExplanationOfBenefit.total.category",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTTotal"
        }
      },
      {
        "id" : "ExplanationOfBenefit.total:submitted",
        "path" : "ExplanationOfBenefit.total",
        "sliceName" : "submitted",
        "short" : "Total provider submitted amount",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.total:submitted.category",
        "path" : "ExplanationOfBenefit.total.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
              "code" : "submitted"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.total:memberliability",
        "path" : "ExplanationOfBenefit.total",
        "sliceName" : "memberliability",
        "short" : "Total member liability",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.total:memberliability.category",
        "path" : "ExplanationOfBenefit.total.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
              "code" : "memberliability"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.total:eligible",
        "path" : "ExplanationOfBenefit.total",
        "sliceName" : "eligible",
        "short" : "Total eligible amount",
        "comment" : "Eligible is similar to allowed amount. Eligible amount and Benefit amount may be different or the same, but if they are different the payer can supply both for the full picture of the estimate.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.total:eligible.category",
        "path" : "ExplanationOfBenefit.total.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
              "code" : "eligible"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.total:innetwork",
        "path" : "ExplanationOfBenefit.total",
        "sliceName" : "innetwork",
        "short" : "Total in network amount - only include when total type is applicable",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.total:innetwork.category",
        "path" : "ExplanationOfBenefit.total.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTNetworkStatusCS",
              "code" : "innetwork"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.total:outofnetwork",
        "path" : "ExplanationOfBenefit.total",
        "sliceName" : "outofnetwork",
        "short" : "Total out of network amount - only include when total type is applicable",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.total:outofnetwork.category",
        "path" : "ExplanationOfBenefit.total.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTNetworkStatusCS",
              "code" : "outofnetwork"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.total:noncovered",
        "path" : "ExplanationOfBenefit.total",
        "sliceName" : "noncovered",
        "short" : "Total noncovered amount - only include when total type is applicable",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.total:noncovered.category",
        "path" : "ExplanationOfBenefit.total.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudication",
              "code" : "noncovered"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.total:negotiated",
        "path" : "ExplanationOfBenefit.total",
        "sliceName" : "negotiated",
        "short" : "Total negotiated amount - Total for special negotiated status for a service or product in relation to a patient's coverage that is established outside of a formal network contract",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.total:negotiated.category",
        "path" : "ExplanationOfBenefit.total.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTNetworkStatusCS",
              "code" : "negotiated"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.total:benefit",
        "path" : "ExplanationOfBenefit.total",
        "sliceName" : "benefit",
        "short" : "Total benefit amount - only include when total type is applicable",
        "comment" : "Benefit is similar to allowed amount. Eligible amount and Benefit amount may be different or the same, but if they are different the payer can supply both for the full picture of the estimate.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.total:benefit.category",
        "path" : "ExplanationOfBenefit.total.category",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
              "code" : "benefit"
            }
          ]
        }
      },
      {
        "id" : "ExplanationOfBenefit.payment",
        "path" : "ExplanationOfBenefit.payment",
        "max" : "0"
      },
      {
        "id" : "ExplanationOfBenefit.processNote",
        "path" : "ExplanationOfBenefit.processNote",
        "short" : "Disclaimers go here. Notes should be clear and as specific to the situation at hand as possible including any additional assumptions and requirements. This may include notes about prior authorization, out of network providers, benefit period,  and other legal or otherwise required disclaimers.",
        "comment" : "These disclaimers may include, but are not limited to things such as: notes on prior authorization or other medical management requirements, provider discounts, limitations, preconditions, assumptions, information known to be missing in the estimate, conditions that may affect the estimate, or anything that may affect the interpretation of the estimate.",
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.processNote.extension",
        "path" : "ExplanationOfBenefit.processNote.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "ExplanationOfBenefit.processNote.extension:processNoteClass",
        "path" : "ExplanationOfBenefit.processNote.extension",
        "sliceName" : "processNoteClass",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/processNoteClass"
            ]
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.benefitPeriod",
        "path" : "ExplanationOfBenefit.benefitPeriod",
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance",
        "path" : "ExplanationOfBenefit.benefitBalance",
        "short" : "Estimated Balance by Benefit Category as if the expected item(s) or service(s) included in this estimate were applied.",
        "definition" : "Estimated Balance by Benefit Category as if the expected item(s) or service(s) included in this estimate were applied. Note: The available balance is based on known claims and does not account for other Good Faith Estimates (GFEs). Benefit balances will remain unchanged until the claim adjudication process applies benefits. Consequently, if multiple estimates pertain to the same benefit, the benefit balance will not consider other estimates.",
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.category",
        "path" : "ExplanationOfBenefit.benefitBalance.category",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTBenefitBalanceCategoryVS"
        }
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.category.text",
        "path" : "ExplanationOfBenefit.benefitBalance.category.text",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.unit",
        "path" : "ExplanationOfBenefit.benefitBalance.unit",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/benefit-unit"
        }
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.term",
        "path" : "ExplanationOfBenefit.benefitBalance.term",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/benefit-term"
        }
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.financial",
        "path" : "ExplanationOfBenefit.benefitBalance.financial",
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.financial.extension",
        "path" : "ExplanationOfBenefit.benefitBalance.financial.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.financial.extension:remaining",
        "path" : "ExplanationOfBenefit.benefitBalance.financial.extension",
        "sliceName" : "remaining",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/remaining-benefit"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.financial.type",
        "path" : "ExplanationOfBenefit.benefitBalance.financial.type",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/davinci-pct/ValueSet/PCTFinancialTypeVS"
        }
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.financial.allowed[x]",
        "path" : "ExplanationOfBenefit.benefitBalance.financial.allowed[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.financial.allowed[x]:allowedMoney",
        "path" : "ExplanationOfBenefit.benefitBalance.financial.allowed[x]",
        "sliceName" : "allowedMoney",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Money"
          }
        ]
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.financial.used[x]",
        "path" : "ExplanationOfBenefit.benefitBalance.financial.used[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ExplanationOfBenefit.benefitBalance.financial.used[x]:usedMoney",
        "path" : "ExplanationOfBenefit.benefitBalance.financial.used[x]",
        "sliceName" : "usedMoney",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Money"
          }
        ]
      }
    ]
  }
}

```
