# PCT AEOB Packet - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT AEOB Packet**

## Resource Profile: PCT AEOB Packet 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-packet | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:PCTAEOBPacket |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.60 | | |

 
PCT AEOB Packet that contains necessary resources for one or more an AEOBs. Organizations for both the payer and provider SHALL be included. An AEOB Summary SHALL be included and reflect the total estimate for the patient, including all AEOB resources within the Bundle. This version of the Bundle is a document type that will enable versioning, signing and being referenced by a DocumentReference for searching and subscription notifications. 

**Usages:**

* Examples for this Profile: [Bundle/PCT-AEOB-Packet-1](Bundle-PCT-AEOB-Packet-1.md)
* CapabilityStatements using this Profile: [Patient Cost Transparency Implementation Guide Payer Capability Statement](CapabilityStatement-davinci-pct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-aeob-packet)

**Changes since version 1.1.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-aeob-packet.csv), [Excel](StructureDefinition-davinci-pct-aeob-packet.xlsx), [Schematron](StructureDefinition-davinci-pct-aeob-packet.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-aeob-packet",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-packet",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.60"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTAEOBPacket",
  "title" : "PCT AEOB Packet",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "PCT AEOB Packet that contains necessary resources for one or more an AEOBs.  Organizations for both the payer and provider SHALL be included.   An AEOB Summary SHALL be included and reflect the total estimate for the patient, including all AEOB resources within the Bundle. This version of the Bundle is a document type that will enable versioning, signing and being referenced by a DocumentReference for searching and subscription notifications.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "constraint" : [
          {
            "key" : "pct-aeob-packet-1",
            "severity" : "error",
            "human" : "All references resources SHALL be contained within the Bundle with the exception of the PCT GFE Bundle (referenced from the gfeReference extension in the AEOB), which MAY be present",
            "expression" : "Bundle.entry.descendants().reference.distinct().all(resolve().exists())",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-packet"
          },
          {
            "key" : "pct-aeob-packet-2",
            "severity" : "error",
            "human" : "SHALL have at least one entry for a payer organization.",
            "expression" : "entry.resource.ofType(Organization).where(type.coding.where(code='pay').exists()).exists()",
            "source" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-packet"
          }
        ]
      },
      {
        "id" : "Bundle.identifier",
        "path" : "Bundle.identifier",
        "min" : 1
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "fixedCode" : "document"
      },
      {
        "id" : "Bundle.timestamp",
        "path" : "Bundle.timestamp",
        "min" : 1
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resource"
            }
          ],
          "description" : "Slice different resources included in the bundle",
          "rules" : "open"
        },
        "min" : 6
      },
      {
        "id" : "Bundle.entry.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.search",
        "path" : "Bundle.entry.search",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.request",
        "path" : "Bundle.entry.request",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.response",
        "path" : "Bundle.entry.response",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:composition",
        "path" : "Bundle.entry",
        "sliceName" : "composition",
        "short" : "SHALL have a PCTAdvancedEOBComposition resource",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:composition.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Composition",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-composition"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:aeob",
        "path" : "Bundle.entry",
        "sliceName" : "aeob",
        "short" : "SHALL have a PCTAdvancedEOBSummary or PCTAdvancedEOB resource",
        "min" : 2,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:aeob.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "ExplanationOfBenefit",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-summary",
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:patient",
        "path" : "Bundle.entry",
        "sliceName" : "patient",
        "short" : "SHALL have the patient subject of care and may be a separate subscriber",
        "min" : 1,
        "max" : "2",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:patient.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Patient",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:coverage",
        "path" : "Bundle.entry",
        "sliceName" : "coverage",
        "short" : "SHALL have one Coverage",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:coverage.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Coverage",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:organization",
        "path" : "Bundle.entry",
        "sliceName" : "organization",
        "short" : "SHALL have the payer organization and may have provider organization(s)",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:organization.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitioner",
        "path" : "Bundle.entry",
        "sliceName" : "practitioner",
        "short" : "MAY have the provider Practitioner(s)",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:practitioner.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Practitioner",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:gfeBundle",
        "path" : "Bundle.entry",
        "sliceName" : "gfeBundle",
        "short" : "MAY include GFE contributor specific GFE bundle or information about a unfulfilled GFE request (GFE Missing Bundle)",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:gfeBundle.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Bundle",
            "profile" : [
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-bundle",
              "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-missing-bundle"
            ]
          }
        ]
      }
    ]
  }
}

```
