# Subscription - AEOB Available for Author Notification - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Subscription - AEOB Available for Author Notification**

## Resource Profile: Subscription - AEOB Available for Author Notification 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-available-author-subscription | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PCTAEOBAvailableAuthorSubscription |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.42.63 | | |

 
An author focused Subscription when an Advanced Explanation of Benefit (AEOB) Packet DocumentReference is created or updated (for FHIR R4). This represents that an AEOB Bundle, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made. 

**Usages:**

* Examples for this Profile: [Subscription/example-aeob-available-author-subscription-full](Subscription-example-aeob-available-author-subscription-full.md) and [Subscription/example-aeob-available-author-subscription-id-only](Subscription-example-aeob-available-author-subscription-id-only.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.davinci-pct|current/StructureDefinition/davinci-pct-aeob-available-author-subscription)

**Changes since version 1.1.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-davinci-pct-aeob-available-author-subscription.csv), [Excel](StructureDefinition-davinci-pct-aeob-available-author-subscription.xlsx), [Schematron](StructureDefinition-davinci-pct-aeob-available-author-subscription.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "davinci-pct-aeob-available-author-subscription",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob-available-author-subscription",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.42.63"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTAEOBAvailableAuthorSubscription",
  "title" : "Subscription - AEOB Available for Author Notification",
  "status" : "active",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "An author focused Subscription when an Advanced Explanation of Benefit (AEOB) Packet DocumentReference is created or updated (for FHIR R4). This represents that an AEOB Bundle, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Subscription",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Subscription",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Subscription",
        "path" : "Subscription"
      },
      {
        "id" : "Subscription.status",
        "path" : "Subscription.status",
        "patternCode" : "active"
      },
      {
        "id" : "Subscription.criteria",
        "path" : "Subscription.criteria",
        "patternString" : "http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-aeob-available-author-notification"
      },
      {
        "id" : "Subscription.criteria.extension",
        "path" : "Subscription.criteria.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Subscription.criteria.extension:filterCriteria",
        "path" : "Subscription.criteria.extension",
        "sliceName" : "filterCriteria",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-filter-criteria"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Subscription.channel.extension",
        "path" : "Subscription.channel.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Subscription.channel.extension:heartbeatPeriod",
        "path" : "Subscription.channel.extension",
        "sliceName" : "heartbeatPeriod",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-heartbeat-period"
            ]
          }
        ]
      },
      {
        "id" : "Subscription.channel.extension:timeout",
        "path" : "Subscription.channel.extension",
        "sliceName" : "timeout",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-timeout"
            ]
          }
        ]
      },
      {
        "id" : "Subscription.channel.extension:maxCount",
        "path" : "Subscription.channel.extension",
        "sliceName" : "maxCount",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-max-count"
            ]
          }
        ]
      },
      {
        "id" : "Subscription.channel.payload.extension",
        "path" : "Subscription.channel.payload.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Subscription.channel.payload.extension:payloadContent",
        "path" : "Subscription.channel.payload.extension",
        "sliceName" : "payloadContent",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/uv/subscriptions-backport/StructureDefinition/backport-payload-content"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
