# RelatedTask - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RelatedTask**

## SearchParameter: RelatedTask 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/SearchParameter/related-task | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:RelatedTask |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.40.11 | | |

 
Completed or terminated task(s) whose function is taken by this new task 

## RelatedTask TU

Parameter `related-task`:`reference`

Completed or terminated task(s) whose function is taken by this new task

| | |
| :--- | :--- |
| Resource | [Task](http://hl7.org/fhir/R4/task.html) |
| Expression | `Task.extension.where(url='http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeRelatedTask').extension.where(url='related').value` |
| Processing Mode | Normal |
| Target Resources | [Task](http://hl7.org/fhir/R4/task.html) |
| Multiples | * multipleAnd: It's up to the server whether the parameter may repeat in order to specify multiple values that must all be true
* multipleOr: It's up to the server whether the parameter can have multiple values (separated by comma) where at least one must be true
 |



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "related-task",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/SearchParameter/related-task",
  "version" : "2.0.0",
  "name" : "RelatedTask",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-03-24T09:29:23+11:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Completed or terminated task(s) whose function is taken by this new task",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "code" : "related-task",
  "base" : ["Task"],
  "type" : "reference",
  "expression" : "Task.extension.where(url='http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeRelatedTask').extension.where(url='related').value",
  "xpathUsage" : "normal",
  "target" : ["Task"]
}

```
