# Packet Procedure or Service - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Packet Procedure or Service**

## SearchParameter: Packet Procedure or Service 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/SearchParameter/packet-procedure-or-service | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PacketProcedureOrService |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.40.7 | | |

 
Significant Procedures and/or products involved in an estimate in the packet. 

## PacketProcedureOrService TU

Parameter `estimate-service`:`token`

Significant Procedures and/or products involved in an estimate in the packet.

| | |
| :--- | :--- |
| Resource | [DocumentReference](http://hl7.org/fhir/R4/documentreference.html) |
| Expression | `DocumentReference.extension.where(url='http://hl7.org/fhir/us/davinci-pct/StructureDefinition/estimateProcedureOrService').value` |
| Processing Mode | Normal |
| Target Resources | [DocumentReference](http://hl7.org/fhir/R4/documentreference.html) |
| Multiples | * multipleAnd: It's up to the server whether the parameter may repeat in order to specify multiple values that must all be true
* multipleOr: It's up to the server whether the parameter can have multiple values (separated by comma) where at least one must be true
 |



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "packet-procedure-or-service",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/SearchParameter/packet-procedure-or-service",
  "version" : "2.0.0",
  "name" : "PacketProcedureOrService",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-04-04T09:29:23+11:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Significant Procedures and/or products involved in an estimate in the packet.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "code" : "estimate-service",
  "base" : ["DocumentReference"],
  "type" : "token",
  "expression" : "DocumentReference.extension.where(url='http://hl7.org/fhir/us/davinci-pct/StructureDefinition/estimateProcedureOrService').value",
  "xpathUsage" : "normal",
  "target" : ["DocumentReference"]
}

```
