# aeob-date-of-service - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **aeob-date-of-service**

## SearchParameter: aeob-date-of-service 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/SearchParameter/aeob-date-of-service | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:AEOBDateOfService |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.40.1 | | |

 
Select planned date of service 

## AEOBDateOfService TU

Parameter `aeob-date-of-service`:`date`

Select planned date of service

| | |
| :--- | :--- |
| Resource | [ExplanationOfBenefit](http://hl7.org/fhir/R4/explanationofbenefit.html) |
| Expression | `ExplanationOfBenefit.item.serviced` |
| Target Resources | [ExplanationOfBenefit](http://hl7.org/fhir/R4/explanationofbenefit.html) |
| Multiples | * multipleAnd: It's up to the server whether the parameter may repeat in order to specify multiple values that must all be true
* multipleOr: It's up to the server whether the parameter can have multiple values (separated by comma) where at least one must be true
 |



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "aeob-date-of-service",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/SearchParameter/aeob-date-of-service",
  "version" : "2.0.0",
  "name" : "AEOBDateOfService",
  "status" : "active",
  "date" : "2022-12-15",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Select planned date of service",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "code" : "aeob-date-of-service",
  "base" : ["ExplanationOfBenefit"],
  "type" : "date",
  "expression" : "ExplanationOfBenefit.item.serviced",
  "target" : ["ExplanationOfBenefit"]
}

```
