# DocumentReference docStatus - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DocumentReference docStatus**

## SearchParameter: DocumentReference docStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/SearchParameter/DocumentReference-doc-status | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:DocumentReferenceDocStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.40.10 | | |

 
The status of the underlying document. 

## DocumentReferenceDocStatus TU

Parameter `doc-status`:`token`

The status of the underlying document.

| | |
| :--- | :--- |
| Resource | [DocumentReference](http://hl7.org/fhir/R4/documentreference.html) |
| Expression | `DocumentReference.docStatus` |
| Processing Mode | Normal |
| Target Resources | [DocumentReference](http://hl7.org/fhir/R4/documentreference.html) |
| Multiples | * multipleAnd: It's up to the server whether the parameter may repeat in order to specify multiple values that must all be true
* multipleOr: It's up to the server whether the parameter can have multiple values (separated by comma) where at least one must be true
 |



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "DocumentReference-doc-status",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/SearchParameter/DocumentReference-doc-status",
  "version" : "2.0.0",
  "name" : "DocumentReferenceDocStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-08-11T21:47:23+11:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "The status of the underlying document.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "code" : "doc-status",
  "base" : ["DocumentReference"],
  "type" : "token",
  "expression" : "DocumentReference.docStatus",
  "xpathUsage" : "normal",
  "target" : ["DocumentReference"]
}

```
