# prac002 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **prac002**

## Example Practitioner: prac002

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT Practitioner](StructureDefinition-davinci-pct-practitioner.md)

**identifier**: [United States National Provider Identifier](http://terminology.hl7.org/6.5.0/NamingSystem-npi.html)/9941339100

**active**: true

**name**: Christine Curie

**telecom**: ph: 781-232-3232

**address**: 32 Fruit Street, Boston MA 02114

**gender**: Female



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "prac002",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
    ]
  },
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "9941339100"
    }
  ],
  "active" : true,
  "name" : [
    {
      "text" : "Christine Curie",
      "family" : "Curie",
      "given" : ["Christine"],
      "prefix" : ["Dr."]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "781-232-3232"
    }
  ],
  "address" : [
    {
      "text" : "32 Fruit Street, Boston MA 02114"
    }
  ],
  "gender" : "female"
}

```
