# prac001 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **prac001**

## Example Practitioner: prac001

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT Practitioner](StructureDefinition-davinci-pct-practitioner.md)

**identifier**: [United States National Provider Identifier](http://terminology.hl7.org/6.5.0/NamingSystem-npi.html)/9941339100

**active**: true

**name**: Patricia Primary

**telecom**: ph: 781-232-3231

**address**: 32 Fruit Street, Boston MA 02114

**gender**: Female



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "prac001",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
    ]
  },
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "9941339100"
    }
  ],
  "active" : true,
  "name" : [
    {
      "text" : "Patricia\tPrimary",
      "family" : "Primary",
      "given" : ["Patricia"],
      "prefix" : ["Dr."]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "781-232-3231"
    }
  ],
  "address" : [
    {
      "text" : "32 Fruit Street, Boston MA 02114"
    }
  ],
  "gender" : "female"
}

```
