# patient1001 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **patient1001**

## Example Patient: patient1001

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Eve Betterhalf** female, DoB: 1955-07-23 ( `http://example.com/identifiers/patient`/1001)

-------

| | |
| :--- | :--- |
| Marital Status: | unmarried |
| Contact Details: | * ph: 781-949-4949(MOBILE)
* 222 Burlington Road, Bedford MA 01730
 |
| Language: | English (United States)(preferred) |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "patient1001",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.com/identifiers/patient",
      "value" : "1001"
    }
  ],
  "name" : [
    {
      "text" : "Eve Betterhalf",
      "family" : "Betterhalf",
      "given" : ["Eve"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "781-949-4949",
      "use" : "mobile"
    }
  ],
  "gender" : "female",
  "birthDate" : "1955-07-23",
  "address" : [
    {
      "text" : "222 Burlington Road, Bedford MA 01730"
    }
  ],
  "maritalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
        "code" : "U",
        "display" : "unmarried"
      }
    ]
  },
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "en-US",
            "display" : "English (United States)"
          }
        ]
      },
      "preferred" : true
    }
  ]
}

```
