# org1001 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **org1001**

## Example Organization: org1001

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT Organization](StructureDefinition-davinci-pct-organization.md)

**identifier**: Electronic Transmitter Identification Number/ETIN-3200002

**active**: true

**type**: Payer

**name**: Umbrella Insurance Company

**telecom**: ph: 860-547-5001(Work)

**address**: 680 Asylum Street Hartford CT 06155 US 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "org1001",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "ETIN"
          }
        ]
      },
      "value" : "ETIN-3200002"
    }
  ],
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
          "code" : "pay",
          "display" : "Payer"
        }
      ]
    }
  ],
  "name" : "Umbrella Insurance Company",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "860-547-5001",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "line" : ["680 Asylum Street"],
      "city" : "Hartford",
      "state" : "CT",
      "postalCode" : "06155",
      "country" : "US"
    }
  ]
}

```
