# Submitter-Org-1 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Submitter-Org-1**

## Example Organization: Submitter-Org-1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT Organization](StructureDefinition-davinci-pct-organization.md)

**identifier**: Electronic Transmitter Identification Number/ETIN-10010301

**active**: true

**type**: Non-Healthcare Business or Corporation

**name**: GFE Service Help INC.

> **contact****purpose**:GFE-related**name**: Clara Sender**telecom**: ph: 781-632-3209(Work),[csender@GFEServiceHelp.com](mailto:csender@GFEServiceHelp.com)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "Submitter-Org-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "ETIN"
          }
        ]
      },
      "value" : "ETIN-10010301"
    }
  ],
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
          "code" : "bus"
        }
      ]
    }
  ],
  "name" : "GFE Service Help INC.",
  "contact" : [
    {
      "purpose" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTOrgContactPurposeType",
            "code" : "GFERELATED"
          }
        ]
      },
      "name" : {
        "text" : "Clara Sender"
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "781-632-3209",
          "use" : "work"
        },
        {
          "system" : "email",
          "value" : "csender@GFEServiceHelp.com",
          "use" : "work"
        }
      ]
    }
  ]
}

```
