# Good Faith Estimate Coordination Request - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Good Faith Estimate Coordination Request**

## OperationDefinition: Good Faith Estimate Coordination Request 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/OperationDefinition/GFE-coordination-request | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:GFECoordinationRequest |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.33.4 | | |

 
This operation is used by an entity to submit one or multiple GFEs as a Bundle containing the GFE(s) and other referenced resources for processing. The only input parameter is the single Bundle resource with one or multiple GFE(s) - each of which is based on the Claim resource (along with other referenced resources). The output is a url in the Content-Location header for subsequent polling and optionally an OperationOutcome resource per[async pattern](https://hl7.org/fhir/R5/async-bundle.html). If after polling the response is complete, then the result will either be a single Bundle with the AEOB - which is based on the ExplanationOfBenefit resource, (and other referenced resources) or an OperationOutcome resource indicating the AEOB will be sent directly to the patient. 

URL: [base]/$gfe-submit

### Parameters

* **Use**: IN
  * **Name**: resource
  * **Scope**: 
  * **Cardinality**: 1..1
  * **Type**: [Bundle](http://hl7.org/fhir/R4/bundle.html)([PCT GFE Coordination Bundle](StructureDefinition-davinci-pct-gfe-coordination-bundle.md))
  * **Binding**: 
  * **Documentation**: A request Bundle that contains necessary resources for GFE to request GFEs from one or multiple GFE contributing providers.
* **Use**: OUT
  * **Name**: return
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [Bundle](http://hl7.org/fhir/R4/bundle.html)
  * **Binding**: 
  * **Documentation**: A batch-response Bundle including OperationOutcome entries each noting the success or failure to process the entry in the input Bundle. OperationOutcomes denoting a failure SHALL list of issues that caused the failure. All entries must be successfully processed for any to be successful. If an input Bundle entry fails, they all fail. Entries that would otherwise be successful will have an operationOutcome indicating the precondition that all of Bundle entries have to be processed was not met.



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "GFE-coordination-request",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/OperationDefinition/GFE-coordination-request",
  "version" : "2.0.0",
  "name" : "GFECoordinationRequest",
  "title" : "Good Faith Estimate Coordination Request",
  "status" : "active",
  "kind" : "operation",
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "This operation is used by an entity to submit one or multiple GFEs as a Bundle containing the GFE(s) and other referenced resources for processing. The only input parameter is the single Bundle resource with one or multiple GFE(s) - each of which is based on the Claim resource (along with other referenced resources). The output is a url in the Content-Location header for subsequent polling and optionally an OperationOutcome resource per [async pattern](https://hl7.org/fhir/R5/async-bundle.html). If after polling the response is complete, then the result will either be a single Bundle with the AEOB - which is based on the ExplanationOfBenefit resource, (and other referenced resources) or an OperationOutcome resource indicating the AEOB will be sent directly to the patient.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "code" : "gfe-submit",
  "base" : "http://hl7.org/fhir/us/davinci-pct/OperationDefinition/GFE-coordination-request",
  "system" : true,
  "type" : false,
  "instance" : false,
  "parameter" : [
    {
      "name" : "resource",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "A request Bundle that contains necessary resources for GFE  to request GFEs from one or multiple GFE contributing providers.",
      "type" : "Bundle",
      "targetProfile" : [
        "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-coordination-bundle"
      ]
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "A batch-response Bundle including OperationOutcome entries each noting the success or failure to process the entry in the input Bundle. OperationOutcomes denoting a failure SHALL list of issues that caused the failure. All entries must be successfully processed for any to be successful. If an input Bundle entry fails, they all fail. Entries that would otherwise be successful will have an operationOutcome indicating the precondition that all of Bundle entries have to be processed was not met.",
      "type" : "Bundle"
    }
  ]
}

```
