# PCT-AEOB-1 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT-AEOB-1**

## Example ExplanationOfBenefit: PCT-AEOB-1

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT Advanced EOB](StructureDefinition-davinci-pct-aeob.md)

**GFE Reference**: [Bundle: identifier = http://example.com/identifiers/bundle#59688475-2324-3242-23473847; type = collection; timestamp = 2021-11-09 11:01:00+0500](Bundle-PCT-GFE-Bundle-Inst-1.md)

**Service Description**: Example service

**In Network Provider Options Link**: [http://example.org/out-of-network.html](http://example.org/out-of-network.html)

**identifier**: Unique Claim Identifier/?ngen-9?

**status**: Active

**type**: Institutional

**use**: Predetermination

**patient**: [Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)

**created**: 2021-10-12

**insurer**: [Organization Umbrella Insurance Company](Organization-org1001.md)

**provider**: [Organization Boston Radiology Center](Organization-org1002.md)

**priority**: Normal

**claim**: Identifier: `http://example.com/identifiers/bundle`/59688475-2324-3242-23473847

**outcome**: Processing Complete

### Insurances

| | | |
| :--- | :--- | :--- |
| - | **Focal** | **Coverage** |
| * | true | [Coverage: extension = insurance; status = active; subscriberId = PFP123450000; relationship = Self; period = 2021-01-01 --> 2022-01-01](Coverage-coverage1001.md) |

> **item****sequence**: 1**revenue**:Magnetic Resonance Technology (MRT) - Brain/brain stem**productOrService**:Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material**modifier**:Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material**serviced**: 2022-01-01

### Nets

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | United States dollar |

### Adjudications

| | | |
| :--- | :--- | :--- |
| - | **Extension** | **Category** |
| * |  | Medical Management |


### Adjudications

| | | |
| :--- | :--- | :--- |
| - | **Extension** | **Category** |
| * |  | Medical Management |
| * |  | Submitted Amount |
| * |  | Member Liability |

> **total****category**:Submitted Amount

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | United States dollar |


> **total****category**:Member liability

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 20 | United States dollar |


> **total****category**:Eligible Amount

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 190 | United States dollar |


### ProcessNotes

| | | |
| :--- | :--- | :--- |
| - | **Extension** | **Text** |
| * |  | processNote disclaimer text |

**benefitPeriod**: 2022-01-01 --> 2023-01-01

> **benefitBalance****category**:Medical Care**unit**:Individual**term**:Annual

### Financials

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Extension** | **Type** | **Allowed[x]** | **Used[x]** |
| * |  | Allowed | $1.00(USD) | $1.00(USD) |




## Resource Content

```json
{
  "resourceType" : "ExplanationOfBenefit",
  "id" : "PCT-AEOB-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-aeob"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeReference",
      "valueReference" : {
        "reference" : "Bundle/PCT-GFE-Bundle-Inst-1"
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription",
      "valueString" : "Example service"
    },
    {
      "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/inNetworkProviderOptionsLink",
      "valueUrl" : "http://example.org/out-of-network.html"
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "UCID"
          }
        ]
      }
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "code" : "institutional",
        "display" : "Institutional"
      }
    ]
  },
  "use" : "predetermination",
  "patient" : {
    "reference" : "Patient/patient1001"
  },
  "created" : "2021-10-12",
  "insurer" : {
    "reference" : "Organization/org1001"
  },
  "provider" : {
    "reference" : "Organization/org1002"
  },
  "priority" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/processpriority",
        "code" : "normal"
      }
    ]
  },
  "claim" : {
    "identifier" : {
      "system" : "http://example.com/identifiers/bundle",
      "value" : "59688475-2324-3242-23473847"
    }
  },
  "outcome" : "complete",
  "insurance" : [
    {
      "focal" : true,
      "coverage" : {
        "reference" : "Coverage/coverage1001"
      }
    }
  ],
  "item" : [
    {
      "sequence" : 1,
      "revenue" : {
        "coding" : [
          {
            "system" : "https://www.nubc.org/CodeSystem/RevenueCodes",
            "code" : "0611",
            "display" : "Magnetic Resonance Technology (MRT) - Brain/brain stem"
          }
        ]
      },
      "productOrService" : {
        "coding" : [
          {
            "system" : "http://www.ama-assn.org/go/cpt",
            "code" : "70551",
            "display" : "Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material"
          }
        ]
      },
      "modifier" : [
        {
          "coding" : [
            {
              "system" : "http://www.ama-assn.org/go/cpt",
              "code" : "70551",
              "display" : "Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material"
            }
          ]
        }
      ],
      "servicedDate" : "2022-01-01",
      "net" : {
        "value" : 200,
        "currency" : "USD"
      },
      "adjudication" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/subjectToMedicalMgmt",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/medical-management-type",
                    "code" : "concurrent-review",
                    "display" : "Concurrent Review"
                  }
                ]
              }
            }
          ],
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
                "code" : "medicalmanagement",
                "display" : "Medical Management"
              }
            ]
          }
        }
      ]
    }
  ],
  "adjudication" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/subjectToMedicalMgmt",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/medical-management-type",
                "code" : "concurrent-review",
                "display" : "Concurrent Review"
              }
            ]
          }
        }
      ],
      "category" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
            "code" : "medicalmanagement",
            "display" : "Medical Management"
          }
        ]
      }
    },
    {
      "category" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
            "code" : "submitted",
            "display" : "Submitted Amount"
          }
        ]
      }
    },
    {
      "category" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
            "code" : "memberliability",
            "display" : "Member Liability"
          }
        ]
      }
    }
  ],
  "total" : [
    {
      "category" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
            "version" : "1.0.1",
            "code" : "submitted",
            "display" : "Submitted Amount"
          }
        ]
      },
      "amount" : {
        "value" : 200,
        "currency" : "USD"
      }
    },
    {
      "category" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAdjudicationCategoryCS",
            "code" : "memberliability",
            "display" : "Member liability"
          }
        ]
      },
      "amount" : {
        "value" : 20,
        "currency" : "USD"
      }
    },
    {
      "category" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
            "version" : "1.0.1",
            "code" : "eligible",
            "display" : "Eligible Amount"
          }
        ]
      },
      "amount" : {
        "value" : 190,
        "currency" : "USD"
      }
    }
  ],
  "processNote" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/processNoteClass",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAEOBProcessNoteCS",
                "code" : "disclaimer",
                "display" : "Disclaimer"
              }
            ]
          }
        }
      ],
      "text" : "processNote disclaimer text"
    }
  ],
  "benefitPeriod" : {
    "start" : "2022-01-01",
    "end" : "2023-01-01"
  },
  "benefitBalance" : [
    {
      "category" : {
        "coding" : [
          {
            "system" : "https://x12.org/codes/service-type-codes",
            "code" : "1",
            "display" : "Medical Care"
          }
        ],
        "text" : "Medical Care"
      },
      "unit" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/benefit-unit",
            "code" : "individual"
          }
        ]
      },
      "term" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/benefit-term",
            "code" : "annual"
          }
        ]
      },
      "financial" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/remaining-benefit",
              "valueMoney" : {
                "value" : 0,
                "currency" : "USD"
              }
            }
          ],
          "type" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTFinancialType",
                "code" : "allowed"
              }
            ]
          },
          "allowedMoney" : {
            "value" : 1,
            "currency" : "USD"
          },
          "usedMoney" : {
            "value" : 1,
            "currency" : "USD"
          }
        }
      ]
    }
  ]
}

```
