# coverage1001 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **coverage1001**

## Example Coverage: coverage1001

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [PCT Coverage](StructureDefinition-davinci-pct-coverage.md)

**Extension Definition for Coverage.kind for Version 5.0**: insurance

**status**: Active

**subscriberId**: PFP123450000

**beneficiary**: [Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)

**relationship**: Self

**period**: 2021-01-01 --> 2022-01-01

**payor**: [Organization Umbrella Insurance Company](Organization-org1001.md)

### Classes

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Type** | **Value** | **Name** |
| * | Plan | Premim Family Plus | Premim Family Plus Plan |

### CostToBeneficiaries

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Value[x]** |
| * | Copay Percentage | 20 |



## Resource Content

```json
{
  "resourceType" : "Coverage",
  "id" : "coverage1001",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Coverage.kind",
      "valueCode" : "insurance"
    }
  ],
  "status" : "active",
  "subscriberId" : "PFP123450000",
  "beneficiary" : {
    "reference" : "Patient/patient1001"
  },
  "relationship" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
        "code" : "self",
        "display" : "Self"
      }
    ]
  },
  "period" : {
    "start" : "2021-01-01",
    "end" : "2022-01-01"
  },
  "payor" : [
    {
      "reference" : "Organization/org1001"
    }
  ],
  "class" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
            "code" : "plan",
            "display" : "Plan"
          }
        ]
      },
      "value" : "Premim Family Plus",
      "name" : "Premim Family Plus Plan"
    }
  ],
  "costToBeneficiary" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/coverage-copay-type",
            "code" : "copaypct",
            "display" : "Copay Percentage"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 20
      }
    }
  ]
}

```
