# PCT GFE Request Task Status Reason Code Code System - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT GFE Request Task Status Reason Code Code System**

## CodeSystem: PCT GFE Request Task Status Reason Code Code System 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTTaskStatusReasonCSTemporaryTrialUse | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PCTTaskStatusReasonCSTemporaryTrialUse |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.16.5 | | |
| **Copyright/Legal**: This CodeSystem is not copyrighted. | | |

 
Codes for defining GFE request task status reason types. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [PCTContributorTaskStatusReasonCodes](ValueSet-PCTContributorTaskStatusReasonCodes.md)
* [PCTCoordinationTaskStatusReasonCodes](ValueSet-PCTCoordinationTaskStatusReasonCodes.md)

**Changes since version 1.1.0:**

* New Content



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "PCTTaskStatusReasonCSTemporaryTrialUse",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTTaskStatusReasonCSTemporaryTrialUse",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.16.5"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTTaskStatusReasonCSTemporaryTrialUse",
  "title" : "PCT GFE Request Task Status Reason Code Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Codes for defining GFE request task status reason types. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "This CodeSystem is not copyrighted.",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 8,
  "concept" : [
    {
      "code" : "fulfilled",
      "display" : "Fulfilled",
      "definition" : "The GFE Request was fulfilled."
    },
    {
      "code" : "time-limit-reached",
      "display" : "Time Limit Reached",
      "definition" : "The time period to provide the GFE has been reached."
    },
    {
      "code" : "no-longer-needed",
      "display" : "No Longer Needed",
      "definition" : "The GFE is not longer needed."
    },
    {
      "code" : "service-cancelled",
      "display" : "Service Cancelled",
      "definition" : "Scheduled service was cancelled."
    },
    {
      "code" : "requires-new-request",
      "display" : "Requires New Request",
      "definition" : "Changes need to be made to the request which require the current request be cancelled and a new request be made."
    },
    {
      "code" : "patient-declined",
      "display" : "Patient Declined",
      "definition" : "Patient has declined to receive a GFE or AEOB."
    },
    {
      "code" : "schedule",
      "display" : "Schedule",
      "definition" : "Provider cannot participate due to proposed schedule dates and or times."
    },
    {
      "code" : "service-not-provided",
      "display" : "Service Not Provided",
      "definition" : "Services or Products being requested are not available from this GFE contributor."
    }
  ]
}

```
