# PCT Document Types - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT Document Types**

## CodeSystem: PCT Document Types 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentTypeTemporaryTrialUse | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PCTDocumentTypeTemporaryTrialUse |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.16.23 | | |
| **Copyright/Legal**: This CodeSystem is not copyrighted. | | |

 
Defining codes for types and categories of documents and collections used for Patient Cost Transparency estimates. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as LOINC, which will result in a code system url change and possibly modified codes and definitions. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

**Changes since version 1.1.0:**

* New Content



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "PCTDocumentTypeTemporaryTrialUse",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentTypeTemporaryTrialUse",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.16.23"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTDocumentTypeTemporaryTrialUse",
  "title" : "PCT Document Types",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Defining codes for types and categories of documents and collections used for Patient Cost Transparency estimates. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as LOINC, which will result in a code system url change and possibly modified codes and definitions.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "This CodeSystem is not copyrighted.",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 5,
  "concept" : [
    {
      "code" : "gfe-bundle",
      "display" : "GFE Bundle",
      "definition" : "A Good Faith Estimate (GFE) Bundle GFE Bundle that contains all resources for a Good faith estimate submitted by a single GFE contributing provider. Organizations for both the provider and payer MAY be included. This single contributing provider GFE Bundle may be included in a set of GFE bundles from other providers in a GFE Packet that can then be made available to the patient or sent to a payer for insurance estimation."
    },
    {
      "code" : "gfe-information-bundle",
      "display" : "GFE Information Bundle",
      "definition" : "A Good Faith Estimate (GFE) Informational Bundle that contains the information necessary for GFE contributors to create their estimates. This bundle may for all GFE Contributors or  specific to a single contributor and may include, but is not limited to, the Patient Resource, request resources (such as ServiceRequest, MedicationRequest, and DeviceRequest), Service location information, Coverage and Payer Organization resources (if applicable)."
    },
    {
      "code" : "estimate",
      "display" : "Estimation Packet",
      "definition" : "An estimate of healthcare services, products, costs and/or benefits."
    },
    {
      "code" : "pct-gfe-packet",
      "display" : "PCT GFE Packet",
      "definition" : "Patient Cost Transparency (PCT) Good Faith Estimate (GFE) Packet bundle that contains GFE Bundles from GFE contributors."
    },
    {
      "code" : "pct-aeob-packet",
      "display" : "PCT AEOB Packet",
      "definition" : "Patient Cost Transparency (PCT) Advanced Explanation of Benefit (AEOB) Packet PCT AEOB Packet that contains product and service estimations provided by a payer based on a provider submitted Good Faith Estimate (GFE) and a members coverage and benefits."
    }
  ]
}

```
