# PCT AEOB Process Note Code System - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT AEOB Process Note Code System**

## CodeSystem: PCT AEOB Process Note Code System 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAEOBProcessNoteCS | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:PCTAEOBProcessNoteCS |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.4.16.1 | | |
| **Copyright/Legal**: This CodeSystem is not copyrighted. | | |

 
Defining codes for process notes. This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [PCTAEOBProcessNoteVS](ValueSet-PCTAEOBProcessNoteVS.md)

**Changes since version 1.1.0:**

* The resource metadata has changed (description)

* The list of codes defined by the code system has changed



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "PCTAEOBProcessNoteCS",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTAEOBProcessNoteCS",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.16.1"
    }
  ],
  "version" : "2.0.0",
  "name" : "PCTAEOBProcessNoteCS",
  "title" : "PCT AEOB Process Note Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-26T16:21:43+00:00",
  "publisher" : "HL7 International / Financial Management",
  "contact" : [
    {
      "name" : "HL7 International / Financial Management",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/fm"
        },
        {
          "system" : "email",
          "value" : "fmlists@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Defining codes for process notes.  This CodeSystem is currently defined by this IG, but is anticipated to be temporary. The concepts within are expected to be moved in a future version to a more central terminology specification such as THO, which will result in a code system url change and possibly modified codes and definitions.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "This CodeSystem is not copyrighted.",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 4,
  "concept" : [
    {
      "code" : "disclaimer",
      "display" : "Disclaimer",
      "definition" : "Indicates a disclaimer type of process note"
    },
    {
      "code" : "adjudication-note",
      "display" : "Adjudication Note",
      "definition" : "Indicates an adjudication note type of process note"
    },
    {
      "code" : "conditional",
      "display" : "Conditional",
      "definition" : "Indicates a conditional type of note which supplements information that is already included in the required Medical Management or Prior Authorization information.  A process note that includes information about conditional factors of the estimate not captured in the originating GFE submission of  the advanced explanation of benefit."
    },
    {
      "code" : "other",
      "display" : "Other",
      "definition" : "Indicates other type of AEOB process note"
    }
  ]
}

```
