# PCT-GFE-Coordination-Bundle-1 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT-GFE-Coordination-Bundle-1**

## Example Bundle: PCT-GFE-Coordination-Bundle-1

Profile: [PCT GFE Coordination Bundle](StructureDefinition-davinci-pct-gfe-coordination-bundle.md)

Bundle PCT-GFE-Coordination-Bundle-1 of type transaction

-------

Entry 1 - fullUrl = http://example.org/fhir/Task/PCT-GFE-Coordination-Task-1

Resource Task:

> 

Profile: [PCT GFE Coordination Task](StructureDefinition-davinci-pct-gfe-coordination-task.md)

**Request Initiation Time**: 2024-03-27 11:01:00+0500**Extension Definition for Task.requestedPeriod for Version 5.0**: ?? --> 2024-03-30 11:01:00+0500**Planned Service Period**: 2024-04-27 10:00:00+0500 --> 2024-04-27 11:00:00+0500**status**: Requested**intent**: Order**code**:GFE Coordination Task**requester**:[Organization GFE Service Help INC.](Organization-Submitter-Org-1.md)

### Inputs

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Value[x]** |
| * | GFE Information Bundle | [Bundle: identifier = http://example.com/identifiers/bundle#59688475-2324-3242-2347384711; type = collection; timestamp = 2024-03-27 11:01:00+0500](Bundle-PCT-GFE-Information-Bundle-1.md) |


Request:

```
POST Task

```

-------

Entry 2 - fullUrl = http://example.org/fhir/Task/PCT-GFE-Contributor-Task-1

Resource Task:

> 

Profile: [PCT GFE Contributor Task](StructureDefinition-davinci-pct-gfe-contributor-task.md)

**Request Initiation Time**: 2024-03-27 11:01:00+0500**Extension Definition for Task.requestedPeriod for Version 5.0**: ?? --> 2024-03-30 11:01:00+0500**Planned Service Period**: 2024-04-27 10:00:00+0500 --> 2024-04-27 11:00:00+0500**partOf**:[Task GFE Coordination Task](Task-PCT-GFE-Coordination-Task-1.md)**status**: Received**intent**: Order**code**:GFE Contributor Task**requester**:[Organization GFE Service Help INC.](Organization-Submitter-Org-1.md)**owner**:[Organization GFE Service Help INC.](Organization-Submitter-Org-1.md)

Request:

```
POST Task

```

-------

Entry 3 - fullUrl = http://example.org/fhir/Task/PCT-GFE-Contributor-Task-2

Resource Task:

> 

Profile: [PCT GFE Contributor Task](StructureDefinition-davinci-pct-gfe-contributor-task.md)

**Request Initiation Time**: 2024-03-27 11:01:00+0500**Extension Definition for Task.requestedPeriod for Version 5.0**: ?? --> 2024-03-30 11:01:00+0500**Planned Service Period**: 2024-04-27 10:00:00+0500 --> 2024-04-27 11:00:00+0500**partOf**:[Task GFE Coordination Task](Task-PCT-GFE-Coordination-Task-1.md)**status**: Received**intent**: Order**code**:GFE Contributor Task**requester**:[Organization GFE Service Help INC.](Organization-Submitter-Org-1.md)**owner**:[Organization Boston Radiology Center](Organization-org1002.md)

Request:

```
POST Task

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "PCT-GFE-Coordination-Bundle-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-coordination-bundle"
    ]
  },
  "identifier" : {
    "system" : "http://example.com/identifiers/bundle",
    "value" : "59688475-2324-3242-2347384710"
  },
  "type" : "transaction",
  "timestamp" : "2024-03-27T11:01:00+05:00",
  "entry" : [
    {
      "id" : "PCT-GFE-Coordination-Task-1",
      "fullUrl" : "http://example.org/fhir/Task/PCT-GFE-Coordination-Task-1",
      "resource" : {
        "resourceType" : "Task",
        "id" : "PCT-GFE-Coordination-Task-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-coordination-task"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Task_PCT-GFE-Coordination-Task-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Task PCT-GFE-Coordination-Task-1</b></p><a name=\"PCT-GFE-Coordination-Task-1\"> </a><a name=\"hcPCT-GFE-Coordination-Task-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-gfe-coordination-task.html\">PCT GFE Coordination Task</a></p></div><p><b>Request Initiation Time</b>: 2024-03-27 11:01:00+0500</p><p><b>Extension Definition for Task.requestedPeriod for Version 5.0</b>: ?? --&gt; 2024-03-30 11:01:00+0500</p><p><b>Planned Service Period</b>: 2024-04-27 10:00:00+0500 --&gt; 2024-04-27 11:00:00+0500</p><p><b>status</b>: Requested</p><p><b>intent</b>: order</p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse gfe-coordination-task}\">GFE Coordination Task</span></p><p><b>requester</b>: <a href=\"Organization-Submitter-Org-1.html\">Organization GFE Service Help INC.</a></p><p><b>reasonCode</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse scheduled-request}\">Scheduled Service Request</span></p><h3>Inputs</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Type</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentTypeTemporaryTrialUse gfe-information-bundle}\">GFE Information Bundle</span></td><td><a href=\"Bundle-PCT-GFE-Information-Bundle-1.html\">Bundle: identifier = http://example.com/identifiers/bundle#59688475-2324-3242-2347384711; type = collection; timestamp = 2024-03-27 11:01:00+0500</a></td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/requestInitiationTime",
            "valueInstant" : "2024-03-27T11:01:00+05:00"
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Task.requestedPeriod",
            "valuePeriod" : {
              "end" : "2024-03-30T11:01:00+05:00"
            }
          },
          {
            "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/plannedServicePeriod",
            "valuePeriod" : {
              "start" : "2024-04-27T10:00:00+05:00",
              "end" : "2024-04-27T11:00:00+05:00"
            }
          }
        ],
        "status" : "requested",
        "intent" : "order",
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse",
              "code" : "gfe-coordination-task"
            }
          ]
        },
        "requester" : {
          "reference" : "Organization/Submitter-Org-1"
        },
        "reasonCode" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse",
              "code" : "scheduled-request"
            }
          ]
        },
        "input" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTDocumentTypeTemporaryTrialUse",
                  "code" : "gfe-information-bundle"
                }
              ],
              "text" : "GFE Information Bundle"
            },
            "valueReference" : {
              "reference" : "Bundle/PCT-GFE-Information-Bundle-1"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Task"
      }
    },
    {
      "id" : "PCT-GFE-Contributor-Task-1",
      "fullUrl" : "http://example.org/fhir/Task/PCT-GFE-Contributor-Task-1",
      "resource" : {
        "resourceType" : "Task",
        "id" : "PCT-GFE-Contributor-Task-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-contributor-task"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Task_PCT-GFE-Contributor-Task-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Task PCT-GFE-Contributor-Task-1</b></p><a name=\"PCT-GFE-Contributor-Task-1\"> </a><a name=\"hcPCT-GFE-Contributor-Task-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-gfe-contributor-task.html\">PCT GFE Contributor Task</a></p></div><p><b>Request Initiation Time</b>: 2024-03-27 11:01:00+0500</p><p><b>Extension Definition for Task.requestedPeriod for Version 5.0</b>: ?? --&gt; 2024-03-30 11:01:00+0500</p><p><b>Planned Service Period</b>: 2024-04-27 10:00:00+0500 --&gt; 2024-04-27 11:00:00+0500</p><p><b>partOf</b>: <a href=\"Task-PCT-GFE-Coordination-Task-1.html\">Task GFE Coordination Task</a></p><p><b>status</b>: Received</p><p><b>intent</b>: order</p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse gfe-contributor-task}\">GFE Contributor Task</span></p><p><b>requester</b>: <a href=\"Organization-Submitter-Org-1.html\">Organization GFE Service Help INC.</a></p><p><b>owner</b>: <a href=\"Organization-Submitter-Org-1.html\">Organization GFE Service Help INC.</a></p></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/requestInitiationTime",
            "valueInstant" : "2024-03-27T11:01:00+05:00"
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Task.requestedPeriod",
            "valuePeriod" : {
              "end" : "2024-03-30T11:01:00+05:00"
            }
          },
          {
            "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/plannedServicePeriod",
            "valuePeriod" : {
              "start" : "2024-04-27T10:00:00+05:00",
              "end" : "2024-04-27T11:00:00+05:00"
            }
          }
        ],
        "partOf" : [
          {
            "reference" : "Task/PCT-GFE-Coordination-Task-1"
          }
        ],
        "status" : "received",
        "intent" : "order",
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse",
              "code" : "gfe-contributor-task"
            }
          ]
        },
        "requester" : {
          "reference" : "Organization/Submitter-Org-1"
        },
        "owner" : {
          "reference" : "Organization/Submitter-Org-1"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Task"
      }
    },
    {
      "id" : "PCT-GFE-Contributor-Task-2",
      "fullUrl" : "http://example.org/fhir/Task/PCT-GFE-Contributor-Task-2",
      "resource" : {
        "resourceType" : "Task",
        "id" : "PCT-GFE-Contributor-Task-2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-contributor-task"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Task_PCT-GFE-Contributor-Task-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Task PCT-GFE-Contributor-Task-2</b></p><a name=\"PCT-GFE-Contributor-Task-2\"> </a><a name=\"hcPCT-GFE-Contributor-Task-2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-gfe-contributor-task.html\">PCT GFE Contributor Task</a></p></div><p><b>Request Initiation Time</b>: 2024-03-27 11:01:00+0500</p><p><b>Extension Definition for Task.requestedPeriod for Version 5.0</b>: ?? --&gt; 2024-03-30 11:01:00+0500</p><p><b>Planned Service Period</b>: 2024-04-27 10:00:00+0500 --&gt; 2024-04-27 11:00:00+0500</p><p><b>partOf</b>: <a href=\"Task-PCT-GFE-Coordination-Task-1.html\">Task GFE Coordination Task</a></p><p><b>status</b>: Received</p><p><b>intent</b>: order</p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse gfe-contributor-task}\">GFE Contributor Task</span></p><p><b>requester</b>: <a href=\"Organization-Submitter-Org-1.html\">Organization GFE Service Help INC.</a></p><p><b>owner</b>: <a href=\"Organization-org1002.html\">Organization Boston Radiology Center</a></p></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/requestInitiationTime",
            "valueInstant" : "2024-03-27T11:01:00+05:00"
          },
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Task.requestedPeriod",
            "valuePeriod" : {
              "end" : "2024-03-30T11:01:00+05:00"
            }
          },
          {
            "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/plannedServicePeriod",
            "valuePeriod" : {
              "start" : "2024-04-27T10:00:00+05:00",
              "end" : "2024-04-27T11:00:00+05:00"
            }
          }
        ],
        "partOf" : [
          {
            "reference" : "Task/PCT-GFE-Coordination-Task-1"
          }
        ],
        "status" : "received",
        "intent" : "order",
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTGFERequestTypeCSTemporaryTrialUse",
              "code" : "gfe-contributor-task"
            }
          ]
        },
        "requester" : {
          "reference" : "Organization/Submitter-Org-1"
        },
        "owner" : {
          "reference" : "Organization/org1002"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Task"
      }
    }
  ]
}

```
