# PCT-GFE-Bundle-Prof-1 - Patient Cost Transparency Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCT-GFE-Bundle-Prof-1**

## Example Bundle: PCT-GFE-Bundle-Prof-1

Profile: [PCT GFE Bundle](StructureDefinition-davinci-pct-gfe-bundle.md)

Bundle PCT-GFE-Bundle-Prof-1 of type collection

-------

Entry 1 - fullUrl = http://example.org/fhir/Claim/PCT-GFE-Summary-MRI

Resource Claim:

> 

Profile: [PCT Good Faith Estimate Summary](StructureDefinition-davinci-pct-gfe-summary.md)

**status**: Active**type**:Estimate Summary**use**: Predetermination**patient**:[Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)**billablePeriod**: 2021-10-31 --> (ongoing)**created**: 2021-10-05**insurer**:[Organization Umbrella Insurance Company](Organization-org1001.md)**provider**: ?rref?**priority**:Normal

### Diagnoses

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Diagnosis[x]** | **Type** |
| * | 1 | Unspecified focal traumatic brain injury | Principal Diagnosis |

### Insurances

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Focal** | **Coverage** |
| * | 1 | true | [Coverage: extension = insurance; status = active; subscriberId = PFP123450000; relationship = Self; period = 2021-01-01 --> 2022-01-01](Coverage-coverage1001.md) |

### Totals

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | USD |


-------

Entry 2 - fullUrl = http://example.org/fhir/Claim/PCT-GFE-Professional-MRI

Resource Claim:

> 

Profile: [PCT Good Faith Estimate Professional](StructureDefinition-davinci-pct-gfe-professional.md)

**ProviderEventMethodology**: EEMM1022
> **GFEServiceLinkingInfo**
* linkingIdentifier: `http://example.org/Claim/identifiers`/223452-2342-2435-008001
* plannedPeriodOfService: 2021-10-31

**identifier**: Placer Identifier/GFEProviderAssignedID0002**status**: Active**type**:Professional**use**: Predetermination**patient**:[Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)**created**: 2021-10-05**insurer**:[Organization Umbrella Insurance Company](Organization-org1001.md)**provider**:[Practitioner Nora Ologist](Practitioner-Submitter-Practitioner-1.md)**priority**:Normal

### Payees

| | |
| :--- | :--- |
| - | **Type** |
| * | Provider |

**referral**: Referral Number

### Diagnoses

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Diagnosis[x]** | **Type** |
| * | 1 | Unspecified focal traumatic brain injury | Principal Diagnosis |

### Insurances

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Focal** | **Coverage** |
| * | 1 | true | [Coverage: extension = insurance; status = active; subscriberId = PFP123450000; relationship = Self; period = 2021-01-01 --> 2022-01-01](Coverage-coverage1001.md) |

> **item****Service Description**: Imaging**GFEBillingProviderLineItemCtrlNum**: GFEBillingProviderLineItemCtrlNum-0001**sequence**: 1**productOrService**:Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material**modifier**:Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material**serviced**: 2021-10-31**location**:Inpatient Hospital**quantity**: 1

### UnitPrices

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | USD |

### Nets

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | USD |


### Totals

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200 | USD |


-------

Entry 3 - fullUrl = http://example.org/fhir/Practitioner/Submitter-Practitioner-1

Resource Practitioner:

> 

Profile: [PCT Practitioner](StructureDefinition-davinci-pct-practitioner.md)

**identifier**:[United States National Provider Identifier](http://terminology.hl7.org/6.5.0/NamingSystem-npi.html)/9941339100, Electronic Transmitter Identification Number/ETIN-20020001**active**: true**name**: Nora Ologist**telecom**: ph: 860-547-3301(Work),[csender@GFEServiceHelp.com](mailto:csender@GFEServiceHelp.com)

-------

Entry 4 - fullUrl = http://example.org/fhir/Organization/org1001

Resource Organization:

> 

Profile: [PCT Organization](StructureDefinition-davinci-pct-organization.md)

**identifier**: Electronic Transmitter Identification Number/ETIN-3200002**active**: true**type**:Payer**name**: Umbrella Insurance Company

### Contacts

| | | |
| :--- | :--- | :--- |
| - | **Telecom** | **Address** |
| * | ph: 860-547-5001(Work) | 680 Asylum Street Hartford CT 06155 US |


-------

Entry 5 - fullUrl = http://example.org/fhir/Patient/patient1001

Resource Patient:

> **Eve Betterhalf**female, DoB: 1955-07-23 (`http://example.com/identifiers/patient`/1001)
-------

| | |
| :--- | :--- |
| Marital Status: | unmarried |
| Contact Details: | * ph: 781-949-4949(MOBILE)
* 222 Burlington Road, Bedford MA 01730
 |
| Language: | English (United States)(preferred) |


-------

Entry 6 - fullUrl = http://example.org/fhir/Coverage/coverage1001

Resource Coverage:

> 

Profile: [PCT Coverage](StructureDefinition-davinci-pct-coverage.md)

**Extension Definition for Coverage.kind for Version 5.0**: insurance**status**: Active**subscriberId**: PFP123450000**beneficiary**:[Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)](Patient-patient1001.md)**relationship**:Self**period**: 2021-01-01 --> 2022-01-01

### Classes

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Type** | **Value** | **Name** |
| * | Plan | Premim Family Plus | Premim Family Plus Plan |

### CostToBeneficiaries

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Value[x]** |
| * | Copay Percentage | 20 |




## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "PCT-GFE-Bundle-Prof-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-bundle"
    ]
  },
  "identifier" : {
    "system" : "http://example.com/identifiers/bundle",
    "value" : "59688475-2324-3242-23473847"
  },
  "type" : "collection",
  "timestamp" : "2021-11-09T11:01:00+05:00",
  "entry" : [
    {
      "fullUrl" : "http://example.org/fhir/Claim/PCT-GFE-Summary-MRI",
      "resource" : {
        "resourceType" : "Claim",
        "id" : "PCT-GFE-Summary-MRI",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-summary"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Claim_PCT-GFE-Summary-MRI\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Claim PCT-GFE-Summary-MRI</b></p><a name=\"PCT-GFE-Summary-MRI\"> </a><a name=\"hcPCT-GFE-Summary-MRI\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-gfe-summary.html\">PCT Good Faith Estimate  Summary</a></p></div><p><b>status</b>: Active</p><p><b>type</b>: <span title=\"Codes:{http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTEstimateTypeSummaryCSTemporaryTrialUse estimate-summary}\">Estimate Summary</span></p><p><b>use</b>: Predetermination</p><p><b>patient</b>: <a href=\"Patient-patient1001.html\">Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)</a></p><p><b>billablePeriod</b>: 2021-10-31 --&gt; (ongoing)</p><p><b>created</b>: 2021-10-05</p><p><b>insurer</b>: <a href=\"Organization-org1001.html\">Organization Umbrella Insurance Company</a></p><p><b>provider</b>: ?rref?</p><p><b>priority</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/processpriority normal}\">Normal</span></p><h3>Diagnoses</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Sequence</b></td><td><b>Diagnosis[x]</b></td><td><b>Type</b></td><td><b>PackageCode</b></td></tr><tr><td style=\"display: none\">*</td><td>1</td><td><span title=\"Codes:{http://hl7.org/fhir/sid/icd-10-cm S06.30}\">Unspecified focal traumatic brain injury</span></td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/diagnosistype principal}\">Principal Diagnosis</span></td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/ex-diagnosisrelatedgroup 400}\">Head trauma - concussion</span></td></tr></table><h3>Insurances</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Sequence</b></td><td><b>Focal</b></td><td><b>Coverage</b></td></tr><tr><td style=\"display: none\">*</td><td>1</td><td>true</td><td><a href=\"Coverage-coverage1001.html\">Coverage: extension = insurance; status = active; subscriberId = PFP123450000; relationship = Self; period = 2021-01-01 --&gt; 2022-01-01</a></td></tr></table><h3>Totals</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>200</td><td>United States dollar</td></tr></table></div>"
        },
        "status" : "active",
        "type" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pct/CodeSystem/PCTEstimateTypeSummaryCSTemporaryTrialUse",
              "code" : "estimate-summary",
              "display" : "Estimate Summary"
            }
          ]
        },
        "use" : "predetermination",
        "patient" : {
          "reference" : "Patient/patient1001"
        },
        "billablePeriod" : {
          "start" : "2021-10-31"
        },
        "created" : "2021-10-05",
        "insurer" : {
          "reference" : "Organization/org1001"
        },
        "provider" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
              "valueCode" : "not-applicable"
            }
          ]
        },
        "priority" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/processpriority",
              "code" : "normal"
            }
          ]
        },
        "diagnosis" : [
          {
            "sequence" : 1,
            "diagnosisCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/sid/icd-10-cm",
                  "code" : "S06.30",
                  "display" : "Unspecified focal traumatic brain injury"
                }
              ]
            },
            "type" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/diagnosistype",
                    "code" : "principal"
                  }
                ]
              }
            ],
            "packageCode" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/ex-diagnosisrelatedgroup",
                  "code" : "400",
                  "display" : "Head trauma - concussion"
                }
              ]
            }
          }
        ],
        "insurance" : [
          {
            "sequence" : 1,
            "focal" : true,
            "coverage" : {
              "reference" : "Coverage/coverage1001"
            }
          }
        ],
        "total" : {
          "value" : 200,
          "currency" : "USD"
        }
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Claim/PCT-GFE-Professional-MRI",
      "resource" : {
        "resourceType" : "Claim",
        "id" : "PCT-GFE-Professional-MRI",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-gfe-professional"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Claim_PCT-GFE-Professional-MRI\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Claim PCT-GFE-Professional-MRI</b></p><a name=\"PCT-GFE-Professional-MRI\"> </a><a name=\"hcPCT-GFE-Professional-MRI\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-gfe-professional.html\">PCT Good Faith Estimate Professional</a></p></div><p><b>ProviderEventMethodology</b>: EEMM1022</p><blockquote><p><b>GFEServiceLinkingInfo</b></p><ul><li>linkingIdentifier: <code>http://example.org/Claim/identifiers</code>/223452-2342-2435-008001</li><li>plannedPeriodOfService: 2021-10-31</li></ul></blockquote><p><b>identifier</b>: Placer Identifier/GFEProviderAssignedID0002</p><p><b>status</b>: Active</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/claim-type professional}\">Professional</span></p><p><b>use</b>: Predetermination</p><p><b>patient</b>: <a href=\"Patient-patient1001.html\">Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)</a></p><p><b>created</b>: 2021-10-05</p><p><b>insurer</b>: <a href=\"Organization-org1001.html\">Organization Umbrella Insurance Company</a></p><p><b>provider</b>: <a href=\"Practitioner-Submitter-Practitioner-1.html\">Practitioner Nora Ologist</a></p><p><b>priority</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/processpriority normal}\">Normal</span></p><h3>Payees</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Type</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/payeetype provider}\">Provider</span></td></tr></table><p><b>referral</b>: Referral Number</p><h3>Diagnoses</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Sequence</b></td><td><b>Diagnosis[x]</b></td><td><b>Type</b></td><td><b>PackageCode</b></td></tr><tr><td style=\"display: none\">*</td><td>1</td><td><span title=\"Codes:{http://hl7.org/fhir/sid/icd-10-cm S06.30}\">Unspecified focal traumatic brain injury</span></td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/diagnosistype principal}\">Principal Diagnosis</span></td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/ex-diagnosisrelatedgroup 400}\">Head trauma - concussion</span></td></tr></table><h3>Insurances</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Sequence</b></td><td><b>Focal</b></td><td><b>Coverage</b></td></tr><tr><td style=\"display: none\">*</td><td>1</td><td>true</td><td><a href=\"Coverage-coverage1001.html\">Coverage: extension = insurance; status = active; subscriberId = PFP123450000; relationship = Self; period = 2021-01-01 --&gt; 2022-01-01</a></td></tr></table><blockquote><p><b>item</b></p><p><b>Service Description</b>: Imaging</p><p><b>GFEBillingProviderLineItemCtrlNum</b>: GFEBillingProviderLineItemCtrlNum-0001</p><p><b>sequence</b>: 1</p><p><b>productOrService</b>: <span title=\"Codes:{http://www.ama-assn.org/go/cpt 70551}\">Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material</span></p><p><b>modifier</b>: <span title=\"Codes:{http://www.ama-assn.org/go/cpt 70551}\">Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material</span></p><p><b>serviced</b>: 2021-10-31</p><p><b>location</b>: <span title=\"Codes:{https://www.cms.gov/Medicare/Coding/place-of-service-codes/Place_of_Service_Code_Set 21}\">Inpatient Hospital</span></p><p><b>quantity</b>: 1</p><h3>UnitPrices</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>200</td><td>United States dollar</td></tr></table><h3>Nets</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>200</td><td>United States dollar</td></tr></table></blockquote><h3>Totals</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>200</td><td>United States dollar</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/providerEventMethodology",
            "valueString" : "EEMM1022"
          },
          {
            "extension" : [
              {
                "url" : "linkingIdentifier",
                "valueIdentifier" : {
                  "system" : "http://example.org/Claim/identifiers",
                  "value" : "223452-2342-2435-008001"
                }
              },
              {
                "url" : "plannedPeriodOfService",
                "valueDate" : "2021-10-31"
              }
            ],
            "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeServiceLinkingInfo"
          }
        ],
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "PLAC",
                  "display" : "Placer Identifier"
                }
              ]
            },
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "value" : "GFEProviderAssignedID0002"
          }
        ],
        "status" : "active",
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
              "code" : "professional",
              "display" : "Professional"
            }
          ]
        },
        "use" : "predetermination",
        "patient" : {
          "reference" : "Patient/patient1001"
        },
        "created" : "2021-10-05",
        "insurer" : {
          "reference" : "Organization/org1001"
        },
        "provider" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/providerTaxonomy",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://nucc.org/provider-taxonomy",
                    "code" : "2085D0003X",
                    "display" : "Diagnostic Neuroimaging (Radiology) Physician"
                  }
                ]
              }
            }
          ],
          "reference" : "Practitioner/Submitter-Practitioner-1"
        },
        "priority" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/processpriority",
              "code" : "normal"
            }
          ]
        },
        "payee" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/payeetype",
                "code" : "provider"
              }
            ]
          }
        },
        "referral" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/referralNumber",
              "valueString" : "REF12022002-122"
            }
          ],
          "display" : "Referral Number"
        },
        "diagnosis" : [
          {
            "sequence" : 1,
            "diagnosisCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/sid/icd-10-cm",
                  "code" : "S06.30",
                  "display" : "Unspecified focal traumatic brain injury"
                }
              ]
            },
            "type" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/diagnosistype",
                    "code" : "principal"
                  }
                ]
              }
            ],
            "packageCode" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/ex-diagnosisrelatedgroup",
                  "code" : "400",
                  "display" : "Head trauma - concussion"
                }
              ]
            }
          }
        ],
        "insurance" : [
          {
            "sequence" : 1,
            "focal" : true,
            "coverage" : {
              "reference" : "Coverage/coverage1001"
            }
          }
        ],
        "item" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/serviceDescription",
                "valueString" : "Imaging"
              },
              {
                "url" : "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/gfeBillingProviderLineItemCtrlNum",
                "valueIdentifier" : {
                  "value" : "GFEBillingProviderLineItemCtrlNum-0001"
                }
              }
            ],
            "sequence" : 1,
            "productOrService" : {
              "coding" : [
                {
                  "system" : "http://www.ama-assn.org/go/cpt",
                  "code" : "70551",
                  "display" : "Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material"
                }
              ]
            },
            "modifier" : [
              {
                "coding" : [
                  {
                    "system" : "http://www.ama-assn.org/go/cpt",
                    "code" : "70551",
                    "display" : "Magnetic resonance (eg, proton) imaging, brain (including brain stem); without contrast material"
                  }
                ]
              }
            ],
            "servicedDate" : "2021-10-31",
            "locationCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://www.cms.gov/Medicare/Coding/place-of-service-codes/Place_of_Service_Code_Set",
                  "code" : "21",
                  "display" : "Inpatient Hospital"
                }
              ]
            },
            "quantity" : {
              "value" : 1
            },
            "unitPrice" : {
              "value" : 200,
              "currency" : "USD"
            },
            "net" : {
              "value" : 200,
              "currency" : "USD"
            }
          }
        ],
        "total" : {
          "value" : 200,
          "currency" : "USD"
        }
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Practitioner/Submitter-Practitioner-1",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "Submitter-Practitioner-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_Submitter-Practitioner-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner Submitter-Practitioner-1</b></p><a name=\"Submitter-Practitioner-1\"> </a><a name=\"hcSubmitter-Practitioner-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-practitioner.html\">PCT Practitioner</a></p></div><p><b>identifier</b>: <a href=\"http://terminology.hl7.org/6.5.0/NamingSystem-npi.html\" title=\"National Provider Identifier\">United States National Provider Identifier</a>/9941339100, Electronic Transmitter Identification Number/ETIN-20020001</p><p><b>active</b>: true</p><p><b>name</b>: Nora Ologist</p><p><b>telecom</b>: ph: 860-547-3301(Work), <a href=\"mailto:csender@GFEServiceHelp.com\">csender@GFEServiceHelp.com</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://hl7.org/fhir/sid/us-npi",
            "value" : "9941339100"
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "ETIN"
                }
              ]
            },
            "system" : "http://example.com/us-etin",
            "value" : "ETIN-20020001"
          }
        ],
        "active" : true,
        "name" : [
          {
            "text" : "Nora Ologist",
            "family" : "Ologist",
            "given" : ["Nora"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "860-547-3301",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "csender@GFEServiceHelp.com",
            "use" : "work"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Organization/org1001",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "org1001",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_org1001\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization org1001</b></p><a name=\"org1001\"> </a><a name=\"hcorg1001\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-organization.html\">PCT Organization</a></p></div><p><b>identifier</b>: Electronic Transmitter Identification Number/ETIN-3200002</p><p><b>active</b>: true</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/organization-type pay}\">Payer</span></p><p><b>name</b>: Umbrella Insurance Company</p><p><b>telecom</b>: ph: 860-547-5001(Work)</p><p><b>address</b>: 680 Asylum Street Hartford CT 06155 US </p></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "ETIN"
                }
              ]
            },
            "value" : "ETIN-3200002"
          }
        ],
        "active" : true,
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
                "code" : "pay",
                "display" : "Payer"
              }
            ]
          }
        ],
        "name" : "Umbrella Insurance Company",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "860-547-5001",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["680 Asylum Street"],
            "city" : "Hartford",
            "state" : "CT",
            "postalCode" : "06155",
            "country" : "US"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Patient/patient1001",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "patient1001",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
          ]
        },
        "text" : {
          "status" : "additional",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_patient1001\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\"><b>Eve Betterhalf</b> female, DoB: 1955-07-23 ( <code>http://example.com/identifiers/patient</code>/1001)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Known Marital status of Patient\">Marital Status:</td><td colspan=\"3\"><span title=\"Codes: {http://terminology.hl7.org/CodeSystem/v3-MaritalStatus U}\">unmarried</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Details:</td><td colspan=\"3\"><ul><li>ph: 781-949-4949(MOBILE)</li><li>222 Burlington Road, Bedford MA 01730</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Languages spoken\">Language:</td><td colspan=\"3\"><span title=\"Codes: {urn:ietf:bcp:47 en-US}\">English (United States)</span> (preferred)</td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://example.com/identifiers/patient",
            "value" : "1001"
          }
        ],
        "name" : [
          {
            "text" : "Eve Betterhalf",
            "family" : "Betterhalf",
            "given" : ["Eve"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "781-949-4949",
            "use" : "mobile"
          }
        ],
        "gender" : "female",
        "birthDate" : "1955-07-23",
        "address" : [
          {
            "text" : "222 Burlington Road, Bedford MA 01730"
          }
        ],
        "maritalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
              "code" : "U",
              "display" : "unmarried"
            }
          ]
        },
        "communication" : [
          {
            "language" : {
              "coding" : [
                {
                  "system" : "urn:ietf:bcp:47",
                  "code" : "en-US",
                  "display" : "English (United States)"
                }
              ]
            },
            "preferred" : true
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Coverage/coverage1001",
      "resource" : {
        "resourceType" : "Coverage",
        "id" : "coverage1001",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pct/StructureDefinition/davinci-pct-coverage"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Coverage_coverage1001\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Coverage coverage1001</b></p><a name=\"coverage1001\"> </a><a name=\"hccoverage1001\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-davinci-pct-coverage.html\">PCT Coverage</a></p></div><p><b>Extension Definition for Coverage.kind for Version 5.0</b>: insurance</p><p><b>status</b>: Active</p><p><b>subscriberId</b>: PFP123450000</p><p><b>beneficiary</b>: <a href=\"Patient-patient1001.html\">Eve Betterhalf Female, DoB: 1955-07-23 ( http://example.com/identifiers/patient#1001)</a></p><p><b>relationship</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/subscriber-relationship self}\">Self</span></p><p><b>period</b>: 2021-01-01 --&gt; 2022-01-01</p><p><b>payor</b>: <a href=\"Organization-org1001.html\">Organization Umbrella Insurance Company</a></p><h3>Classes</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Type</b></td><td><b>Value</b></td><td><b>Name</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/coverage-class plan}\">Plan</span></td><td>Premim Family Plus</td><td>Premim Family Plus Plan</td></tr></table><h3>CostToBeneficiaries</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Type</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/coverage-copay-type copaypct}\">Copay Percentage</span></td><td>20</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Coverage.kind",
            "valueCode" : "insurance"
          }
        ],
        "status" : "active",
        "subscriberId" : "PFP123450000",
        "beneficiary" : {
          "reference" : "Patient/patient1001"
        },
        "relationship" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
              "code" : "self",
              "display" : "Self"
            }
          ]
        },
        "period" : {
          "start" : "2021-01-01",
          "end" : "2022-01-01"
        },
        "payor" : [
          {
            "reference" : "Organization/org1001"
          }
        ],
        "class" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                  "code" : "plan",
                  "display" : "Plan"
                }
              ]
            },
            "value" : "Premim Family Plus",
            "name" : "Premim Family Plus Plan"
          }
        ],
        "costToBeneficiary" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/coverage-copay-type",
                  "code" : "copaypct",
                  "display" : "Copay Percentage"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 20
            }
          }
        ]
      }
    }
  ]
}

```
