# Resource davinci-pct-aeob-available-author-notification



## Resource Content

```json
{
  "resourceType" : "Basic",
  "id" : "davinci-pct-aeob-available-author-notification",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/davinci-pct/ImplementationGuide/hl7.fhir.us.davinci-pct"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.url",
      "valueUri" : "http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-aeob-available-author-notification"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.version",
      "valueString" : "2.0.0"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.name",
      "valueString" : "PCTAEOBAvailableAuthorSubscriptionTopic"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.title",
      "valueString" : "SubscriptionTopic - AEOB Available for Author Notification"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.status",
      "valueCode" : "active"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.experimental",
      "valueBoolean" : false
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.date",
      "valueDateTime" : "2025-04-05"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.publisher",
      "valueString" : "HL7 International / Financial Management"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.contact",
      "valueContactDetail" : {
        "name" : "HL7 International / Financial Management",
        "telecom" : [
          {
            "system" : "url",
            "value" : "http://www.hl7.org/Special/committees/fm"
          },
          {
            "system" : "email",
            "value" : "fmlists@lists.hl7.org"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.description",
      "valueMarkdown" : "Author focused Subscription Topic when an Advanced Explanation of Benefit (AEOB) Packet DocumentReference is created or updated (for FHIR R4). This represents that an AEOB Bundle, either contained in or referred to by the DocumentReference has been newly created and is available or has been updated, should updates be made.\n\r**Canonical URL:** http://hl7.org/fhir/us/davinci-pct/SubscriptionTopic/davinci-pct-aeob-available-author-notification"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.jurisdiction",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "US"
          }
        ]
      }
    },
    {
      "extension" : [
        {
          "url" : "description",
          "valueMarkdown" : "Triggered when an AEOB Packet DocumentReference is created or updated"
        },
        {
          "url" : "resource",
          "valueUri" : "http://hl7.org/fhir/StructureDefinition/DocumentReference"
        },
        {
          "url" : "supportedInteraction",
          "valueCode" : "create"
        },
        {
          "url" : "supportedInteraction",
          "valueCode" : "update"
        },
        {
          "extension" : [
            {
              "url" : "resultForCreate",
              "valueCode" : "test-passes"
            },
            {
              "url" : "current",
              "valueString" : "type=aeob-packet"
            },
            {
              "url" : "resultForDelete",
              "valueCode" : "test-passes"
            },
            {
              "url" : "requireBoth",
              "valueBoolean" : false
            }
          ],
          "url" : "queryCriteria"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.resourceTrigger"
    },
    {
      "extension" : [
        {
          "url" : "description",
          "valueMarkdown" : "Filter based on the authors of a DocumentReference."
        },
        {
          "url" : "resource",
          "valueUri" : "DocumentReference"
        },
        {
          "url" : "filterParameter",
          "valueString" : "author"
        },
        {
          "url" : "filterDefinition",
          "valueUri" : "http://hl7.org/fhir/SearchParameter/DocumentReference-author"
        },
        {
          "url" : "comparator",
          "valueCode" : "eq"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.canFilterBy"
    },
    {
      "extension" : [
        {
          "url" : "description",
          "valueMarkdown" : "Filter based on the status (current | superseded | entered-in-error) of a DocumentReference."
        },
        {
          "url" : "resource",
          "valueUri" : "DocumentReference"
        },
        {
          "url" : "filterParameter",
          "valueString" : "status"
        },
        {
          "url" : "filterDefinition",
          "valueUri" : "http://hl7.org/fhir/SearchParameter/DocumentReference-status"
        },
        {
          "url" : "comparator",
          "valueCode" : "eq"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.canFilterBy"
    },
    {
      "extension" : [
        {
          "url" : "description",
          "valueMarkdown" : "Filter based on the document status (registered | partial | preliminary | final | amended | corrected | appended | cancelled | entered-in-error | deprecated | unknown) of a DocumentReference."
        },
        {
          "url" : "resource",
          "valueUri" : "DocumentReference"
        },
        {
          "url" : "filterParameter",
          "valueString" : "doc-status"
        },
        {
          "url" : "filterDefinition",
          "valueUri" : "http://hl7.org/fhir/us/davinci-pct/SearchParameter/DocumentReference-doc-status"
        },
        {
          "url" : "comparator",
          "valueCode" : "eq"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.canFilterBy"
    },
    {
      "extension" : [
        {
          "url" : "resource",
          "valueUri" : "DocumentReference"
        }
      ],
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-SubscriptionTopic.notificationShape"
    }
  ],
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.4.44.5"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/fhir-types",
        "code" : "SubscriptionTopic"
      }
    ]
  }
}

```
