# Security and Privacy - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* **Security and Privacy**

## Security and Privacy

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

[Previous Page - Introduction](introduction.md)

The PDex IG adopts the Security and Privacy approach detailed in the [Health Record Exchange (HRex) IG](http://hl7.org/fhir/us/davinci-hrex/STU1.1/security.html). Implementers should also take note of the guidance in the FHIR R4 specification on the [HL7 core security page](http://hl7.org/fhir/R4/security.html). The Security and Privacy section of the HRex IG addresses:

* [Statutes, Regulations, and Guiding Principles](https://hl7.org/fhir/us/davinci-hrex/2024Sep/security.html#statutes-regulations-and-guiding-principles)
* [FHIR Clinical Safety, Security and Implementation Guidance](https://hl7.org/fhir/us/davinci-hrex/2024Sep/security.html#fhir-clinical-safety-security-and-implementation-guidance)
* [Security/Privacy Related Technologies Including Explicit Consent and Security Labels](https://hl7.org/fhir/us/davinci-hrex/2024Sep/security.html#security-privacy-related-technologies-including-explicit-consent)
* [Exchange Security](https://hl7.org/fhir/us/davinci-hrex/2024Sep/security.html#exchange-security)
* [Additionally Protected Information](https://hl7.org/fhir/us/davinci-hrex/2024Sep/security.html#additionally-protected-information)
* [Security Contexts for Da Vinci IGs](https://hl7.org/fhir/us/davinci-hrex/2024Sep/security.html#additionally-protected-information)

The following page ,[FHIR Access Permissions](FHIRAccessPermissions.md), is provided for guidance only and addresses an approach to control access to sub-sets of Patient or Group records by external parties.

[Next Page - FHIR Access Permissions](FHIRAccessPermissions.md)

