# hl7.fhir.us.davinci-pdex#2.1.1: Da Vinci Payer Data Exchange

## Pages

* [Home](index.md)
* [US Core DiagnosticReport for Laboratory Results Reporting](USCoreDiagnosticReportforLaboratoryResultsReporting.md)
* [PDex Implementation Guide](ImplementationGuide-hl7.fhir.us.davinci-pdex.md)
* [US Core Laboratory Result Observation](USCoreLaboratoryResultObservation.md)
* [Change History](changehistory.md)
* [Downloads](PDexDownloads.md)
* [Other IG Artifacts](other-igs.md)
* [Data Mapping](datamapping.md)
* [US Core Smoking Status Observation](USCoreSmokingStatusObservation.md)
* [Security and Privacy](securityandprivacy.md)
* [Workflow Examples](workflowexamples.md)
* [PDex MedicationDispense](PDexMedicationDispense.md)
* [US Core Condition](USCoreCondition.md)
* [US Core Provenance](USCoreProvenance.md)
* [Consent](consent.md)
* [US Core Pediatric Head Occipital-frontal Circumference Observation](USCorePediatricHeadOccipital.md)
* [US Core Organization](USCoreOrganization.md)
* [US Core ImplantableDevice](USCoreImplantableDevice.md)
* [US Core Encounter](USCoreEncounter.md)
* [US Core DocumentReference](USCoreDocumentReference.md)
* [US Core MedicationRequest](USCoreMedicationRequest.md)
* [Coverage](coverage.md)
* [VitalSigns](VitalSigns.md)
* [US Core Location](USCoreLocation.md)
* [Member-Authorized OAuth2.0 Exchange](member-authorizedoauth2exchange.md)
* [US Core DiagnosticReport for Report and Note Exchange](USCoreDiagnosticReportforReportandNoteExchange.md)
* [US Core PractitionerRole](USCorePractitionerRole.md)
* [PDex Device](PdexDevice.md)
* [Payer-to-Payer Exchange (bulk)](payertopayerbulkexchange.md)
* [FHIR Access Permissions](FHIRAccessPermissions.md)
* [PDex Prior Authorization](PDexPriorAuthorization.md)
* [US Core CareTeam](USCoreCareTeam.md)
* [US Core Medication](USCoreMedication.md)
* [Introduction](introduction.md)
* [US Core Procedure](USCoreProcedure.md)
* [US Core CarePlan](USCoreCarePlan.md)
* [Provider Access API](provider-access-api.md)
* [US Core Pediatric BMI for Age Observation](USCorePediatricBMIforAgeObservation.md)
* [PDex Implementation, Actors, Interactions, Data Payloads and Methods](pdeximplementationactorsinteractionsdatapayloadsandmethods.md)
* [US Core Pulse Oximetry](USCorePulseOximetry.md)
* [Provider Access API(v2)](provider-access-api-v2.md)
* [Credits](credits.md)
* [Overview](overview.md)
* [US Core Patient](USCorePatient.md)
* [US Core Pediatric Weight for Height Observation](USCorePediatricWeightforHeightObservation.md)
* [US Core Practitioner](USCorePractitioner.md)
* [CDS Hooks](cds-hooks.md)
* [Payer-to-Payer Exchange (single member)](payertopayerexchange.md)
* [Handling Data Provenance](handlingdataprovenance.md)
* [US Core AllergyIntolerance](USCoreAllergyIntolerance.md)
* [Use Case Scenarios](usecasescenarios.md)
* [PDex Provenance](PDexProvenance.md)
* [FHIR Artifacts](artifacts.md)
* [US Core Immunization](USCoreImmunization.md)
* [US Core Goal](USCoreGoal.md)

## Resources

### CodeSystems

* [Endpoint Payload Types Code System](CodeSystem-EndpointPayloadTypeCS.md)
* [mTLS Object Type Code](CodeSystem-MtlsObjectCodeCS.md)
* [Organization Type](CodeSystem-OrgTypeCS.md)
* [PDex Adjudication Discriminator](CodeSystem-PDexAdjudicationDiscriminator.md)
* [PDex Identifier Type](CodeSystem-PDexIdentifierType.md)
* [PDex Payer Adjudication Status](CodeSystem-PDexPayerAdjudicationStatus.md)
* [PDex Supporting Info Type](CodeSystem-PDexSupportingInfoTypeCS.md)
* [PDex Provider Access API Attribution Code System](CodeSystem-PdexMemberAttributionCS.md)
* [PDex Multi-Member Match Result Code System](CodeSystem-PdexMultiMemberMatchResultCS.md)
* [Prior Authorization Values](CodeSystem-PriorAuthorizationValueCodes.md)
* [Provenance Roles](CodeSystem-ProvenanceAgentRoleType.md)
* [Provenance Payer Data Source Format](CodeSystem-ProvenancePayerDataSource.md)
* [Trust FrameworkType Code System](CodeSystem-TrustFrameworkTypeCS.md)
* [Trust Profile Code System](CodeSystem-TrustProfileCS.md)
* [Opt-Out Reason](CodeSystem-opt-out-reason.md)
* [Opt-Out Scope](CodeSystem-opt-out-scope.md)
* [PDex Member Characteristic Code](CodeSystem-pdex-member-characteristic-code.md)
* [Treatment Relationship Type](CodeSystem-treatment-relationship-type.md)

### ValueSets

* [Endpoint Payload Type Value Set](ValueSet-EndpointPayloadTypeVS.md)
* [FDA National Drug Code (NDC)](ValueSet-FDANationalDrugCode.md)
* [mTLS Signed Object Types](ValueSet-MtlsObjectTypeVS.md)
* [Organization Type VS](ValueSet-OrgTypeVS.md)
* [PDex Adjudication](ValueSet-PDexAdjudication.md)
* [PDex Adjudication Category Discriminator](ValueSet-PDexAdjudicationCategoryDiscriminator.md)
* [PDex Multi-Member Match Result Value Set](ValueSet-PDexMultiMemberMatchResultVS.md)
* [Procedure Codes - AMA CPT - CMS HCPCS - CMS HIPPS](ValueSet-PDexPAInstitutionalProcedureCodes.md)
* [Prior Authorization Procedure Codes - AMA CPT - CMS HCPCS - CMS HIPPS](ValueSet-PDexPAInstitutionalProcedureCodesVS.md)
* [PDex Payer Benefit Payment Status](ValueSet-PDexPayerBenefitPaymentStatus.md)
* [PDex SupportingInfo Type](ValueSet-PDexSupportingInfoType.md)
* [Prior Authorization Service Type Codes (X12)](ValueSet-PriorAuthServiceTypeCodes.md)
* [Prior Authorization value categories](ValueSet-PriorAuthorizationAmounts.md)
* [Provenance Agent Type](ValueSet-ProvenanceAgentType.md)
* [Payer source of data](ValueSet-ProvenancePayerSourceFormat.md)
* [Trust Framework Type Value Set](ValueSet-TrustFrameworkTypeVS.md)
* [X12 278 Review Decision Reason Codes](ValueSet-X12278ReviewDecisionReasonCode.md)
* [X12 Claim Adjustment Reason Codes - Remittance Advice Remark Codes](ValueSet-X12ClaimAdjustmentReasonCodesCMSRemittanceAdviceRemarkCodes.md)
* [Treatment Attestation Provision Type](ValueSet-attestation-provision-type-valueset.md)
* [Treatment Attestation Status](ValueSet-attestation-status-valueset.md)
* [Opt-Out Reason](ValueSet-opt-out-reason-valueset.md)
* [Opt-Out Scope](ValueSet-opt-out-scope-valueset.md)
* [Treatment Relationship Type](ValueSet-treatment-relationship-type-valueset.md)

### Resource Profiles

* [Member Opt-Out Group](StructureDefinition-member-opt-out-group.md)
* [Member-Provider Treatment Relationship Group](StructureDefinition-member-provider-treatment-relationship-group.md)
* [mTLS Endpoint Bundle](StructureDefinition-mtls-bundle.md)
* [mTLS Endpoint](StructureDefinition-mtls-endpoint.md)
* [mTLS Organization](StructureDefinition-mtls-organization.md)
* [PDex Device](StructureDefinition-pdex-device.md)
* [PDex MedicationDispense](StructureDefinition-pdex-medicationdispense.md)
* [PDex Member Match Group](StructureDefinition-pdex-member-match-group.md)
* [PDex Member No Match Group](StructureDefinition-pdex-member-no-match-group.md)
* [PDex $multi-member-match request](StructureDefinition-pdex-parameters-multi-member-match-bundle-in.md)
* [PDex $multi-member-match response](StructureDefinition-pdex-parameters-multi-member-match-bundle-out.md)
* [PDex Prior Authorization](StructureDefinition-pdex-priorauthorization.md)
* [PDex Provenance](StructureDefinition-pdex-provenance.md)
* [PDex Provider Access Consent Profile](StructureDefinition-pdex-provider-consent.md)
* [PDex Provider Group](StructureDefinition-pdex-provider-group.md)
* [Provider Member Match Group](StructureDefinition-provider-member-match-group.md)
* [Provider Member No Match Group](StructureDefinition-provider-member-no-match-group.md)
* [Provider $multi-member-match Request](StructureDefinition-provider-parameters-multi-member-match-bundle-in.md)
* [Provider $multi-member-match Response](StructureDefinition-provider-parameters-multi-member-match-bundle-out.md)
* [Provider Attestation to Treatment Relationship](StructureDefinition-provider-treatment-relationship-consent.md)

### Extensions

* [An attribute to express the refill number of a prescription](StructureDefinition-DispenseRefill.md)
* [An attribute to express the amount of a service or item that has been utilized](StructureDefinition-PriorAuthorizationUtilization.md)
* [An attribute to describe the data source a resource was constructed from](StructureDefinition-ProvenanceSourceFrom.md)
* [NDH Associated Servers](StructureDefinition-base-ext-associatedServers.md)
* [NDH Contactpoint Availabletime](StructureDefinition-base-ext-contactpoint-availabletime.md)
* [NDH Dynamic Registration](StructureDefinition-base-ext-dynamicRegistration.md)
* [NDH Endpoint Rank](StructureDefinition-base-ext-endpoint-rank.md)
* [NDH Endpoint Usecase](StructureDefinition-base-ext-endpoint-usecase.md)
* [NDH Endpoint Access Control Mechanism](StructureDefinition-base-ext-endpointAccessControlMechanism.md)
* [NDH FHIR IG](StructureDefinition-base-ext-fhir-ig.md)
* [NDH Identifier Status](StructureDefinition-base-ext-identifier-status.md)
* [Member Last Transmission](StructureDefinition-base-ext-last-transmission.md)
* [Member Last Resource Filters](StructureDefinition-base-ext-last-typefilter.md)
* [Member Last Resource Types](StructureDefinition-base-ext-last-types.md)
* [Member-Match Input Patient Parameter](StructureDefinition-base-ext-match-parameters.md)
* [Members Opted-out](StructureDefinition-base-ext-members-opted-out.md)
* [NDH Secure Exchange Artifacts](StructureDefinition-base-ext-secureExchangeArtifacts.md)
* [NDH Trust Framework](StructureDefinition-base-ext-trustFramework.md)
* [NDH Verification Status](StructureDefinition-base-ext-verification-status.md)
* [When Adjudicated](StructureDefinition-base-ext-when-adjudicated.md)
* [LevelOfServiceCode](StructureDefinition-extension-levelOfServiceCode.md)
* [ReviewAction](StructureDefinition-extension-reviewAction.md)
* [ReviewActionCode](StructureDefinition-extension-reviewActionCode.md)
* [Opt-Out Details](StructureDefinition-opt-out-details.md)
* [Opt-Out Reason](StructureDefinition-opt-out-reason.md)
* [mTLS Signed Object](StructureDefinition-pdex-mtls-signedobject-extension.md)
* [Treatment Relationship Details](StructureDefinition-treatment-relationship-details.md)

### CapabilityStatements

* [PDex Payer Access Server CapabilityStatement](CapabilityStatement-pdex-payer-access-server.md)
* [PDex Provider Access Server CapabilityStatement](CapabilityStatement-pdex-provider-access-server.md)
* [PDex Server CapabilityStatement with US core 6.1 support](CapabilityStatement-pdex-server-6-1.md)
* [PDEX Server CapabilityStatement](CapabilityStatement-pdex-server.md)

### ImplementationGuides

* [Da Vinci Payer Data Exchange](index.md)

### OperationDefinitions

* [PDex Bulk Member Match Operation](OperationDefinition-BulkMemberMatch.md)
* [Bulk Member Match Data Export](OperationDefinition-BulkMemberMatchDataExport.md)
* [PDex Provider-Member-Match Operation](OperationDefinition-ProviderMemberMatch.md)

### SearchParameters

* [ExplanationOfBenefit_Identifier](SearchParameter-explanationofbenefit-identifier.md)
* [ExplanationOfBenefit_Patient](SearchParameter-explanationofbenefit-patient.md)
* [ExplanationOfBenefit_ServiceDate](SearchParameter-explanationofbenefit-service-date.md)
* [ExplanationOfBenefit_Type](SearchParameter-explanationofbenefit-type.md)
* [ExplanationOfBenefit_Use](SearchParameter-explanationofbenefit-use.md)
* [Group_Code](SearchParameter-group-code.md)
* [PdexMedicationDispensePatient](SearchParameter-pdex-medicationdispense-patient.md)
* [PdexMedicationDispenseStatus](SearchParameter-pdex-medicationdispense-status.md)

### Examples

* [1000000-1 (Bundle)](Bundle-1000000-1.md)
* [1000000-2 (Bundle)](Bundle-1000000-2.md)
* [1000000-3 (Bundle)](Bundle-1000000-3.md)
* [2000002 (Bundle)](Bundle-2000002.md)
* [3000002 (Bundle)](Bundle-3000002.md)
* [3000003 (Bundle)](Bundle-3000003.md)
* [example-mtls-endpoint-bundle (Bundle)](Bundle-example-mtls-endpoint-bundle.md)
* [consent-2 (Consent)](Consent-consent-2.md)
* [no-consent-1 (Consent)](Consent-no-consent-1.md)
* [provider-treatment-attestation-1 (Consent)](Consent-provider-treatment-attestation-1.md)
* [treatment-attestation-ex1 (Consent)](Consent-treatment-attestation-ex1.md)
* [treatment-attestation-ex2 (Consent)](Consent-treatment-attestation-ex2.md)
* [883210 (Coverage)](Coverage-883210.md)
* [Coverage1 (Coverage)](Coverage-Coverage1.md)
* [CoverageLinkExample1 (Coverage)](Coverage-CoverageLinkExample1.md)
* [CoverageMatchExample1 (Coverage)](Coverage-CoverageMatchExample1.md)
* [CoverageMatchExample2 (Coverage)](Coverage-CoverageMatchExample2.md)
* [coverage-2 (Coverage)](Coverage-coverage-2.md)
* [coverage-link-2 (Coverage)](Coverage-coverage-link-2.md)
* [543210 (Device)](Device-543210.md)
* [123456 (DocumentReference)](DocumentReference-123456.md)
* [provider-attestation-doc-1 (DocumentReference)](DocumentReference-provider-attestation-doc-1.md)
* [6 (Encounter)](Encounter-6.md)
* [7 (Encounter)](Encounter-7.md)
* [8 (Encounter)](Encounter-8.md)
* [Payer-Payer Exchange (Endpoint)](Endpoint-diamond-mtls-endpoint1.md)
* [Payer-Payer Exchange (Endpoint)](Endpoint-diamond-mtls-endpoint2.md)
* [PDexPriorAuth1 (ExplanationOfBenefit)](ExplanationOfBenefit-PDexPriorAuth1.md)
* [Matched Members (Group)](Group-07e72a15407547bf9d03f522aa536a72.1.md)
* [Attributed List of Health Plan Members for Practitioner 1122334455. (Group)](Group-Example-PDex-Provider-Group.md)
* [example-pdex-member-consent-constraint-group (Group)](Group-example-pdex-member-consent-constraint-group.md)
* [example-pdex-member-no-match-group (Group)](Group-example-pdex-member-no-match-group.md)
* [MyFavorite Pharmacy (Location)](Location-5.md)
* [1000001 (MedicationDispense)](MedicationDispense-1000001.md)
* [Acme of CT (Organization)](Organization-Acme.md)
* [DiamondOnyxHealth (Organization)](Organization-DiamondOnyxHealth1.md)
* [Payer 1 (Organization)](Organization-Payer1-1.md)
* [Payer 1 (Organization)](Organization-Payer1.md)
* [Payer 2 (Organization)](Organization-Payer2-2.md)
* [Payer 2 (Organization)](Organization-Payer2.md)
* [Provider 1 (Organization)](Organization-ProviderOrg1.md)
* [Provider 2 (Organization)](Organization-ProviderOrg2.md)
* [payer-multi-member-match-in (Parameters)](Parameters-payer-multi-member-match-in.md)
* [payer-multi-member-match-out (Parameters)](Parameters-payer-multi-member-match-out.md)
* [provider-bulk-member-match-in (Parameters)](Parameters-provider-bulk-member-match-in.md)
* [provider-bulk-member-match-out (Parameters)](Parameters-provider-bulk-member-match-out.md)
* [provider-member-match-request-001 (Parameters)](Parameters-provider-member-match-request-001.md)
* [provider-member-match-response-001 (Parameters)](Parameters-provider-member-match-response-001.md)
* [1-2 (Patient)](Patient-1-2.md)
* [1 (Patient)](Patient-1.md)
* [100 (Patient)](Patient-100.md)
* [1001 (Patient)](Patient-1001.md)
* [2002 (Patient)](Patient-2002.md)
* [PatientMemberMatchExample1 (Patient)](Patient-PatientMemberMatchExample1.md)
* [PatientMemberMatchExample2 (Patient)](Patient-PatientMemberMatchExample2.md)
* [patient-2 (Patient)](Patient-patient-2.md)
* [payer-patient-1001 (Patient)](Patient-payer-patient-1001.md)
* [payer-patient-2002 (Patient)](Patient-payer-patient-2002.md)
* [4 (Practitioner)](Practitioner-4.md)
* [1000001 (Provenance)](Provenance-1000001.md)
* [1000002 (Provenance)](Provenance-1000002.md)
* [1000003 (Provenance)](Provenance-1000003.md)
* [1000004 (Provenance)](Provenance-1000004.md)
* [1000005 (Provenance)](Provenance-1000005.md)
* [1000006 (Provenance)](Provenance-1000006.md)
* [1000016 (Provenance)](Provenance-1000016.md)
* [1000017 (Provenance)](Provenance-1000017.md)
* [1000101 (Provenance)](Provenance-1000101.md)
