# Home - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/davinci-pdex/ImplementationGuide/hl7.fhir.us.davinci-pdex | *Version*:2.1.1 | |
| *IG Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:DaVinciPayerDataExchange |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

***This page has been updated to reflect the release of the CMS Prior Authorization Rule (CMS-0057) in 2024. The guide has also been updated to support the adoption of US Core 6.1.0, in addition to existing support for US Core 3.1.1 and support for US Core 7.0.0. This change is implemented to enable implementers to comply with both the CMS-0057 Rule and the ONC's HTI-1 rule that implements US Core 6.1.0 as the base standard of US Core as of January 1, 2026.***

# In this PDex version

The PDex work group has made changes to the original version of the IG following the publication of the final CMS Interoperability and Patient Access Rule (CMS-9115) and the subsequent Advancing Interoperability and Improving Prior Authorization Rule (CMS-0057).

The STU 2.1 version of the IG incorporates changes to support the sharing of Prior Authorization information with members, providers and other payers. This is done through the profiling of the [ExplanationOfBenefit](PDexPriorAuthorization.md) resource. This version of the Implementation guide also introduces two Bulk APIs that enable the data available through the Patient Access API to also be made available to In-Network/Contracted Providers and other Health Plans through the [Provider Access API](provider-access-api.md) and the [Payer-to-Payer Bulk API](payertopayerbulkexchange.md).

CMS Guidance defines two sets of data to be made available by payers in the Patient Access API: Claims and Encounter Data and Clinical data. They provide links to specific implementations guides for the Patient Access API to provide guidance. Use of these implementation guides is not required but is recommended. If used these guides will provide information payers can employ to meet the requirements of the policies being finalized. The [CARIN Consumer Directed Payer Data Exchange IG (CARIN IG for Blue Button®)]() defines how Claims and Encounter Data are to be provided; This Da Vinci Payer Data Exchange IG (PDex) and the [US Core 3.1.1 IG](http://hl7.org/fhir/us/core/3.1.1), [US Core 6.1.0 IG](http://hl7.org/fhir/us/core/STU6.1) or [US Core 7.0.0 IG](http://hl7.org/fhir/us/core/STU7) define how Clinical Data is to be provided.

This version of the Implementation Guide introduces support for [US Core 7.0.0 IG](http://hl7.org/fhir/us/core/STU7). Since the IG embraces US Core the support for [US Core 7.0.0](http://hl7.org/fhir/us/core/STU7) is similar to the support for [US Core 6.1.0](http://hl7.org/fhir/us/core/STU6.1) which required minimal changes to the PDex IG. Throughout this IG references to [US Core 6.1.0](http://hl7.org/fhir/us/core/STU6.1) can also be interpreted as supporting [US Core 7.0.0](http://hl7.org/fhir/us/core/STU7) which is expected to supercede [US Core 6.1.0](http://hl7.org/fhir/us/core/STU6.1) in 2028.

### Continuing Standards Evolution

This IG recognizes that the healthcare industry is rapidly evolving methods, such as TEFCA, to enable the secure exchange of information between Providers and Payers and between payers. Incorporating prescriptive definitions for connecting, registering and authorizing access to the Provider Access or Payer-to-Payer API risks complicating the adoption of solutions that will enable secure exchange of data, at scale. Health Plans implementing the Da Vinci guides that address the CMS Prior Authorization Rule (Payer Data Exchange, Coverage Requirements Discovery, Documents templates and Rules and Prior Authorization Support) are urged to continue to engage with their respective work groups in order to be aware of ongoing developments and emergent implementation approaches, as the industry works to evolve methods that will enable adoption of these Interoperability Standards at scale. Developments are to be expected in the area of automated registration and access to the secure APIs documented in these IGs.

### Background

There are two parallel paths pursued by the CARIN Alliance (**C**reating **A**ccess to **R**eal-time **In**formation) and the Da Vinci Project related to providing health plan data to various stakeholders. CARIN Alliance approaches the issue primarily from a financial (claims) perspective, with some limited associated clinical data. The Da Vinci Project approaches the issue primarily from a clinical perspective and leaves financial data out of scope.

The CARIN Alliance focused on replicating the CMS Blue Button 2.0 solution directed at providing beneficiaries access to claims information for Medicare Fee For Service (FFS) in the form of a FHIR based ExplanationOfBenefit (EOB). The CARIN Alliance Consumer-Directed Payer Data Exchange (CARIN IG for Blue Button®) solution was intended to provide the same information based on commercial payer databases, at least for Medicare Advantage products. The CMS Interoperability and Patient Access Final Rule expanded the scope of a Blue Button 2.0 equivalent to include not just Medicare Advantage but also Medicaid HMO, CHIP HMO and QHP's in the federal marketplace.

The Da Vinci Payer Data Exchange (PDex) solution started with the goal of providing payer sourced information to providers in the form of FHIR resources consistent with US Core profiles for FHIR Release 4 (R4). The CMS Interoperability Final Rule directs covered payers (as noted above) to make Encounter and Clinical data available to members through an API (defined by the ONC 21st Century Cures Act Final Rule) for, at a minimum, information defined in USCDI release 1.1. Since PDex was already focused on making the same information available through a compliant API, Da Vinci expanded the scope of PDex to include not only payer to provider exchange at the request of the provider but also payer to third party application exchange at the request of the member.

In addition, the CMS Interoperability Final Rule requires a covered plan, at the member’s request, to make their information (as defined by USCDI release 1.1), at a minimum available to any other plan as directed by the member. This ability must exist for up to 5 years after the member leaves the plan. Da Vinci expanded the scope of the PDex Implementation Guide to support this exchange. This aspect of the CMS-9115 Interoperability and Patient Access Rule was never enforced. However, in the following Prior Authorization Rule (CMS-0057) CMS requires Payers to enable Payers to perform a Payer-to-Payer exchange of data for opted-in and matched members that have moved to a new plan from a regulated health plan.

At this point we have two solutions that provide an overlapping but different set of information for the members of a health plan. The first is the CARIN IG for Blue Button® which is focused on providing claims information, including the adjudication information, in the form of a FHIR ExplanationOfBenefit (EOB). The second solution is to provide all payer information related to the clinical condition and care of the patient using US Core profiles on FHIR R4 resources. In the latter case, USCDI information coming from claims is represented as US Core resources and includes, at a minimum: encounters, providers, organizations, locations, dates of service, diagnoses (conditions), procedures and observations. This information would also include clinical information from sources other than claims maintained by the payer, such as:

1. Laboratory results received via HL7 V2 ORU transactions,
1. Clinical data from HL7 consolidated CDAs,
1. Information derived from HL7 V2 ADT transactions,
1. Information received or extracted from immunization registries,
1. Information related to medication administration from pharmacy benefit managers in pharmacy networks,
1. FHIR resources, and any other source of clinical information related to the member.

Unlike the [US Core 3.1.1 IG](http://hl7.org/fhir/us/core/3.1.1) or [US Core 6.1.0 IG](http://hl7.org/fhir/us/core/STU6.1), PDex provides guidance to payers on how to make the following information available via the Patient Access API:

1. Provenance appropriate for payer data exchange (extended US Core Provenance)
1. Dispensed medications (not covered in[US Core 3.1.1](http://hl7.org/fhir/us/core/3.1.1))
1. Medical devices that are not implantable devices (not covered in US Core)
1. Common Payer Consumer Data Set (CPCDS) to US Core and PDex profiles to satisfy the requirement for exchange of USCDI V1 information
1. Clinical data received by payers (e.g., laboratory results) from multiple sources (e.g., claims, HL7 V2, CDA) to the appropriate FHIR US Core and PDex profile data elements.

| |
| :--- |
| ![](Payer-Admin-Financial-Clinical-Data-interchange.png) |

This IG uses the same Member Health History "payload" for member-authorized exchange of information with other Health Plans, in network providers and with Third-Party Applications. It describes the interaction patterns that, when followed, allow the various parties involved in managing healthcare and payer data to more easily integrate and exchange data securely and effectively.

This IG covers the exchange of:

* Claims-based information via clinical FHIR profiles, namely US Core plus payer-specific profiles for Device and MedicationDispense
* Clinical Information (such as Lab Results, Allergies and Conditions)

In support of the Prior Authorization Rule (CMS-0057) This IG adds support for Prior Authorizations and the supporting clinical information used in reaching a decision. This information iis added to the Patient Access API and is also available to In-Network Providers and other Payers through the Provider Access and Payer-to-Payer Bulk APIs.

This IG covers the exchange of this information using US Core and Da Vinci Health Record Exchange (HRex) Profiles. This superset of clinical profiles forms the Health Plan Member's Health History.

This IG covers the exchange of a Member's Health History in the following scenarios:

* Provider requested Provider-Health Plan Exchange using CDS-Hooks and SMART-on-FHIR
* Member-authorized Health Plan to Health Plan exchange
* Member-authorized Health Plan to Third-Party Application exchange

The latter two scenarios are provided to meet the requirements identified in the CMS Interoperability Notice for Proposed Rule Making issued on February 11, 2019. To meet the requirements of the CMS Prior Authorization Rule this IG adds two new APIs:

* [Provider Access Bulk API](provider-access-api.md)
* [Payer-to-Payer Bulk API](payertopayerbulkexchange.md)

**There are items in this guide that are subject to update**. This includes:

* Value Sets
* Code Systems
* Examples.

See the [Table of Contents](toc.md) for more information.

### Mapping Adjudicated Claims, Encounter and Prior Authorization Information

The [Data Mapping](datamapping.md) section addresses the mapping of Claims and Encounter data to Clinical profiles. Some US Core profiles correlate with data provided in the [Consumer-Directed Payer Data Exchange (Blue Button 2.0) IG](). The Data Mapping section provides tables to assist implementers in mapping between these IGs.

With the CMS Prior Authorization Rule (CMS-0057) recommending the series of Da Vinci Burden Reduction Implementation Guides (Coverage Requirements Discovery, Documents Templates and Rules and Prior Authorization Support) it is expected that Payers will receive more clinical data from Providers. Much of that data will be in structured form, as defined by the US Core Implementation Guide. The Payer-to-Payer Bulk API also requires the exchange of unstructured data that supports a Prior Authorization decision. Such data would be embedded in a DocumentReference resource for exchange. This is likely to result in Payers having far more clinical data to exchange wih Members, Providers and other Payers.

The IG will continue to be tested at connectathons and will continue to utilize commonly adopted standards (e.g., US Core profiles) that have been tested by other groups (e.g., Argonaut). USCDI concepts are encapsulated in US Core Profiles on FHIR Resources. The Code Systems, Value Sets and codings used in this IG are based on US Core Profiles. Regardless of the way in which payers store their administrative and clinical information they will need to map it appropriately to these profiles.

In addition, we are creating a supplemental guide to provide more examples of how to populate the resources that are being exchanged based on the nature of the source information (e.g., lab results via V2 transactions, CDA, or claims).

### Endpoint Discovery

Implementers of this IG **SHOULD** support the [endpoint discovery](http://hl7.org/fhir/us/davinci-hrex/STU1.1/endpoint-discovery.html) mechanism defined in the HRex specification to allow discovery of the endpoints used in this IG - specifically the following:

* Patient Access API.
* Provider Access API.
* Payer-to-Payer API (single member and multiple members).

### Intellectual Property Considerations

This HL7 specification contains and references intellectual property owned by third parties ("Third Party IP"). Implementers and testers of this specification **SHALL** abide by the license requirements for each terminology content artifact utilized within a functioning implementation. Terminology licenses **SHALL** be obtained from the Third-Party IP owner for each code system and/or other specified artifact used. It is the sole responsibility of each organization deploying or testing this specification to ensure their implementations comply with licensing requirements of each Third-Party IP.

This publication includes IP covered under the following statements.

* All X12 products are subject to this IP policy, including published and draft works.X12 is the only organization authorized to grant permission for use of X12 products. Users of all X12 products should make sure that they understand the permissible uses, as well as the limitations on such usage, as outlined below.Additional IP information can be found [here](https://x12.org/products/ip-use) Send an email to ip@x12.org to request permission to reproduce X12 IP. Include your name, organization, title, address, city, state, zip, email, a detailed description of the Submitted Artifact, including the underlying or cited X12 Product, and a detailed description of the intended audience and planned distribution method for the Artifact.Additional information on X12 licensing program can be found [here](https://x12.org/products/licensing-program) To purchase code list subscriptions call (425) 562-2245 or email admin@wpc-edi.com.

* [X12 Claim Adjustment Reason Codes](http://terminology.hl7.org/6.3.0/CodeSystem-X12ClaimAdjustmentReasonCodes.html): [PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md) and [X12ClaimAdjustmentReasonCodesCMSRemittanceAdviceRemarkCodes](ValueSet-X12ClaimAdjustmentReasonCodesCMSRemittanceAdviceRemarkCodes.md)


* All X12 work products are copyrighted. Any use of any X12 work product must be compliant with US Copyright laws and X12 Intellectual Property policies.Please see [[https://x12.org/products/licensing-program](https://x12.org/products/licensing-program)](https://x12.org/products/licensing-program) 

* [X12 Service Type Codes](http://terminology.hl7.org/6.3.0/CodeSystem-X12ServiceTypeCodes.html): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md), [PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md) and [PriorAuthServiceTypeCodes](ValueSet-PriorAuthServiceTypeCodes.md)


* CMS maintains HIPPS. There are no known constraints on the use of HIPPS.

* [Health Insurance Prospective Payment System (HIPPS)](http://terminology.hl7.org/6.3.0/CodeSystem-HIPPS.html): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md), [PDexPAInstitutionalProcedureCodes](ValueSet-PDexPAInstitutionalProcedureCodes.md), [PDexPAInstitutionalProcedureCodesVS](ValueSet-PDexPAInstitutionalProcedureCodesVS.md) and [PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.3.0/CodeSystem-ISO3166Part1.html): [AssociatedServers](StructureDefinition-base-ext-associatedServers.md), [AttestationProvisionTypeValueSet](ValueSet-attestation-provision-type-valueset.md)...Show 102 more,[AttestationStatusValueSet](ValueSet-attestation-status-valueset.md),[BulkMemberMatch](OperationDefinition-BulkMemberMatch.md),[BulkMemberMatchDataExport](OperationDefinition-BulkMemberMatchDataExport.md),[ContactPointAvailableTime](StructureDefinition-base-ext-contactpoint-availabletime.md),[DaVinciPayerDataExchange](index.md),[DispenseRefill](StructureDefinition-DispenseRefill.md),[DynamicRegistration](StructureDefinition-base-ext-dynamicRegistration.md),[EndpointAccessControlMechanism](StructureDefinition-base-ext-endpointAccessControlMechanism.md),[EndpointPayloadTypeCS](CodeSystem-EndpointPayloadTypeCS.md),[EndpointPayloadTypeVS](ValueSet-EndpointPayloadTypeVS.md),[EndpointRank](StructureDefinition-base-ext-endpoint-rank.md),[EndpointUsecase](StructureDefinition-base-ext-endpoint-usecase.md),[ExplanationOfBenefit_Identifier](SearchParameter-explanationofbenefit-identifier.md),[ExplanationOfBenefit_Patient](SearchParameter-explanationofbenefit-patient.md),[ExplanationOfBenefit_ServiceDate](SearchParameter-explanationofbenefit-service-date.md),[ExplanationOfBenefit_Type](SearchParameter-explanationofbenefit-type.md),[ExplanationOfBenefit_Use](SearchParameter-explanationofbenefit-use.md),[FDANationalDrugCode](ValueSet-FDANationalDrugCode.md),[FhirIg](StructureDefinition-base-ext-fhir-ig.md),[Group_Code](SearchParameter-group-code.md),[IdentifierStatus](StructureDefinition-base-ext-identifier-status.md),[LastFilters](StructureDefinition-base-ext-last-typefilter.md),[LastTransmission](StructureDefinition-base-ext-last-transmission.md),[LastTypes](StructureDefinition-base-ext-last-types.md),[LevelOfServiceCode](StructureDefinition-extension-levelOfServiceCode.md),[MatchParameters](StructureDefinition-base-ext-match-parameters.md),[MemberOptOut](StructureDefinition-member-opt-out-group.md),[MemberProviderTreatmentRelationship](StructureDefinition-member-provider-treatment-relationship-group.md),[MembersOptedOut](StructureDefinition-base-ext-members-opted-out.md),[MtlsBundle](StructureDefinition-mtls-bundle.md),[MtlsEndpoint](StructureDefinition-mtls-endpoint.md),[MtlsObjectCodeCS](CodeSystem-MtlsObjectCodeCS.md),[MtlsObjectTypeVS](ValueSet-MtlsObjectTypeVS.md),[MtlsOrganization](StructureDefinition-mtls-organization.md),[MtlsSignedObject](StructureDefinition-pdex-mtls-signedobject-extension.md),[OptOutDetails](StructureDefinition-opt-out-details.md),[OptOutReason](StructureDefinition-opt-out-reason.md),[OptOutReasonCodeSystem](CodeSystem-opt-out-reason.md),[OptOutReasonValueSet](ValueSet-opt-out-reason-valueset.md),[OptOutScopeCodeSystem](CodeSystem-opt-out-scope.md),[OptOutScopeValueSet](ValueSet-opt-out-scope-valueset.md),[OrgTypeCS](CodeSystem-OrgTypeCS.md),[OrgTypeVS](ValueSet-OrgTypeVS.md),[PDexAdjudication](ValueSet-PDexAdjudication.md),[PDexAdjudicationCategoryDiscriminator](ValueSet-PDexAdjudicationCategoryDiscriminator.md),[PDexAdjudicationDiscriminator](CodeSystem-PDexAdjudicationDiscriminator.md),[PDexIdentifierType](CodeSystem-PDexIdentifierType.md),[PDexMemberCharacteristicCode](CodeSystem-pdex-member-characteristic-code.md),[PDexMemberMatchGroup](StructureDefinition-pdex-member-match-group.md),[PDexMemberNoMatchGroup](StructureDefinition-pdex-member-no-match-group.md),[PDexMultiMemberMatchRequestParameters](StructureDefinition-pdex-parameters-multi-member-match-bundle-in.md),[PDexMultiMemberMatchResponseParameters](StructureDefinition-pdex-parameters-multi-member-match-bundle-out.md),[PDexMultiMemberMatchResultVS](ValueSet-PDexMultiMemberMatchResultVS.md),[PDexPAInstitutionalProcedureCodes](ValueSet-PDexPAInstitutionalProcedureCodes.md),[PDexPAInstitutionalProcedureCodesVS](ValueSet-PDexPAInstitutionalProcedureCodesVS.md),[PDexPayerAdjudicationStatus](CodeSystem-PDexPayerAdjudicationStatus.md),[PDexPayerBenefitPaymentStatus](ValueSet-PDexPayerBenefitPaymentStatus.md),[PDexProviderGroup](StructureDefinition-pdex-provider-group.md),[PDexProviderSharingConsent](StructureDefinition-pdex-provider-consent.md),[PDexServerCapabilityStatement61](CapabilityStatement-pdex-server-6-1.md),[PDexSupportingInfoType](ValueSet-PDexSupportingInfoType.md),[PDexSupportingInfoTypeCS](CodeSystem-PDexSupportingInfoTypeCS.md),[PdexDevice](StructureDefinition-pdex-device.md),[PdexMedicationDispense](StructureDefinition-pdex-medicationdispense.md),[PdexMedicationDispensePatient](SearchParameter-pdex-medicationdispense-patient.md),[PdexMedicationDispenseStatus](SearchParameter-pdex-medicationdispense-status.md),[PdexMemberAttributionCS](CodeSystem-PdexMemberAttributionCS.md),[PdexMultiMemberMatchResultCS](CodeSystem-PdexMultiMemberMatchResultCS.md),[PdexPayerAccessServerCapabilityStatement](CapabilityStatement-pdex-payer-access-server.md),[PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md),[PdexProviderAccessServerCapabilityStatement](CapabilityStatement-pdex-provider-access-server.md),[PdexServerCapabilityStatement](CapabilityStatement-pdex-server.md),[PriorAuthServiceTypeCodes](ValueSet-PriorAuthServiceTypeCodes.md),[PriorAuthorizationAmounts](ValueSet-PriorAuthorizationAmounts.md),[PriorAuthorizationUtilization](StructureDefinition-PriorAuthorizationUtilization.md),[PriorAuthorizationValueCodes](CodeSystem-PriorAuthorizationValueCodes.md),[Provenance](StructureDefinition-pdex-provenance.md),[ProvenanceAgentRoleType](CodeSystem-ProvenanceAgentRoleType.md),[ProvenanceAgentType](ValueSet-ProvenanceAgentType.md),[ProvenancePayerDataSource](CodeSystem-ProvenancePayerDataSource.md),[ProvenancePayerSourceFormat](ValueSet-ProvenancePayerSourceFormat.md),[ProvenanceSourceFrom](StructureDefinition-ProvenanceSourceFrom.md),[ProviderMemberMatch](OperationDefinition-ProviderMemberMatch.md),[ProviderMemberMatchGroup](StructureDefinition-provider-member-match-group.md),[ProviderMemberNoMatchGroup](StructureDefinition-provider-member-no-match-group.md),[ProviderMultiMemberMatchRequestParameters](StructureDefinition-provider-parameters-multi-member-match-bundle-in.md),[ProviderMultiMemberMatchResponseParameters](StructureDefinition-provider-parameters-multi-member-match-bundle-out.md),[ProviderTreatmentAttestation](StructureDefinition-provider-treatment-relationship-consent.md),[ReviewAction](StructureDefinition-extension-reviewAction.md),[ReviewActionCode](StructureDefinition-extension-reviewActionCode.md),[SecureExchangeArtifacts](StructureDefinition-base-ext-secureExchangeArtifacts.md),[TreatmentRelationshipDetails](StructureDefinition-treatment-relationship-details.md),[TreatmentRelationshipTypeCodeSystem](CodeSystem-treatment-relationship-type.md),[TreatmentRelationshipTypeValueSet](ValueSet-treatment-relationship-type-valueset.md),[TrustFramework](StructureDefinition-base-ext-trustFramework.md),[TrustFrameworkTypeCS](CodeSystem-TrustFrameworkTypeCS.md),[TrustFrameworkTypeVS](ValueSet-TrustFrameworkTypeVS.md),[TrustProfileCS](CodeSystem-TrustProfileCS.md),[VerificationStatus](StructureDefinition-base-ext-verification-status.md),[WhenAdjudicated](StructureDefinition-base-ext-when-adjudicated.md),[X12278ReviewDecisionReasonCode](ValueSet-X12278ReviewDecisionReasonCode.md)and[X12ClaimAdjustmentReasonCodesCMSRemittanceAdviceRemarkCodes](ValueSet-X12ClaimAdjustmentReasonCodesCMSRemittanceAdviceRemarkCodes.md)


* These codes are excerpted from ASTM Standard, E1762-95(2013) - Standard Guide for Electronic Authentication of Health Care Information, Copyright by ASTM International, 100 Barr Harbor Drive, West Conshohocken, PA 19428. Copies of this standard are available through the ASTM Web Site at www.astm.org.

* [Signature Type Codes](http://hl7.org/fhir/R4/codesystem-signature-type.html): [Bundle/example-mtls-endpoint-bundle](Bundle-example-mtls-endpoint-bundle.md)


* This CodeSystem is not copyrighted.

* [C4BB Adjudication Code System](http://hl7.org/fhir/us/carin-bb/STU2.1/CodeSystem-C4BBAdjudication.html): [PDexAdjudication](ValueSet-PDexAdjudication.md), [PDexAdjudicationCategoryDiscriminator](ValueSet-PDexAdjudicationCategoryDiscriminator.md) and [PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md)
* [PDex Adjudication Discriminator](CodeSystem-PDexAdjudicationDiscriminator.md): [PDexAdjudicationCategoryDiscriminator](ValueSet-PDexAdjudicationCategoryDiscriminator.md) and [PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md)
* [PDex Payer Adjudication Status](CodeSystem-PDexPayerAdjudicationStatus.md): [PDexPayerBenefitPaymentStatus](ValueSet-PDexPayerBenefitPaymentStatus.md)
* [PDex Supporting Info Type](CodeSystem-PDexSupportingInfoTypeCS.md): [PDexSupportingInfoType](ValueSet-PDexSupportingInfoType.md)


* This is an example set based on ASTM Standard, E1762-95 (2013) HL7 RoleClass OID 2.16.840.1.113883.5.110, HL7 Role Code 2.16.840.1.113883.5.111, HL7 ParticipationType OID: 2.16.840.1.113883.5.90, HL7 ParticipationFunction codes at OID: 2.16.840.1.113883.5.88, and HL7 Security and Privacy Domain Analysis Model roles classes.

* [Contract Signer Type Codes](http://terminology.hl7.org/6.3.0/CodeSystem-contractsignertypecodes.html): [Bundle/1000000-1](Bundle-1000000-1.md), [Bundle/1000000-2](Bundle-1000000-2.md), [Bundle/1000000-3](Bundle-1000000-3.md) and [Provenance/1000017](Provenance-1000017.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.3.0/CodeSystem-v3-loinc.html): [Consent/provider-treatment-attestation-1](Consent-provider-treatment-attestation-1.md), [Consent/treatment-attestation-ex1](Consent-treatment-attestation-ex1.md)...Show 6 more,[Consent/treatment-attestation-ex2](Consent-treatment-attestation-ex2.md),[DocumentReference/123456](DocumentReference-123456.md),[DocumentReference/provider-attestation-doc-1](DocumentReference-provider-attestation-doc-1.md),[Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md),[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md)and[ProviderTreatmentAttestation](StructureDefinition-provider-treatment-relationship-consent.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [Bundle/1000000-1](Bundle-1000000-1.md), [Bundle/1000000-2](Bundle-1000000-2.md)...Show 7 more,[Bundle/1000000-3](Bundle-1000000-3.md),[Bundle/3000003](Bundle-3000003.md),[Device/543210](Device-543210.md),[Encounter/6](Encounter-6.md),[Encounter/7](Encounter-7.md),[Encounter/8](Encounter-8.md)and[PdexDevice](StructureDefinition-pdex-device.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Adjudication Value Codes](http://terminology.hl7.org/6.3.0/CodeSystem-adjudication.html): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md), [PDexAdjudication](ValueSet-PDexAdjudication.md) and [PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md)
* [Claim Type Codes](http://terminology.hl7.org/6.3.0/CodeSystem-claim-type.html): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md)
* [Condition Category Codes](http://terminology.hl7.org/6.3.0/CodeSystem-condition-category.html): [Bundle/3000003](Bundle-3000003.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/6.3.0/CodeSystem-condition-clinical.html): [Bundle/3000003](Bundle-3000003.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/6.3.0/CodeSystem-condition-ver-status.html): [Bundle/3000003](Bundle-3000003.md)
* [Consent Action Codes](http://terminology.hl7.org/6.3.0/CodeSystem-consentaction.html): [Consent/consent-2](Consent-consent-2.md), [Consent/no-consent-1](Consent-no-consent-1.md), [PDexProviderSharingConsent](StructureDefinition-pdex-provider-consent.md) and [Parameters/payer-multi-member-match-in](Parameters-payer-multi-member-match-in.md)
* [Consent Category Codes](http://terminology.hl7.org/6.3.0/CodeSystem-consentcategorycodes.html): [Consent/provider-treatment-attestation-1](Consent-provider-treatment-attestation-1.md), [Consent/treatment-attestation-ex1](Consent-treatment-attestation-ex1.md)...Show 5 more,[Consent/treatment-attestation-ex2](Consent-treatment-attestation-ex2.md),[DocumentReference/provider-attestation-doc-1](DocumentReference-provider-attestation-doc-1.md),[Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md),[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md)and[ProviderTreatmentAttestation](StructureDefinition-provider-treatment-relationship-consent.md)
* [Consent PolicyRule Codes](http://terminology.hl7.org/6.3.0/CodeSystem-consentpolicycodes.html): [Consent/no-consent-1](Consent-no-consent-1.md) and [PDexProviderSharingConsent](StructureDefinition-pdex-provider-consent.md)
* [Consent Scope Codes](http://terminology.hl7.org/6.3.0/CodeSystem-consentscope.html): [Consent/consent-2](Consent-consent-2.md), [Consent/no-consent-1](Consent-no-consent-1.md)...Show 8 more,[Consent/provider-treatment-attestation-1](Consent-provider-treatment-attestation-1.md),[Consent/treatment-attestation-ex1](Consent-treatment-attestation-ex1.md),[Consent/treatment-attestation-ex2](Consent-treatment-attestation-ex2.md),[PDexProviderSharingConsent](StructureDefinition-pdex-provider-consent.md),[Parameters/payer-multi-member-match-in](Parameters-payer-multi-member-match-in.md),[Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md),[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md)and[ProviderTreatmentAttestation](StructureDefinition-provider-treatment-relationship-consent.md)
* [Coverage Class Codes](http://terminology.hl7.org/6.3.0/CodeSystem-coverage-class.html): [Coverage/CoverageLinkExample1](Coverage-CoverageLinkExample1.md), [Coverage/CoverageMatchExample1](Coverage-CoverageMatchExample1.md)...Show 5 more,[Coverage/CoverageMatchExample2](Coverage-CoverageMatchExample2.md),[Coverage/coverage-2](Coverage-coverage-2.md),[Parameters/payer-multi-member-match-in](Parameters-payer-multi-member-match-in.md),[Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md)and[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md)
* [DataAbsentReason](http://terminology.hl7.org/6.3.0/CodeSystem-data-absent-reason.html): [Bundle/example-mtls-endpoint-bundle](Bundle-example-mtls-endpoint-bundle.md), [MtlsEndpoint](StructureDefinition-mtls-endpoint.md)...Show 4 more,[PDexPAInstitutionalProcedureCodes](ValueSet-PDexPAInstitutionalProcedureCodes.md),[PDexPAInstitutionalProcedureCodesVS](ValueSet-PDexPAInstitutionalProcedureCodesVS.md),[Payer-Payer Exchange](Endpoint-diamond-mtls-endpoint2.md)and[PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md)
* [Endpoint Connection Type](http://terminology.hl7.org/6.3.0/CodeSystem-endpoint-connection-type.html): [Bundle/example-mtls-endpoint-bundle](Bundle-example-mtls-endpoint-bundle.md), [MtlsEndpoint](StructureDefinition-mtls-endpoint.md) and [Payer-Payer Exchange](Endpoint-diamond-mtls-endpoint2.md)
* [Example Diagnosis Type Codes](http://terminology.hl7.org/6.3.0/CodeSystem-ex-diagnosistype.html): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md)
* [Example Related Claim Relationship Codes](http://terminology.hl7.org/6.3.0/CodeSystem-ex-relatedclaimrelationship.html): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md)
* [Funds Reservation Codes](http://terminology.hl7.org/6.3.0/CodeSystem-fundsreserve.html): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md)
* [Organization type](http://terminology.hl7.org/6.3.0/CodeSystem-organization-type.html): [DiamondOnyxHealth](Organization-DiamondOnyxHealth1.md)
* [Process Priority Codes](http://terminology.hl7.org/6.3.0/CodeSystem-processpriority.html): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md) and [PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md)
* [Professional Credential Status](http://terminology.hl7.org/6.3.0/CodeSystem-professional-credential-status.html): [IdentifierStatus](StructureDefinition-base-ext-identifier-status.md)
* [SubscriberPolicyholder Relationship Codes](http://terminology.hl7.org/6.3.0/CodeSystem-subscriber-relationship.html): [Coverage/883210](Coverage-883210.md), [Coverage/Coverage1](Coverage-Coverage1.md)...Show 8 more,[Coverage/CoverageLinkExample1](Coverage-CoverageLinkExample1.md),[Coverage/CoverageMatchExample1](Coverage-CoverageMatchExample1.md),[Coverage/CoverageMatchExample2](Coverage-CoverageMatchExample2.md),[Coverage/coverage-2](Coverage-coverage-2.md),[Coverage/coverage-link-2](Coverage-coverage-link-2.md),[Parameters/payer-multi-member-match-in](Parameters-payer-multi-member-match-in.md),[Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md)and[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md)
* [identifierType](http://terminology.hl7.org/6.3.0/CodeSystem-v2-0203.html): [Bundle/1000000-1](Bundle-1000000-1.md), [Bundle/1000000-2](Bundle-1000000-2.md)...Show 28 more,[Bundle/1000000-3](Bundle-1000000-3.md),[Coverage/883210](Coverage-883210.md),[Coverage/Coverage1](Coverage-Coverage1.md),[Coverage/coverage-2](Coverage-coverage-2.md),[Coverage/coverage-link-2](Coverage-coverage-link-2.md),[Group/example-pdex-member-consent-constraint-group](Group-example-pdex-member-consent-constraint-group.md),[Group/example-pdex-member-no-match-group](Group-example-pdex-member-no-match-group.md),[Matched Members](Group-07e72a15407547bf9d03f522aa536a72.1.md),[Parameters/payer-multi-member-match-in](Parameters-payer-multi-member-match-in.md),[Parameters/payer-multi-member-match-out](Parameters-payer-multi-member-match-out.md),[Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md),[Parameters/provider-bulk-member-match-out](Parameters-provider-bulk-member-match-out.md),[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md),[Patient/1](Patient-1.md),[Patient/1-2](Patient-1-2.md),[Patient/100](Patient-100.md),[Patient/1001](Patient-1001.md),[Patient/2002](Patient-2002.md),[Patient/PatientMemberMatchExample1](Patient-PatientMemberMatchExample1.md),[Patient/PatientMemberMatchExample2](Patient-PatientMemberMatchExample2.md),[Patient/patient-2](Patient-patient-2.md),[Patient/payer-patient-1001](Patient-payer-patient-1001.md),[Patient/payer-patient-2002](Patient-payer-patient-2002.md),[Payer 1](Organization-Payer1.md),[Payer 2](Organization-Payer2.md),[Practitioner/4](Practitioner-4.md),[Provider 1](Organization-ProviderOrg1.md)and[Provider 2](Organization-ProviderOrg2.md)
* [ActCode](http://terminology.hl7.org/6.3.0/CodeSystem-v3-ActCode.html): [Bundle/1000000-1](Bundle-1000000-1.md), [Bundle/1000000-2](Bundle-1000000-2.md)...Show 16 more,[Bundle/1000000-3](Bundle-1000000-3.md),[Bundle/2000002](Bundle-2000002.md),[Bundle/3000002](Bundle-3000002.md),[Consent/consent-2](Consent-consent-2.md),[Consent/no-consent-1](Consent-no-consent-1.md),[Coverage/CoverageLinkExample1](Coverage-CoverageLinkExample1.md),[Coverage/CoverageMatchExample1](Coverage-CoverageMatchExample1.md),[Coverage/CoverageMatchExample2](Coverage-CoverageMatchExample2.md),[Encounter/6](Encounter-6.md),[Encounter/7](Encounter-7.md),[Encounter/8](Encounter-8.md),[MedicationDispense/1000001](MedicationDispense-1000001.md),[PDexProviderSharingConsent](StructureDefinition-pdex-provider-consent.md),[Parameters/payer-multi-member-match-in](Parameters-payer-multi-member-match-in.md),[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md)and[PdexMedicationDispense](StructureDefinition-pdex-medicationdispense.md)
* [ActReason](http://terminology.hl7.org/6.3.0/CodeSystem-v3-ActReason.html): [Consent/provider-treatment-attestation-1](Consent-provider-treatment-attestation-1.md), [Consent/treatment-attestation-ex1](Consent-treatment-attestation-ex1.md)...Show 5 more,[Consent/treatment-attestation-ex2](Consent-treatment-attestation-ex2.md),[Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md),[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md),[Provenance/1000101](Provenance-1000101.md)and[ProviderTreatmentAttestation](StructureDefinition-provider-treatment-relationship-consent.md)
* [DataOperation](http://terminology.hl7.org/6.3.0/CodeSystem-v3-DataOperation.html): [Provenance/1000101](Provenance-1000101.md)
* [NullFlavor](http://terminology.hl7.org/6.3.0/CodeSystem-v3-NullFlavor.html): [Bundle/1000000-1](Bundle-1000000-1.md), [Bundle/1000000-2](Bundle-1000000-2.md)...Show 4 more,[Bundle/1000000-3](Bundle-1000000-3.md),[Patient/1](Patient-1.md),[Patient/1-2](Patient-1-2.md)and[Patient/100](Patient-100.md)
* [ParticipationType](http://terminology.hl7.org/6.3.0/CodeSystem-v3-ParticipationType.html): [Consent/consent-2](Consent-consent-2.md), [Consent/provider-treatment-attestation-1](Consent-provider-treatment-attestation-1.md)...Show 5 more,[Consent/treatment-attestation-ex1](Consent-treatment-attestation-ex1.md),[Consent/treatment-attestation-ex2](Consent-treatment-attestation-ex2.md),[Parameters/payer-multi-member-match-in](Parameters-payer-multi-member-match-in.md),[Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md)and[Parameters/provider-member-match-request-001](Parameters-provider-member-match-request-001.md)
* [RoleClass](http://terminology.hl7.org/6.3.0/CodeSystem-v3-RoleClass.html): [Consent/provider-treatment-attestation-1](Consent-provider-treatment-attestation-1.md) and [Parameters/provider-bulk-member-match-in](Parameters-provider-bulk-member-match-in.md)


* Used by permission of HL7 International, all rights reserved Creative Commons License

* [US Core DocumentReferences Category Codes](http://hl7.org/fhir/us/core/STU7/CodeSystem-us-core-documentreference-category.html): [DocumentReference/123456](DocumentReference-123456.md)
* [US Core Provenance Participant Type Extension Codes](http://hl7.org/fhir/us/core/STU7/CodeSystem-us-core-provenance-participant-type.html): [Bundle/1000000-1](Bundle-1000000-1.md), [Bundle/1000000-2](Bundle-1000000-2.md)...Show 8 more,[Bundle/1000000-3](Bundle-1000000-3.md),[Bundle/3000002](Bundle-3000002.md),[Provenance](StructureDefinition-pdex-provenance.md),[Provenance/1000001](Provenance-1000001.md),[Provenance/1000016](Provenance-1000016.md),[Provenance/1000017](Provenance-1000017.md),[Provenance/1000101](Provenance-1000101.md)and[ProvenanceAgentType](ValueSet-ProvenanceAgentType.md)
* [Endpoint Payload Types Code System](CodeSystem-EndpointPayloadTypeCS.md): [EndpointPayloadTypeVS](ValueSet-EndpointPayloadTypeVS.md)
* [mTLS Object Type Code](CodeSystem-MtlsObjectCodeCS.md): [MtlsObjectTypeVS](ValueSet-MtlsObjectTypeVS.md), [MtlsSignedObject](StructureDefinition-pdex-mtls-signedobject-extension.md) and [Payer-Payer Exchange](Endpoint-diamond-mtls-endpoint2.md)
* [Organization Type](CodeSystem-OrgTypeCS.md): [Acme of CT](Organization-Acme.md) and [OrgTypeVS](ValueSet-OrgTypeVS.md)
* [PDex Provider Access API Attribution Code System](CodeSystem-PdexMemberAttributionCS.md): [Attributed List of Health Plan Members for Practitioner 1122334455.](Group-Example-PDex-Provider-Group.md), [MemberOptOut](StructureDefinition-member-opt-out-group.md)...Show 7 more,[MemberProviderTreatmentRelationship](StructureDefinition-member-provider-treatment-relationship-group.md),[PDexMemberMatchGroup](StructureDefinition-pdex-member-match-group.md),[PDexMemberNoMatchGroup](StructureDefinition-pdex-member-no-match-group.md),[PDexMultiMemberMatchResultVS](ValueSet-PDexMultiMemberMatchResultVS.md),[PDexProviderGroup](StructureDefinition-pdex-provider-group.md),[ProviderMemberMatchGroup](StructureDefinition-provider-member-match-group.md)and[ProviderMemberNoMatchGroup](StructureDefinition-provider-member-no-match-group.md)
* [PDex Multi-Member Match Result Code System](CodeSystem-PdexMultiMemberMatchResultCS.md): [Group/example-pdex-member-consent-constraint-group](Group-example-pdex-member-consent-constraint-group.md), [Group/example-pdex-member-no-match-group](Group-example-pdex-member-no-match-group.md)...Show 11 more,[Matched Members](Group-07e72a15407547bf9d03f522aa536a72.1.md),[MemberOptOut](StructureDefinition-member-opt-out-group.md),[MemberProviderTreatmentRelationship](StructureDefinition-member-provider-treatment-relationship-group.md),[PDexMemberMatchGroup](StructureDefinition-pdex-member-match-group.md),[PDexMemberNoMatchGroup](StructureDefinition-pdex-member-no-match-group.md),[PDexMultiMemberMatchResultVS](ValueSet-PDexMultiMemberMatchResultVS.md),[PDexProviderGroup](StructureDefinition-pdex-provider-group.md),[Parameters/payer-multi-member-match-out](Parameters-payer-multi-member-match-out.md),[Parameters/provider-bulk-member-match-out](Parameters-provider-bulk-member-match-out.md),[ProviderMemberMatchGroup](StructureDefinition-provider-member-match-group.md)and[ProviderMemberNoMatchGroup](StructureDefinition-provider-member-no-match-group.md)
* [Prior Authorization Values](CodeSystem-PriorAuthorizationValueCodes.md): [ExplanationOfBenefit/PDexPriorAuth1](ExplanationOfBenefit-PDexPriorAuth1.md), [PdexPriorAuthorization](StructureDefinition-pdex-priorauthorization.md) and [PriorAuthorizationAmounts](ValueSet-PriorAuthorizationAmounts.md)
* [Provenance Roles](CodeSystem-ProvenanceAgentRoleType.md): [Provenance](StructureDefinition-pdex-provenance.md) and [ProvenanceAgentType](ValueSet-ProvenanceAgentType.md)
* [Provenance Payer Data Source Format](CodeSystem-ProvenancePayerDataSource.md): [Bundle/1000000-1](Bundle-1000000-1.md), [Bundle/1000000-2](Bundle-1000000-2.md)...Show 13 more,[Bundle/1000000-3](Bundle-1000000-3.md),[Bundle/3000002](Bundle-3000002.md),[Bundle/3000003](Bundle-3000003.md),[Provenance](StructureDefinition-pdex-provenance.md),[Provenance/1000001](Provenance-1000001.md),[Provenance/1000002](Provenance-1000002.md),[Provenance/1000003](Provenance-1000003.md),[Provenance/1000004](Provenance-1000004.md),[Provenance/1000005](Provenance-1000005.md),[Provenance/1000006](Provenance-1000006.md),[Provenance/1000016](Provenance-1000016.md),[ProvenancePayerSourceFormat](ValueSet-ProvenancePayerSourceFormat.md)and[ProvenanceSourceFrom](StructureDefinition-ProvenanceSourceFrom.md)
* [Trust FrameworkType Code System](CodeSystem-TrustFrameworkTypeCS.md): [TrustFramework](StructureDefinition-base-ext-trustFramework.md) and [TrustFrameworkTypeVS](ValueSet-TrustFrameworkTypeVS.md)
* [Opt-Out Reason](CodeSystem-opt-out-reason.md): [OptOutReason](StructureDefinition-opt-out-reason.md) and [OptOutReasonValueSet](ValueSet-opt-out-reason-valueset.md)
* [Opt-Out Scope](CodeSystem-opt-out-scope.md): [MemberOptOut](StructureDefinition-member-opt-out-group.md) and [OptOutScopeValueSet](ValueSet-opt-out-scope-valueset.md)
* [Treatment Relationship Type](CodeSystem-treatment-relationship-type.md): [TreatmentRelationshipTypeValueSet](ValueSet-treatment-relationship-type-valueset.md)


### Conventions

This implementation guide (IG) uses specific terminology to flag statements that have relevance for the evaluation of conformance with the guide:

**SHALL** indicates requirements that must be met to be conformant with the specification.

**SHOULD** indicates behaviors that are strongly recommended (and which may result in interoperability issues or sub-optimal behavior if not adhered to) but which do not, for this version of the specification, affect the determination of specification conformance.

**MAY** describes optional behaviors that are free to consider but where there is no recommendation for, or against, adoption.

#### MustSupport

For profiles defined in other IGs, the meaning of Must Support is established in the defining IG. Note that the Must Support requirements for this IG are modeled after the US Core Implementation Guide. For further information see the [Must Support](introduction.md#mustsupport) section in the Introduction page.

#### Security and Privacy

Security and Privacy are critically important when exchanging information. Please refer to the [Security and Privacy](securityandprivacy.md) page in this IG and the guidance it references in the [Health Record Exchange (HRex) IG](http://hl7.org/fhir/us/davinci-hrex/STU1.1/security.html).

#### Patient/Subject Terminology

It is important to differentiate in the Implementation Guide between identifiers used by the Provider/EMR and those used by the Payer/Health Plan to identify the patient/subject/member.

For the purposes of this IG we will use the following terms:

* **patient** or **subject** id will be used to express the identifier used by the provider to identify a patient/subject.
* **member** id will be used to express the identifier used by the payer/health plan to identify an individual member. Health Plans may historically have referred to these individual members as:

### Dependencies

| | | |
| :--- | :--- | :--- |
| [Bulk Data Access IG](http://hl7.org/fhir/uv/bulkdata/STU2) | [2.0.0](https://simplifier.net/packages/hl7.fhir.uv.bulkdata/2.0.0) | Imported by Da Vinci - Member Attribution (ATR) List (and potentially others) |
| [CARIN Consumer Directed Payer Data Exchange (CARIN IG for Blue Button®)](http://hl7.org/fhir/us/carin-bb/STU2.1) | [2.1.0](https://simplifier.net/packages/hl7.fhir.us.carin-bb/2.1.0) |  |
| [2.0.0](https://simplifier.net/packages/hl7.fhir.us.carin-bb/2.0.0) | Imported by Da Vinci Prior Authorization Support (PAS) FHIR IG (and potentially others) | |
| [Da Vinci - Coverage Requirements Discovery](http://hl7.org/fhir/us/davinci-crd/STU2.1) | [2.1.0](https://simplifier.net/packages/hl7.fhir.us.davinci-crd/2.1.0) |  |
| [2.0.0](https://simplifier.net/packages/hl7.fhir.us.davinci-crd/2.0.0) | Imported by Da Vinci Prior Authorization Support (PAS) FHIR IG (and potentially others) | |
| [Da Vinci - Documentation Templates and Rules](http://hl7.org/fhir/us/davinci-dtr/STU2.1) | [2.1.0](https://simplifier.net/packages/hl7.fhir.us.davinci-dtr/2.1.0) | Imported by Da Vinci Clinical Data Exchange (CDex) (and potentially others) |
| [Da Vinci - Member Attribution (ATR) List](http://hl7.org/fhir/us/davinci-atr/STU2.1) | [2.1.0](https://simplifier.net/packages/hl7.fhir.us.davinci-atr/2.1.0) |  |
| [Da Vinci Clinical Data Exchange (CDex)](http://hl7.org/fhir/us/davinci-cdex/STU2.1) | [2.1.0](https://simplifier.net/packages/hl7.fhir.us.davinci-cdex/2.1.0) | Imported by Da Vinci - Member Attribution (ATR) List (and potentially others) |
| [Da Vinci Health Record Exchange (HRex)](http://hl7.org/fhir/us/davinci-hrex/STU1.1) | [1.1.0](https://simplifier.net/packages/hl7.fhir.us.davinci-hrex/1.1.0) | Defines common conformance rules across all Da Vinci IGs, as well as additional constraints and profiles beyond U.S. Core |
| [1.0.0](https://simplifier.net/packages/hl7.fhir.us.davinci-hrex/1.0.0) | Imported by Da Vinci - Coverage Requirements Discovery (and potentially others) | |
| [Da Vinci PDex Plan Net](http://hl7.org/fhir/us/davinci-pdex-plan-net/STU1.2) | [1.2.0](https://simplifier.net/packages/hl7.fhir.us.davinci-pdex-plan-net/1.2.0) | Imported by Da Vinci - Member Attribution (ATR) List (and potentially others) |
| [Da Vinci Prior Authorization Support (PAS) FHIR IG](http://hl7.org/fhir/us/davinci-pas/STU2.1) | [2.1.0](https://simplifier.net/packages/hl7.fhir.us.davinci-pas/2.1.0) |  |
| [FHIR Extensions Pack](http://hl7.org/fhir/extensions/5.1.0) | [5.2.0](https://simplifier.net/packages/hl7.fhir.uv.extensions.r4/5.2.0) | Imported by CARIN Consumer Directed Payer Data Exchange (CARIN IG for Blue Button®) (and potentially others) |
| [5.1.0](https://simplifier.net/packages/hl7.fhir.uv.extensions.r4/5.1.0) | Imported by Da Vinci Health Record Exchange (HRex) (and potentially others) | |
| [1.0.0](https://simplifier.net/packages/hl7.fhir.uv.extensions.r4/1.0.0) | Imported by Da Vinci - Coverage Requirements Discovery (and potentially others) | |
| [FHIR R4 package : Core](http://hl7.org/fhir/R4) | [4.0.1](https://simplifier.net/packages/hl7.fhir.r4.core/4.0.1) | Imported by US Core (and potentially others) |
| [HL7 Terminology (THO)](http://terminology.hl7.org/5.5.0) | [6.3.0](https://simplifier.net/packages/hl7.terminology.r4/6.3.0) | Defines terminologies and coddesystems used in HIR IGs |
| [6.2.0](https://simplifier.net/packages/hl7.terminology.r4/6.2.0) | Imported by CARIN Consumer Directed Payer Data Exchange (CARIN IG for Blue Button®) (and potentially others) | |
| [6.1.0](https://simplifier.net/packages/hl7.terminology.r4/6.1.0) | Imported by Da Vinci Health Record Exchange (HRex) (and potentially others) | |
| [5.5.0](https://simplifier.net/packages/hl7.terminology.r4/5.5.0) | Imported by US Core (and potentially others) | |
| [5.3.0](https://simplifier.net/packages/hl7.terminology.r4/5.3.0) | Imported by Da Vinci - Coverage Requirements Discovery (and potentially others) | |
| [5.0.0](https://simplifier.net/packages/hl7.terminology.r4/5.0.0) | Imported by Subscriptions R5 Backport (and potentially others) | |
| [4.0.0](https://simplifier.net/packages/hl7.terminology.r4/4.0.0) | Imported by Security for Scalable Registration, Authentication, and Authorization (and potentially others) | |
| [National Directory of Healthcare Providers & Services (NDH)](http://hl7.org/fhir/us/ndh/STU1) | [1.0.0](https://simplifier.net/packages/hl7.fhir.us.ndh/1.0.0) |  |
| [Public Health Information Network Vocabulary Access and Distribution System (PHIN VADS)](http://fhir.org/packages/us.cdc.phinvads) | [0.12.0](https://simplifier.net/packages/us.cdc.phinvads/0.12.0) | Imported by US Core (and potentially others) |
| [SMART App Launch](http://hl7.org/fhir/smart-app-launch/STU2) | [2.1.0](https://simplifier.net/packages/hl7.fhir.uv.smart-app-launch/2.1.0) | Imported by Da Vinci - Member Attribution (ATR) List (and potentially others) |
| [2.0.0](https://simplifier.net/packages/hl7.fhir.uv.smart-app-launch/2.0.0) | Imported by US Core (and potentially others) | |
| [Security for Scalable Registration, Authentication, and Authorization](http://hl7.org/fhir/us/udap-security/2021Sep) | [1.0.0](https://simplifier.net/packages/hl7.fhir.us.udap-security/1.0.0) | Imported by National Directory of Healthcare Providers & Services (NDH) (and potentially others) |
| [0.1.0](https://simplifier.net/packages/hl7.fhir.us.udap-security/0.1.0) | Imported by Da Vinci Health Record Exchange (HRex) (and potentially others) | |
| [Structured Data Capture](http://hl7.org/fhir/uv/sdc/STU3) | [3.0.0](https://simplifier.net/packages/hl7.fhir.uv.sdc/3.0.0) | Imported by US Core (and potentially others) |
| [Subscriptions R5 Backport](http://hl7.org/fhir/uv/subscriptions-backport/STU1.1) | [1.1.0](https://simplifier.net/packages/hl7.fhir.uv.subscriptions-backport.r4/1.1.0) | Imported by Da Vinci Prior Authorization Support (PAS) FHIR IG (and potentially others) |
| [US Core](http://hl7.org/fhir/us/core/STU7) | [7.0.0](https://simplifier.net/packages/hl7.fhir.us.core/7.0.0) | Defines USCDI v4 EHR expectations on a range of resources that will be passed to and/or queried by CRD servers. |
| [6.1.0](https://simplifier.net/packages/hl7.fhir.us.core/6.1.0) | Defines USCDI v3 EHR expectations on a range of resources that will be passed to and/or queried by CRD servers | |
| [3.1.1](https://simplifier.net/packages/hl7.fhir.us.core/3.1.1) | Defines USCDI v1 EHR expectations on a range of resources that will be passed to and/or queried by CRD servers. | |
| [Value Set Authority Center (VSAC)](http://fhir.org/packages/us.nlm.vsac) | [0.7.0](https://simplifier.net/packages/us.nlm.vsac/0.7.0) | Imported by CARIN Consumer Directed Payer Data Exchange (CARIN IG for Blue Button®) (and potentially others) |
| [0.21.0](https://simplifier.net/packages/us.nlm.vsac/0.21.0) | Imported by CARIN Consumer Directed Payer Data Exchange (CARIN IG for Blue Button®) (and potentially others) | |
| [0.19.0](https://simplifier.net/packages/us.nlm.vsac/0.19.0) | Imported by Da Vinci Health Record Exchange (HRex) (and potentially others) | |
| [0.18.0](https://simplifier.net/packages/us.nlm.vsac/0.18.0) | Imported by US Core (and potentially others) | |
| [0.11.0](https://simplifier.net/packages/us.nlm.vsac/0.11.0) | Imported by Da Vinci - Coverage Requirements Discovery (and potentially others) | |

### Change History

A history of changes made since the publication of the STU1 version of the PDex IG is maintained in [ChangeHistory](changehistory.md).

### Project and Participants

See the [Credits](credits.md) page for a list of contributors to the creation and maintenance of this Implementation Guide.

### FHIR Publisher

This IG was built with Sushi and the FHIR Publisher (v1.6.5 or greater).

[Next Page: Overview](overview.md)

