# Credits - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* **Credits**

## Credits

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

[Previous Page - Change Log](changehistory.md)

### Da Vinci

[Da Vinci](https://www.hl7.org/about/davinci/index.cfm) is an HL7-sponsored project that brings together U.S. payers, providers, and technology suppliers to help payers and providers improve clinical, quality, cost, and care management outcomes using FHIR-related technologies. The project organizes meetings (face-to-face and conference calls) and connectathons to find ways to leverage FHIR technologies to support and integrate value-based care (VBC) data exchange across communities. Da Vinci identifies value-based care use cases of interest to its members and to the broader community.

The process that Da Vinci has adopted includes:

1. identifying business, clinical, technical, and testing requirements
1. developing and balloting a FHIR-based implementation guide (IG)
1. developing reference implementations (RIs) to demonstrate that the concepts in the IG are possible to implement
1. piloting the standard
1. supporting the production use of the IG to enable exchange of data to support interoperability for value-based care

All Da Vinci work adheres to a common set of [guiding principles](https://build.fhir.org/ig/HL7/davinci-ehrx/davinci-guiding-principles.html).

Additional information about Da Vinci, its members, the use cases, and the implementation guides being developed can all be found on the [HL7 website](http://www.hl7.org/about/davinci). Meeting minutes and other materials can be found on the [Da Vinci Confluence page](https://confluence.hl7.org/display/DVP).

### The Da Vinci Payer Data Exchange (PDex) project

This Implementation Guide was made possible by the thoughtful contributions of the following people and organizations.

This Implementation Guide was the work of the [Da Vinci Accelerator Project's](http://www.hl7.org/about/davinci/index.cfm?ref=common) PDex work group and Da Vinci member organizations.

The [PDex work group can be found on confluence](https://confluence.hl7.org/pages/viewpage.action?pageId=116462704).

### Credits

**Primary authors:**

* Mark Scrimshire (OnyxHealth.io)

**Project leads:**

* Robert Dieterle (EnableCare, LLC)
* Viet Nguyen (Stratametrics, LLC)

**Project management and coordination:**

* Jocelyn Keegan (Point of Care Partners)
* Vanessa Candelora (Point of Care Partners)
* Crystal Kallum (Point of Care Partners)

**Technical support and guidance:**

* Rick Geimer (Lantana Consulting Group)
* Corey Spears (Lantana Consulting Group)

**Sponsoring Work Group**

This Implementation Guide is supported by the [HL7 Financial Management Work Group](http://www.hl7.org/Special/committees/fm) as the sponsoring work group.

**Project participants included:**

* Blue Cross Blue Shield of Alabama (Tony Benson) - Project Lead PDex STU1
* Aegis (Richard Ettema, Sandra Vance)
* Allscripts (Emma Jones, Jeffrey Danford)
* Blue Cross Blue Shield of Alabama (Tony Benson, Kevin Lambert, Gini McGlothin, Morry Payne, Clarissa Winchester)
* Cerner (Hans Buitendijk, Kevin Shekleton, Michelle Miller)
* Epic (Danielle Friend, Isaac Vetter, Spencer Utley)
* Health Care Data Standards (Mary Kay McDaniel)
* Optum (Linda Michaelsen, Nicholas Radov)
* Onyx Technology, LLC (Mark Scrimshire, Michael Cox, Santhi Chebrolu)

Our thanks to these and to the many others not explicitly listed who contributed their time, enthusiasm and expertise to this work.

### Terminology

This IG defaults to using US Core Profiles and value sets.

If a resource is required that is not part of US Core it will be defined and referenced in the HRex IG. HRex is used to reference profiles that are utilized across multiple Da Vinci IGs.

If a resource is unique to the PDex IG it will be defined in this guide, together with any unique value sets or coding systems required to support the profile.

[Next Page - FHIR Artifacts](artifacts.md)

