# FHIR Artifacts - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* **FHIR Artifacts**

## FHIR Artifacts

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [PDEX Server CapabilityStatement](CapabilityStatement-pdex-server.md) | This Section describes the expected capabilities of the PDex Server actor which supports US Core 3.1.1 and is responsible for providing responses to the queries submitted by PDex Requestors. The complete list of FHIR profiles, RESTful operations, and search parameters supported by PDex Servers for US Core 3.1.1 are defined. PDex Clients have the option of choosing from this list to access necessary data based on their local use cases and other contextual requirements. |
| [PDex Payer-Access Server CapabilityStatement](CapabilityStatement-pdex-payer-access-server.md) | This Section describes the expected capabilities of the PDex Payer-to-Payer API Server actor which supports US Core 3.1.1 or US Core 6.1.0 and is responsible for providing responses to the queries submitted by PDex Payer-to-Payer Requestors. The complete list of FHIR profiles, RESTful operations, and search parameters supported by PDex Payer Access Server for US Core 3.1.1 and US Core 6.1.0 are defined. PDex Payer Access Clients have the option of choosing from this list to access necessary data based on their local use cases and other contextual requirements. |
| [PDex Server CapabilityStatement with US core 6.1 support](CapabilityStatement-pdex-server-6-1.md) | This Section describes the expected capabilities of the PDex with US Core 6.1 Support Server actor which is responsible for providing responses to the queries submitted by the PDex Requestors. The complete list of FHIR profiles, RESTful operations, and search parameters supported by PDex and US Core Servers are defined. Systems implementing this capability statement should meet the ONC 2015 Common Clinical Data Set (CCDS) access requirement for Patient Selection 170.315(g)(7) and Application Access - Data Category Request 170.315(g)(8) and the ONC[U.S. Core Data for Interoperability (USCDI) Version 3 July 2022](https://www.healthit.gov/isa/sites/isa/files/2022-07/USCDI-Version-3-July-2022-Final.pdf). PDex Clients have the option of choosing from this list to access necessary data based on their local use cases and other contextual requirements. |
| [PDex provider-access Server CapabilityStatement](CapabilityStatement-pdex-provider-access-server.md) | This Section describes the expected capabilities of the PDex Payer-to-Payer API Server actor which supports US Core 3.1.1 or US Core 6.1.0 and is responsible for providing responses to the queries submitted by PDex Payer-to-Payer Requestors. The complete list of FHIR profiles, RESTful operations, and search parameters supported by PDex Provider Access Server for US Core 3.1.1 and US Core 6.1.0 are defined. PDex Provider Access Clients have the option of choosing from this list to access necessary data based on their local use cases and other contextual requirements. |

### Behavior: Operation Definitions 

These are custom operations that can be supported by and/or invoked by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Bulk Member Match Data Export](OperationDefinition-BulkMemberMatchDataExport.md) | When invoked on a Group resource returned from the Provider-Member-Match or Payer-to-Payer Bulk Member Match operations, this operation exports all member health data for the members in the Group. The response includes a manifest file with references to ndjson files containing FHIR resources for each member in the group. |
| [PDex Bulk Member Match Operation](OperationDefinition-BulkMemberMatch.md) | Bulk Member Match Operation enables Payers to match multiple members against another Payer's records for bulk data exchange. The operation returns Group resources containing matched, non-matched, and constrained members. The matched members Group can be used with the $davinci-data-export operation to retrieve bulk FHIR data for all matched members. The $davinci-data-export operation returns a manifest file referencing bulk data files in ndjson format. |
| [PDex Provider-Member-Match Operation](OperationDefinition-ProviderMemberMatch.md) | Provider-Member-Match Operation enables providers to match patient demographics and coverage information against a payer's member records. The operation returns matched members as a Group resource that can be used with the $davinci-data-export operation for bulk data retrieval. This operation aligns with the Payer-to-Payer Bulk Member Match but is designed for provider-initiated requests.The matched members returned in the MatchedMembers Group can be used directly with the $davinci-data-export operation on the Group resource to retrieve bulk FHIR data for all matched members. The $davinci-data-export operation will return a manifest file referencing the bulk data files containing the member health information in ndjson format. |

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [ExplanationOfBenefit_Identifier](SearchParameter-explanationofbenefit-identifier.md) | The business/claim identifier of the Explanation of Benefit |
| [ExplanationOfBenefit_Patient](SearchParameter-explanationofbenefit-patient.md) | The reference to the patient |
| [ExplanationOfBenefit_ServiceDate](SearchParameter-explanationofbenefit-service-date.md) | Date of the service for the EOB. The service-date search parameter simplifies the search, since a client doesn't need to know that. For inpatient and outpatient institutional EOB dates they need to search by billablePeriod.period.start, for a pharmacy EOB by item.servicedDate, and for a professional and non-clinician EOB - by item.servicedPeriod.period.start. |
| [ExplanationOfBenefit_Type](SearchParameter-explanationofbenefit-type.md) | The type of the ExplanationOfBenefit |
| [ExplanationOfBenefit_Use](SearchParameter-explanationofbenefit-use.md) | The use of the ExplanationOfBenefit |
| [Group_Code](SearchParameter-group-code.md) | The code of the Group |
| [PdexMedicationDispensePatient](SearchParameter-pdex-medicationdispense-patient.md) | Returns dispensed prescriptions for a specific patient. NOTE: This Pdex SearchParameter definition extends the usage context of[capabilitystatement-expectation](http://hl7.org/fhir/R4/extension-capabilitystatement-expectation.html)extension to formally express implementer conformance expectations for these elements:* multipleAnd
* multipleOr
* comparator
* modifier
* chain.
 |
| [PdexMedicationDispenseStatus](SearchParameter-pdex-medicationdispense-status.md) | Status of the prescription dispense. NOTE: This SearchParameter definition extends the usage context of[capabilitystatement-expectation](http://hl7.org/fhir/R4/extension-capabilitystatement-expectation.html)extension to formally express implementer conformance expectations for these elements:* multipleAnd
* multipleOr
* comparator
* modifier
* chain.
 |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Member Opt-Out Group](StructureDefinition-member-opt-out-group.md) | A Group resource representing members who have opted out of data sharing. The Payer is the managing organization. The group members are the patients who have exercised their right to opt-out of sharing their health information, either broadly or for specific purposes or providers. This group is used to identify members whose data should not be shared in payer-to-payer or provider access scenarios. |
| [Member-Provider Treatment Relationship Group](StructureDefinition-member-provider-treatment-relationship-group.md) | A Group resource representing the treatment relationship between a specific member/patient and one or more healthcare providers. The Payer is the managing organization. The member is identified through a characteristic containing the Patient ID. The group members are the providers that have an active or confirmed treatment relationship with the member. |
| [PDex $multi-member-match request](StructureDefinition-pdex-parameters-multi-member-match-bundle-in.md) | A Parameters profile defining the inputs to a $bulk-member-match operation performed by a payer system |
| [PDex $multi-member-match response](StructureDefinition-pdex-parameters-multi-member-match-bundle-out.md) | A Parameters profile defining the result of a $bulk-member-match operation performed by a payer system |
| [PDex Device](StructureDefinition-pdex-device.md) | The PDex Device profile is provided to enable payers to record information about devices used by a member that may not have a UDI number. FHIR-29796 PDex Device uses base resource not US Core Implantable Device Profile. Pdex-Device enables payers to record non-implantable device data. CGP Voted on variance approval: Drew Torres/Eric Haas: 9-0-0 |
| [PDex MedicationDispense](StructureDefinition-pdex-medicationdispense.md) | Prescription Medications dispensed by a pharmacy to a health plan member and paid for in full, or in part, by the health plan |
| [PDex Member Match Group](StructureDefinition-pdex-member-match-group.md) | A Group List created by the Payer to enable Bulk Payer-to-Payer API access by Other Payers to retrieve member information. Based on the Group resource. An Extension is added to capture the submitted parameters for the access request. |
| [PDex Member No Match Group](StructureDefinition-pdex-member-no-match-group.md) | A Group List created by the Payer to provide information back to a requesting payer about failed matches. Based on the Group resource. An Extension is added to capture the submitted patient demographics for the access request. The match may have failed for one of two reasons. a) No match on member. b) Matched but unable to comply with consent request. |
| [PDex Prior Authorization](StructureDefinition-pdex-priorauthorization.md) | The PDex Prior Authorization (PPA) profile is based on the ExplanationOfBenefit resource and is provided to enable payers to express Prior Authorization information to members. |
| [PDex Provenance](StructureDefinition-pdex-provenance.md) | Provenance is provided by the payer to identify the source of the information, whether the data came via a clinical record or a claim record and whether the data was subject to manual transcription or other interpretive transformation. This profile adds PayerSourceFormat as an extension on the entity base element. |
| [PDex Provider Access Consent Profile](StructureDefinition-pdex-provider-consent.md) | The PDex Provider Access Consent Profile enables a member to express their preference for the sharing of their healthcare information to providers through the Provider Access API. A member has to actively choose to opt-out of sharing their data. |
| [PDex Provider Group](StructureDefinition-pdex-provider-group.md) | The Provider Attribution Group List. Based on the Da Vinci Attribution Group (ATRGroup) Profile with the addition of extensions to track latest download for a member. Each member element in the Group record, that is processed by the export operation, should be updated with the execution date/time in lastTransmitted, list of resources (resourceTypes) in lastResources and query filters (filterQueries) in lastFilters. |
| [Provider $multi-member-match Request](StructureDefinition-provider-parameters-multi-member-match-bundle-in.md) | A Parameters profile defining the inputs to a $bulk-member-match operation performed by a payer system in response to a provider request. This differs from the payer-to-payer multi-member-match by including current member demographics, current coverage, and provider treatment attestation rather than patient consent for payer-to-payer data exchange. |
| [Provider $multi-member-match Response](StructureDefinition-provider-parameters-multi-member-match-bundle-out.md) | A Parameters profile defining the result of a $bulk-member-match operation performed by a payer system in response to a provider request. The response indicates which members were successfully matched and authorized for provider access, which were not found, and which have opted out of Provider Access API data sharing. |
| [Provider Attestation to Treatment Relationship](StructureDefinition-provider-treatment-relationship-consent.md) | Enables a practitioner, facility, or organization to attest to a treatment relationship with a patient. This profile documents that a healthcare provider has an active treatment relationship with the patient for the purposes of care delivery, coordination, and related activities. This profile is used in the Provider-Member-Match operation to enable providers to assert treatment relationships with patients for bulk data access. |
| [Provider Member Match Group](StructureDefinition-provider-member-match-group.md) | A Group List created by the Payer to enable Provider Access API access by providers to retrieve member information. Based on the Group resource. An Extension is added to capture the submitted parameters from the provider's match request. |
| [Provider Member No Match Group](StructureDefinition-provider-member-no-match-group.md) | A Group List created by the Payer to provide information back to a requesting provider about failed matches. Based on the Group resource. An Extension is added to capture the submitted patient demographics from the provider's request. The match may have failed for one of two reasons: a) No match on member (member not found in payer's system), or b) Matched but unable to comply due to member's opt-out of Provider Access API. |
| [mTLS Endpoint](StructureDefinition-mtls-endpoint.md) | The mTLS Endpoint is used to assist payers in defining their mTLS endpoints and discovering other Payer's mTLS endpoints |
| [mTLS Endpoint Bundle](StructureDefinition-mtls-bundle.md) | A bundle of Endpoint and Organization resources to enable mTLS endpoint discovery and configuration. |
| [mTLS Organization](StructureDefinition-mtls-organization.md) | The mTLS Organization record is used to identify the contact information for a Payer that owns a mTLS Endpoint, or is the managing organization tht administers the Endpoint. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [An attribute to describe the data source a resource was constructed from](StructureDefinition-ProvenanceSourceFrom.md) | Attributes that identify the source record format from which data in the referenced resources was derived |
| [An attribute to express the amount of a service or item that has been utilized](StructureDefinition-PriorAuthorizationUtilization.md) | Attribute that expresses the amount of an item or service that has been consumed under the current prior authorization. |
| [An attribute to express the refill number of a prescription](StructureDefinition-DispenseRefill.md) | Attribute that identifies the refill number of a prescription. e.g., 0, 1, 2, etc. |
| [LevelOfServiceCode](StructureDefinition-extension-levelOfServiceCode.md) | A code specifying the level of service being requested (UM06) |
| [Member Last Resource Filters](StructureDefinition-base-ext-last-typefilter.md) | Indicates the filters applied to the resources exported in the last export operation. This string can be taken from the DaVinci Data Export Request _typeFilter Parameter. |
| [Member Last Resource Types](StructureDefinition-base-ext-last-types.md) | Indicates the resources exported in the last export operation. This string can be taken from the DaVinci Data Export Request _type Parameter. |
| [Member Last Transmission](StructureDefinition-base-ext-last-transmission.md) | Indicates the last date/time that data ware requested and transmitted for a member as part of a data delta access request. |
| [Member-Match Input Patient Parameter](StructureDefinition-base-ext-match-parameters.md) | Input Patient Parameter supplied for the individual member match (Patient Demographics). |
| [Members Opted-out](StructureDefinition-base-ext-members-opted-out.md) | Indicates the number of members that have opted out of sharing |
| [NDH Associated Servers](StructureDefinition-base-ext-associatedServers.md) | Associated Servers |
| [NDH Contactpoint Availabletime](StructureDefinition-base-ext-contactpoint-availabletime.md) | An extension representing the days and times a contact point is available |
| [NDH Dynamic Registration](StructureDefinition-base-ext-dynamicRegistration.md) | Dynamic Registration |
| [NDH Endpoint Access Control Mechanism](StructureDefinition-base-ext-endpointAccessControlMechanism.md) | Endpoint Access Control Mechanism |
| [NDH Endpoint Rank](StructureDefinition-base-ext-endpoint-rank.md) | Order established by a Role, Organization… for Endpoints capable of transferring the same content |
| [NDH Endpoint Usecase](StructureDefinition-base-ext-endpoint-usecase.md) | EndpointUseCase is an enumeration of the specific use cases (service descriptions) supported by the endpoint |
| [NDH FHIR IG](StructureDefinition-base-ext-fhir-ig.md) | FHIR IG |
| [NDH Identifier Status](StructureDefinition-base-ext-identifier-status.md) | Describes the status of an identifier |
| [NDH Secure Exchange Artifacts](StructureDefinition-base-ext-secureExchangeArtifacts.md) | Secure Exchange Artifacts |
| [NDH Trust Framework](StructureDefinition-base-ext-trustFramework.md) | Trust Framework |
| [NDH Verification Status](StructureDefinition-base-ext-verification-status.md) | Indicates a resource instance verification status |
| [Opt-Out Details](StructureDefinition-opt-out-details.md) | Detailed information about when and why a member opted out |
| [Opt-Out Reason](StructureDefinition-opt-out-reason.md) | The reason a member has chosen to opt out of data sharing |
| [ReviewAction](StructureDefinition-extension-reviewAction.md) | The details of the review action that is necessary for the authorization. |
| [ReviewActionCode](StructureDefinition-extension-reviewActionCode.md) | The code describing the result of the review. |
| [Treatment Relationship Details](StructureDefinition-treatment-relationship-details.md) | Details about a specific treatment relationship between a member and provider |
| [When Adjudicated](StructureDefinition-base-ext-when-adjudicated.md) | Date and Time when Adjudication Action took place. NOTE: that this extension may be replaced by an inter-version extension after R6 version of the EOB implements this DataTime element. |
| [mTLS Signed Object](StructureDefinition-pdex-mtls-signedobject-extension.md) | mTLS Endpoint Signed Object Extension |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Endpoint Payload Type Value Set](ValueSet-EndpointPayloadTypeVS.md) | Endpoint Payload Types are constrained to NA (Not Applicable) as part of this IG |
| [FDA National Drug Code (NDC)](ValueSet-FDANationalDrugCode.md) | The Drug Listing Act of 1972 requires registered drug establishments to provide the Food and Drug Administration (FDA) with a current list of all drugs manufactured, prepared, propagated, compounded, or processed by it for commercial distribution. (See Section 510 of the Federal Food, Drug, and Cosmetic Act (Act) (21 U.S.C. § 360)). Drug products are identified and reported using a unique, three-segment number, called the National Drug Code (NDC), which serves as a universal product identifier for drugs. FDA publishes the listed NDC numbers and the information submitted as part of the listing information in the NDC Directory which is updated daily.The information submitted as part of the listing process, the NDC number, and the NDC Directory are used in the implementation and enforcement of the Act.Users should note:Starting June 1, 2011, only drugs for which electronic listings (SPL) have been submitted to the FDA are included in the NDC Directory. Drugs for which listing information was last submitted to FDA on paper forms, prior to June 2009, are included on a separate file and will not be updated after June 2012.Information regarding the FDA published NDC Directory can be found[here](https://www.fda.gov/drugs/drug-approvals-and-databases/national-drug-code-directory)Users should note a few important items* The NDC Directory is updated daily.
* The new NDC Directory contains ONLY information on final marketed drugs submitted to the FDA in SPL electronic listing files by labelers.
* The NDC Directory does not contain all listed drugs. The new version includes the final marketed drugs which listing information were submitted electronically. It does not include animal drugs, blood products, or human drugs that are not in final marketed form, such as Active Pharmaceutical Ingredients(APIs), drugs for further processing, drugs manufactured exclusively for a private label distributor, or drugs that are marketed solely as part of a kit or combination product or inner layer of a multi-level packaged product not marketed individually. For more information about how certain kits or multi-level packaged drugs are addressed in the new NDC Directory, see the NDC Directory Package File definitions document. For the FDA Online Label Repository page and additional resources go to: [FDA Online Label Repository](https://labels.fda.gov/)
 |
| [Opt-Out Reason](ValueSet-opt-out-reason-valueset.md) | Reasons for opting out of data sharing |
| [Opt-Out Scope](ValueSet-opt-out-scope-valueset.md) | The scope of a member's opt-out election |
| [Organization Type VS](ValueSet-OrgTypeVS.md) | Categories of organizations based on criteria in provider directories. |
| [PDex Adjudication](ValueSet-PDexAdjudication.md) | Describes the various amount fields used when payers receive and adjudicate a claim. It includes the values defined in http://terminology.hl7.org/CodeSystem/adjudication, as well as those defined in the C4BB Adjudication CodeSystem. |
| [PDex Adjudication Category Discriminator](ValueSet-PDexAdjudicationCategoryDiscriminator.md) | Used as the discriminator for adjudication.category and item.adjudication.category for the PDex Prior Authorization. |
| [PDex Multi-Member Match Result Value Set](ValueSet-PDexMultiMemberMatchResultVS.md) | Codes to describe the results group from a multi-member Match operation or Member Attribution Process. |
| [PDex Payer Benefit Payment Status](ValueSet-PDexPayerBenefitPaymentStatus.md) | Indicates the in network or out of network payment status of the claim. |
| [PDex SupportingInfo Type](ValueSet-PDexSupportingInfoType.md) | Used as the discriminator for the types of supporting information for the PDEX Prior Authorization. Based on the CARIN IG for Blue Button� Implementation Guide. |
| [Payer source of data](ValueSet-ProvenancePayerSourceFormat.md) | Source Data formats used as the source for FHIR referenced record by the Payer. |
| [Prior Authorization Procedure Codes - AMA CPT - CMS HCPCS - CMS HIPPS](ValueSet-PDexPAInstitutionalProcedureCodesVS.md) | The Value Set is a combination of three Code Systems: CPT (HCPCS I), HCPCS II procedure codes, and HIPPS rate codes. They are submitted by providers to payers to convey the specific procedure performed. Procedure Codes leverage US Core Procedure Codes composition.The target set for this value set are the procedure codes from the CPT and HCPCS files and the rate codes from the HIPPS files.The Current Procedural Terminology (CPT) code set, created and maintained by the American Medical Association, is the language of medicine today and the code to its future. This system of terminology is the most widely accepted medical nomenclature used to report medical procedures and services under public and private health insurance programs. CPT coding is also used for administrative management purposes such as claims processing and developing guidelines for medical care review. Each year, via a rigorous, evidence-based and transparent process, the independent CPT Editorial Panel revises, creates or deletes hundreds of codes in order to reflect current medical practice.Designated by the U.S. Department of Health and Human Services under the Health Insurance Portability and Accountability Act (HIPAA) as a national coding set for physician and other health care professional services and procedures, CPT’s evidence-based codes accurately encompass the full range of health care services.All CPT codes are five-digits and can be either numeric or alphanumeric, depending on the category. CPT code descriptors are clinically focused and utilize common standards so that a diverse set of users can have common understanding across the clinical health care paradigm.There are various types of CPT codes:**Category I:**These codes have descriptors that correspond to a procedure or service. Codes range from 00100–99499 and are generally ordered into sub-categories based on procedure/service type and anatomy.**Category II:**These alphanumeric tracking codes are supplemental codes used for performance measurement. Using them is optional and not required for correct coding.**Category III:**These are temporary alphanumeric codes for new and developing technology, procedures and services. They were created for data collection, assessment and in some instances, payment of new services and procedures that currently don’t meet the criteria for a Category I code.**Proprietary Laboratory Analyses (PLA) codes:**Recently added to the CPT code set, these codes describe proprietary clinical laboratory analyses and can be either provided by a single (solesource) laboratory or licensed or marketed to multiple providing laboratories that are cleared or approved by the Food and Drug Administration (FDA)). This category includes but is not limited to Advanced Diagnostic Laboratory Tests (ADLTs) and Clinical Diagnostic Laboratory Tests (CDLTs), as defined under the Protecting Access to Medicare Act of 2014 (PAMA).To obtain CPT, please see the license request form[here](http://info.commerce.ama-assn.org/ama-data-file-request-2020)The Level II HCPCS codes, which are established by CMS's Alpha-Numeric Editorial Panel, primarily represent items and supplies and non-physician services not covered by the American Medical Association's Current Procedural Terminology-4 (CPT-4) codes; Medicare, Medicaid, and private health insurers use HCPCS procedure and modifier codes for claims processing. Level II alphanumeric procedure and modifier codes comprise the A to V range.General information can be found here:[https://www.cms.gov/Medicare/Coding/MedHCPCSGenInfo](https://www.cms.gov/Medicare/Coding/MedHCPCSGenInfo)Releases can be found here:[https://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets](https://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets)These files contain the Level II alphanumeric HCPCS procedure and modifier codes, their long and short descriptions, and applicable Medicare administrative, coverage and pricing data.The Health Insurance Prospective Payment System (HIPPS) rate codes represent specific sets of patient characteristics (or case-mix groups) health insurers use to make payment determinations under several prospective payment systems. Case-mix groups are developed based on research into utilization patterns among various provider types. For the payment systems that use HIPPS codes, clinical assessment data is the basic input. A standard patient assessment instrument is interpreted by case-mix grouping software algorithms, which assign the case mix group. For payment purposes, at least one HIPPS code is defined to represent each case-mix group. These HIPPS codes are reported on claims to insurers. Institutional providers use HIPPS codes on claims in association with special revenue codes. One revenue code is defined for each prospective payment system that requires HIPPS codes. HIPPS codes are placed in data element SV202 on the electronic 837 institutional claims transaction, using an HP qualifier, or in Form Locator (FL) 44 ("HCPCS/rate") on a paper UB-04 claims form. The associated revenue code is placed in data element SV201 or in FL 42. In certain circumstances, multiple HIPPS codes may appear on separate lines of a single claim.HIPPS codes are alpha-numeric codes of five digits. Each code contains intelligence, with certain positions of the code indicating the case mix group itself, and other positions providing additional information. The additional information varies among HIPPS codes pertaining to different payment systems, but often provides information about the clinical assessment used to arrive at the code. Which positions of the code carry the case mix group information may also vary by payment systems. |
| [Prior Authorization Service Type Codes (X12)](ValueSet-PriorAuthServiceTypeCodes.md) | Indicates the Type of Service that a Prior Authorization is covering |
| [Prior Authorization value categories](ValueSet-PriorAuthorizationAmounts.md) | Codes to define Prior Authorization requested, agreed and utilized amounts. |
| [Procedure Codes - AMA CPT - CMS HCPCS - CMS HIPPS](ValueSet-PDexPAInstitutionalProcedureCodes.md) | The Value Set is a combination of three Code Systems: CPT (HCPCS I), HCPCS II procedure codes, and HIPPS rate codes. They are submitted by providers to payers to convey the specific procedure performed. Procedure Codes leverage US Core Procedure Codes composition.The target set for this value set are the procedure codes from the CPT and HCPCS files and the rate codes from the HIPPS files.The Current Procedural Terminology (CPT) code set, created and maintained by the American Medical Association, is the language of medicine today and the code to its future. This system of terminology is the most widely accepted medical nomenclature used to report medical procedures and services under public and private health insurance programs. CPT coding is also used for administrative management purposes such as claims processing and developing guidelines for medical care review. Each year, via a rigorous, evidence-based and transparent process, the independent CPT Editorial Panel revises, creates or deletes hundreds of codes in order to reflect current medical practice.Designated by the U.S. Department of Health and Human Services under the Health Insurance Portability and Accountability Act (HIPAA) as a national coding set for physician and other health care professional services and procedures, CPT’s evidence-based codes accurately encompass the full range of health care services.All CPT codes are five-digits and can be either numeric or alphanumeric, depending on the category. CPT code descriptors are clinically focused and utilize common standards so that a diverse set of users can have common understanding across the clinical health care paradigm.There are various types of CPT codes:**Category I:**These codes have descriptors that correspond to a procedure or service. Codes range from 00100–99499 and are generally ordered into sub-categories based on procedure/service type and anatomy.**Category II:**These alphanumeric tracking codes are supplemental codes used for performance measurement. Using them is optional and not required for correct coding.**Category III:**These are temporary alphanumeric codes for new and developing technology, procedures and services. They were created for data collection, assessment and in some instances, payment of new services and procedures that currently don’t meet the criteria for a Category I code.**Proprietary Laboratory Analyses (PLA) codes:**Recently added to the CPT code set, these codes describe proprietary clinical laboratory analyses and can be either provided by a single (solesource) laboratory or licensed or marketed to multiple providing laboratories that are cleared or approved by the Food and Drug Administration (FDA)). This category includes but is not limited to Advanced Diagnostic Laboratory Tests (ADLTs) and Clinical Diagnostic Laboratory Tests (CDLTs), as defined under the Protecting Access to Medicare Act of 2014 (PAMA).To obtain CPT, please see the license request form[here](http://info.commerce.ama-assn.org/ama-data-file-request-2020)The Level II HCPCS codes, which are established by CMS's Alpha-Numeric Editorial Panel, primarily represent items and supplies and non-physician services not covered by the American Medical Association's Current Procedural Terminology-4 (CPT-4) codes; Medicare, Medicaid, and private health insurers use HCPCS procedure and modifier codes for claims processing. Level II alphanumeric procedure and modifier codes comprise the A to V range.General information can be found here:[https://www.cms.gov/Medicare/Coding/MedHCPCSGenInfo](https://www.cms.gov/Medicare/Coding/MedHCPCSGenInfo)Releases can be found here:[https://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets](https://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets)These files contain the Level II alphanumeric HCPCS procedure and modifier codes, their long and short descriptions, and applicable Medicare administrative, coverage and pricing data.The Health Insurance Prospective Payment System (HIPPS) rate codes represent specific sets of patient characteristics (or case-mix groups) health insurers use to make payment determinations under several prospective payment systems. Case-mix groups are developed based on research into utilization patterns among various provider types. For the payment systems that use HIPPS codes, clinical assessment data is the basic input. A standard patient assessment instrument is interpreted by case-mix grouping software algorithms, which assign the case mix group. For payment purposes, at least one HIPPS code is defined to represent each case-mix group. These HIPPS codes are reported on claims to insurers. Institutional providers use HIPPS codes on claims in association with special revenue codes. One revenue code is defined for each prospective payment system that requires HIPPS codes. HIPPS codes are placed in data element SV202 on the electronic 837 institutional claims transaction, using an HP qualifier, or in Form Locator (FL) 44 ("HCPCS/rate") on a paper UB-04 claims form. The associated revenue code is placed in data element SV201 or in FL 42. In certain circumstances, multiple HIPPS codes may appear on separate lines of a single claim.HIPPS codes are alpha-numeric codes of five digits. Each code contains intelligence, with certain positions of the code indicating the case mix group itself, and other positions providing additional information. The additional information varies among HIPPS codes pertaining to different payment systems, but often provides information about the clinical assessment used to arrive at the code. Which positions of the code carry the case mix group information may also vary by payment systems. |
| [Provenance Agent Type](ValueSet-ProvenanceAgentType.md) | Agent role performed relating to referenced resource |
| [Treatment Attestation Provision Type](ValueSet-attestation-provision-type-valueset.md) | Allowed provision types for treatment relationship attestations |
| [Treatment Attestation Status](ValueSet-attestation-status-valueset.md) | Allowed statuses for treatment relationship attestations |
| [Treatment Relationship Type](ValueSet-treatment-relationship-type-valueset.md) | Types of treatment relationships between members and providers |
| [Trust Framework Type Value Set](ValueSet-TrustFrameworkTypeVS.md) | Trust Framework Type |
| [X12 278 Review Decision Reason Codes](ValueSet-X12278ReviewDecisionReasonCode.md) | Codes used to identify the reason for the health care service review outcome. |
| [X12 Claim Adjustment Reason Codes - Remittance Advice Remark Codes](ValueSet-X12ClaimAdjustmentReasonCodesCMSRemittanceAdviceRemarkCodes.md) | X12, chartered by the American National Standards Institute for more than 40 years, develops and maintains EDI standards and XML schemas which drive business processes globally. X12's diverse membership includes technologists and business process experts in health care, insurance, transportation, finance, government, supply chain and other industries.The X12 Claim Adjustment Reason Codes describe why a claim or service line was paid differently than it was billed. These codes are listed within an X12 implementation guide (TR3) and maintained by X12.Remittance Advice Remark Codes (RARCs) are used to provide additional explanation for an adjustment already described by a Claim Adjustment Reason Code (CARC) or to convey information about remittance processing.Each RARC identifies a specific message as shown in the Remittance Advice Remark Code List. There are two types of RARCs, supplemental and informational. The majority of the RARCs are supplemental; these are generally referred to as RARCs without further distinction. Supplemental RARCs provide additional explanation for an adjustment already described by a CARC. The second type of RARC is informational; these RARCs are all prefaced with Alert: and are often referred to as Alerts. Alerts are used to convey information about remittance processing and are never related to a specific adjustment or CARC.External code lists maintained by X12 and external code lists maintained by others and distributed by WPC on behalf of the maintainer can be found here:[https://x12.org/codes](https://x12.org/codes)Click on the name of any external code list to access more information about the code list, view the codes, or submit a maintenance request. These external code lists were previously published on either[www.wpc-edi.com/reference](http://www.wpc-edi.com/reference)or[www.x12.org/codes](http://www.x12.org/codes). |
| [mTLS Signed Object Types](ValueSet-MtlsObjectTypeVS.md) | The Object type |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Endpoint Payload Types Code System](CodeSystem-EndpointPayloadTypeCS.md) | Endpoint Payload Types are constrained to NA (Not Applicable) as part of this IG |
| [Opt-Out Reason](CodeSystem-opt-out-reason.md) | Reasons for opting out of data sharing |
| [Opt-Out Scope](CodeSystem-opt-out-scope.md) | The scope of a member's opt-out election |
| [Organization Type](CodeSystem-OrgTypeCS.md) | Categories of organizations based on criteria in provider directories. |
| [PDex Adjudication Discriminator](CodeSystem-PDexAdjudicationDiscriminator.md) | Used as the discriminator for the data elements in adjudication and item.adjudication |
| [PDex Identifier Type](CodeSystem-PDexIdentifierType.md) | Identifier Type codes that extend those defined in http://terminology.hl7.org/CodeSystem/v2-0203 to define the type of identifier payers and providers assign to claims and patients |
| [PDex Member Characteristic Code](CodeSystem-pdex-member-characteristic-code.md) | Codes for member characteristics in PDex groups |
| [PDex Multi-Member Match Result Code System](CodeSystem-PdexMultiMemberMatchResultCS.md) | Code set to describe the results group from a multi-member Match operation |
| [PDex Payer Adjudication Status](CodeSystem-PDexPayerAdjudicationStatus.md) | Describes the various status fields used when payers adjudicate a claim, such as whether the claim was adjudicated in or out of network, if the provider was contracted or non-contracted for the service |
| [PDex Provider Access API Attribution Code System](CodeSystem-PdexMemberAttributionCS.md) | Code set to identify group resources from a Member Attribution Process that is used by Provider Access API. |
| [PDex Supporting Info Type](CodeSystem-PDexSupportingInfoTypeCS.md) | Claim Information Category - Used as the discriminator for supportingInfo |
| [Prior Authorization Values](CodeSystem-PriorAuthorizationValueCodes.md) | Codes used to define Prior Authorization categories |
| [Provenance Payer Data Source Format](CodeSystem-ProvenancePayerDataSource.md) | CodeSystem for source formats that identify what non-FHIR source was used to create FHIR record(s) |
| [Provenance Roles](CodeSystem-ProvenanceAgentRoleType.md) | CodeSystem for types of role relating to the creation or communication of referenced resources |
| [Treatment Relationship Type](CodeSystem-treatment-relationship-type.md) | Types of treatment relationships between members and providers |
| [Trust FrameworkType Code System](CodeSystem-TrustFrameworkTypeCS.md) | Trust Framework Type |
| [Trust Profile Code System](CodeSystem-TrustProfileCS.md) | Trust Profile |
| [mTLS Object Type Code](CodeSystem-MtlsObjectCodeCS.md) | Codes for the Signed Object Types |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [$multi-member-match payer example request](Parameters-payer-multi-member-match-in.md) | Example of more than one member being submitted to the PDex Payer-to-Payer Multiple Member Match Operation. |
| [$multi-member-match payer example response](Parameters-payer-multi-member-match-out.md) | Example of group record being returned in response to PDex Payer-to-Payer Multiple Member Match Operation. |
| [Acme](Organization-Acme.md) | Payer Organization |
| [BundleConditionWithProvenance](Bundle-3000003.md) | A bundle that returns Conditions with provenance using _revinclude=Provenance:target |
| [BundleExamplePayer1](Bundle-1000000-1.md) | The bundle pulled from Payer1 by Payer 2 when a member switches to Payer 2. Patient, 2 Encounters and 2 Provenance records. |
| [BundleExamplePayer2](Bundle-1000000-2.md) | The bundle pulled from Payer2 by Payer 3 when a member switches to Payer 3. Patient, 2 Encounters and 2 Provenance records plus new records from Payer 2. |
| [BundleExamplePayer3](Bundle-1000000-3.md) | The bundle pulled from Payer3 by Payer 4 when a member switches to Payer 4. Patient, 2 Encounters and 2 Provenance records originating from Payer 1 plus new records from Payer 2 and Payer 3, including supporting Provenance records. |
| [BundleWithProvenance](Bundle-3000002.md) | A bundle that returns provenance using _revinclude=Provenance:target |
| [Coverage to Link Example 1](Coverage-CoverageLinkExample1.md) | New coverage information to link for the member |
| [Coverage to Match Example 1](Coverage-CoverageMatchExample1.md) | Member's previous coverage information to match |
| [Coverage to Match Example 2](Coverage-CoverageMatchExample2.md) | Second member's previous coverage information |
| [Example-PDex-Provider-Group](Group-Example-PDex-Provider-Group.md) | Example of a Payer-generated Member Attribution List for an In-Network/Contracted Provider. |
| [ExampleBundle1](Bundle-2000002.md) | A simple bundle to demonstrate a provenance example |
| [ExampleCoverage](Coverage-883210.md) | Example of a Coverage for a Member |
| [ExampleDevice](Device-543210.md) | Example of a Device from a Claim |
| [ExampleDocRefProvenance](Provenance-1000016.md) | Example of a PDex Provenance record for a PDF embedded or linked in a DocumentReference resource. |
| [ExampleDocumentReference](DocumentReference-123456.md) | Example of a US Core DocumentReference with a linked PDF document. The document could also be embedded. |
| [ExampleEncounter1](Encounter-6.md) | Example of an Encounter that has a provenance record received by Payer 1 |
| [ExampleEncounter2](Encounter-7.md) | Example of an Encounter that has a provenance record received by Payer 1 |
| [ExampleEncounter3](Encounter-8.md) | Example of an Encounter that has a provenance record received by Payer 2 |
| [ExampleLocation](Location-5.md) | Example of a Pharmacy Location Record |
| [ExampleMedicationDispenseClaim](MedicationDispense-1000001.md) | Example of a MedicationDispense from a Claim |
| [ExamplePractitioner](Practitioner-4.md) | Example of a Practitioner Record |
| [ExampleProvenanceAuthorEncounter6](Provenance-1000002.md) | Example of an author Provenance record displaying a practitioner's organization as the author |
| [ExampleProvenanceAuthorEncounter7](Provenance-1000003.md) | Example of an author Provenance record displaying a practitioner's organization as the author |
| [ExampleProvenanceBundleTransmitter](Provenance-1000017.md) | Example of a Transmitter Provenance record for a bundle |
| [ExampleProvenanceCustodian](Provenance-1000101.md) | Example of a Custodian Provenance record for the contents of a bundle received from another payer |
| [ExampleProvenancePayerModified](Provenance-1000006.md) | Example of provenance based on security group recommendations |
| [ExampleProvenancePayerSource](Provenance-1000005.md) | Example of a payer being the source of the data |
| [ExampleProvenanceSoloPractitioner](Provenance-1000004.md) | Example of an author Provenance record displaying a sole practitioner as the author |
| [ExampleProvenanceTransmitter](Provenance-1000001.md) | Example of a Transmitter Provenance record for a bundle |
| [OrganizationPayer1](Organization-Payer1.md) | Example of the Payer Organization |
| [OrganizationPayer1-1](Organization-Payer1-1.md) | Example of the Payer Organization |
| [OrganizationPayer2](Organization-Payer2.md) | Another Example of the Payer Organization |
| [OrganizationPayer2-2](Organization-Payer2-2.md) | Another Example of the Payer Organization |
| [OrganizationProvider1](Organization-ProviderOrg1.md) | Provider Organization Example 1 |
| [OrganizationProvider2](Organization-ProviderOrg2.md) | Provider Organization Example 1 |
| [PDex Provider Access Consent Example](Consent-no-consent-1.md) | An example of a PDex Provider Access Consent where a member expresses their desire to opt-out of sharing their data via the Provider Access API. |
| [PDexCoverageExample](Coverage-Coverage1.md) | Health Plan Coverage for Prior Authorization |
| [Patient for Member Match Example 1](Patient-PatientMemberMatchExample1.md) | Patient demographics submitted by provider for member match |
| [Patient for Member Match Example 2](Patient-PatientMemberMatchExample2.md) | Second patient demographics submitted by provider for member match |
| [Patient1](Patient-1.md) | Example of a US Core Patient Record for Payer 1 |
| [Patient1-2](Patient-1-2.md) | Example of a US Core Patient Record for Payer 2 |
| [Patient100](Patient-100.md) | Example of a US Core Patient Record for Payer 2 |
| [Patient1001](Patient-1001.md) | Example of a US Core Patient Record matched by old payer in Bulk Member Match |
| [Patient2002](Patient-2002.md) | Example of a US Core Patient Record matched by old payer in Bulk Member Match |
| [Payer's Patient Record for Member 1001](Patient-payer-patient-1001.md) | The payer's internal patient record that was matched to provider-submitted-patient-1 |
| [Payer's Patient Record for Member 2002](Patient-payer-patient-2002.md) | The payer's internal patient record that was matched to provider-submitted-patient-2 |
| [PdexPriorAuth](ExplanationOfBenefit-PDexPriorAuth1.md) | PDex Prior Authorization based on EOB Inpatient Example |
| [Provider Attestation Document Reference](DocumentReference-provider-attestation-doc-1.md) | Example DocumentReference representing a signed provider attestation form documenting the treatment relationship. |
| [Provider Bulk Member Match Request Example](Parameters-provider-bulk-member-match-in.md) | Example of a Bulk Member Match request for Provider Access, including provider treatment attestation consent. This differs from Payer-to-Payer member match by including current member demographics, current coverage, and provider attestation instead of old payer data and patient consent for data sharing between payers. |
| [Provider Bulk Member Match Response Example](Parameters-provider-bulk-member-match-out.md) | Example response to a Provider Bulk Member Match request showing matched members (authorized for provider access), non-matched members (not found in payer system), and consent-constrained members (opted out of Provider Access API). |
| [Provider Treatment Attestation Consent Example for Bulk Member Match](Consent-provider-treatment-attestation-1.md) | An example of a Provider Treatment Attestation Consent that would be included in a Bulk Member Match request for Provider Access. This attestation documents that Dr. Susan Smith has an active treatment relationship with the patient. |
| [Provider-Member-Match Request Example](Parameters-provider-member-match-request-001.md) | Example request to the Provider-Member-Match operation showing a provider submitting patient demographics, coverage information, and treatment attestation to match against a payer's member records. |
| [Provider-Member-Match Response Example](Parameters-provider-member-match-response-001.md) | Example response to a Provider-Member-Match operation showing matched members with treatment relationships confirmed, non-matched members, treatment attestation constraints, and opt-out constraints. |
| [Treatment Attestation Example 1](Consent-treatment-attestation-ex1.md) | Provider's attestation to active treatment relationship with patient |
| [Treatment Attestation Example 2](Consent-treatment-attestation-ex2.md) | Second provider's attestation to treatment relationship |
| [consentin2](Consent-consent-2.md) | Example Consent record for member match submission |
| [coveragein2](Coverage-coverage-2.md) | Example Coverage record for Old Payer in Member Match operation |
| [coveragelink2](Coverage-coverage-link-2.md) | Example Coverage from new payer for Member Match operation |
| [diamond-mtls-endpoint1](Endpoint-diamond-mtls-endpoint1.md) | NDH Endpoint compliant Profile as an example of Payer mTLS Endpoint that is linked from Organization and incorporated in bundle |
| [diamond-mtls-endpoint2](Endpoint-diamond-mtls-endpoint2.md) | National Directory Query Endpoint Profile as an example of Payer mTLS Endpoint that is linked from Organization and incorporated in bundle |
| [example-mtls-endpoint-bundle](Bundle-example-mtls-endpoint-bundle.md) | Example of mTLSbundle for Payer Endpoint for Payer-to-Payer Exchange |
| [example-pdex-member-consent-constraint-group](Group-example-pdex-member-consent-constraint-group.md) | Example of PDex Member Match Group that returns matches that fail the consent decision flow. |
| [example-pdex-member-match-group](Group-07e72a15407547bf9d03f522aa536a72.1.md) | Example of PDex Member Match Group that returns successful matches and creates a Group resource for use with bulk operations. |
| [example-pdex-member-no-match-group](Group-example-pdex-member-no-match-group.md) | Example of PDex Member Match Group that returns unsuccessful matches. |
| [mtlsorganization2](Organization-DiamondOnyxHealth1.md) | Example of mTLS Organization |
| [patientin2](Patient-patient-2.md) | Example Patienr Record for Member Match Operation |

