# $multi-member-match payer example request - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **$multi-member-match payer example request**

## Example Parameters: $multi-member-match payer example request



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "payer-multi-member-match-in",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/pdex-parameters-multi-member-match-bundle-in"
    ]
  },
  "parameter" : [
    {
      "name" : "MemberBundle",
      "part" : [
        {
          "name" : "MemberPatient",
          "resource" : {
            "resourceType" : "Patient",
            "id" : "patient-1",
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Default Generated text for resource.</div>"
            },
            "identifier" : [
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "MB"
                    }
                  ]
                },
                "system" : "http://example.org/old-payer/identifiers/member",
                "value" : "55678",
                "assigner" : {
                  "display" : "Old Payer"
                }
              }
            ],
            "name" : [
              {
                "use" : "official",
                "family" : "Person",
                "given" : ["Patricia", "Ann"]
              }
            ],
            "gender" : "female",
            "birthDate" : "1974-12-25"
          }
        },
        {
          "name" : "CoverageToMatch",
          "resource" : {
            "resourceType" : "Coverage",
            "id" : "coverage-1",
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Default Generated text for resource.</div>"
            },
            "identifier" : [
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "MB"
                    }
                  ]
                },
                "system" : "http://example.org/old-payer",
                "value" : "DH10001235"
              }
            ],
            "status" : "draft",
            "subscriberId" : "1234564321",
            "beneficiary" : {
              "reference" : "Patient/1"
            },
            "relationship" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
                  "code" : "self"
                }
              ]
            },
            "period" : {
              "start" : "2011-05-23",
              "end" : "2012-05-23"
            },
            "payor" : [
              {
                "identifier" : {
                  "system" : "http://hl7.org/fhir/sid/us-npi",
                  "value" : "9876543210"
                },
                "display" : "Old Health Plan"
              }
            ],
            "class" : [
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                      "code" : "group"
                    },
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                      "code" : "subplan"
                    }
                  ]
                },
                "value" : "P7"
              },
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                      "code" : "plan"
                    },
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                      "code" : "class"
                    }
                  ]
                },
                "value" : "SILVER"
              }
            ]
          }
        },
        {
          "name" : "Consent",
          "resource" : {
            "resourceType" : "Consent",
            "id" : "consent-1",
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Default Generated text for resource.</div>"
            },
            "status" : "active",
            "scope" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/consentscope",
                  "code" : "patient-privacy"
                }
              ]
            },
            "category" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                    "code" : "IDSCL"
                  }
                ]
              }
            ],
            "patient" : {
              "reference" : "Patient/1"
            },
            "performer" : [
              {
                "reference" : "Patient/1"
              }
            ],
            "sourceReference" : {
              "reference" : "http://example.org/DocumentReference/someconsent-1"
            },
            "policy" : [
              {
                "uri" : "http://hl7.org/fhir/us/davinci-hrex/StructureDefinition-hrex-consent.html#regular"
              }
            ],
            "provision" : {
              "type" : "permit",
              "period" : {
                "start" : "2023-12-01",
                "end" : "2024-03-31"
              },
              "actor" : [
                {
                  "role" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                        "code" : "performer"
                      }
                    ]
                  },
                  "reference" : {
                    "identifier" : {
                      "system" : "http://hl7.org/fhir/sid/us-npi",
                      "value" : "9876543210"
                    },
                    "display" : "Old Health Plan"
                  }
                },
                {
                  "role" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                        "code" : "IRCP"
                      }
                    ]
                  },
                  "reference" : {
                    "identifier" : {
                      "system" : "http://hl7.org/fhir/sid/us-npi",
                      "value" : "0123456789"
                    },
                    "display" : "New Health Plan"
                  }
                }
              ],
              "action" : [
                {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/consentaction",
                      "code" : "disclose"
                    }
                  ]
                }
              ]
            }
          }
        },
        {
          "name" : "CoverageToLink",
          "resource" : {
            "resourceType" : "Coverage",
            "id" : "coverage-link-1",
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Default Generated text for resource.</div>"
            },
            "identifier" : [
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "MB"
                    }
                  ]
                },
                "system" : "http://example.org/old-payer",
                "value" : "234567"
              }
            ],
            "status" : "draft",
            "subscriberId" : "432156789",
            "beneficiary" : {
              "reference" : "Patient/1"
            },
            "relationship" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
                  "code" : "self"
                }
              ]
            },
            "period" : {
              "start" : "2011-05-23",
              "end" : "2012-05-23"
            },
            "payor" : [
              {
                "identifier" : {
                  "system" : "http://hl7.org/fhir/sid/us-npi",
                  "value" : "0123456789"
                },
                "display" : "New Health Plan"
              }
            ]
          }
        }
      ]
    }
  ]
}

```
