# ExampleDevice - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **ExampleDevice**

## Example Device: ExampleDevice

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

version: 1; Last updated: 2020-09-28 09:26:23+0000

Profile: [PDex Device](StructureDefinition-pdex-device.md)

### UdiCarriers

| | |
| :--- | :--- |
| - | **DeviceIdentifier** |
| * | 23366006 |

**status**: Active

**manufacturer**: Motorized Wheelchair Company, Inc.

### DeviceNames

| | | |
| :--- | :--- | :--- |
| - | **Name** | **Type** |
| * | MotorChairPro | User Friendly name |

**type**: Motorized wheelchair device (physical object)

**patient**: [Johnny Appleseed Male, DoB: 1986-01-01 ( Member Number)](Patient-1.md)



## Resource Content

```json
{
  "resourceType" : "Device",
  "id" : "543210",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2020-09-28T09:26:23.217+00:00",
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/pdex-device"
    ]
  },
  "udiCarrier" : [
    {
      "deviceIdentifier" : "23366006"
    }
  ],
  "status" : "active",
  "manufacturer" : "Motorized Wheelchair Company, Inc.",
  "deviceName" : [
    {
      "name" : "MotorChairPro",
      "type" : "user-friendly-name"
    }
  ],
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "23366006"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/1"
  }
}

```
