# BundleWithProvenance - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **BundleWithProvenance**

## Example Bundle: BundleWithProvenance



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "3000002",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/Bundle"]
  },
  "type" : "searchset",
  "timestamp" : "2020-09-28T23:26:23.217+00:00",
  "total" : 1,
  "link" : [
    {
      "relation" : "self",
      "url" : "https://example.com/base/fhir/MedicationDispense?ct=W3sidG9rZW4iOiIrUklEOn53MThjQUk5RlVPZ0lEQUFBQUFBQU"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "https://example.com/base/MedicationDispense/1000001",
      "resource" : {
        "resourceType" : "MedicationDispense",
        "id" : "1000001",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationDispense_1000001\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationDispense 1000001</b></p><a name=\"1000001\"> </a><a name=\"hc1000001\"> </a><p><b>status</b>: Completed</p><p><b>medication</b>: <span title=\"Codes:{http://hl7.org/fhir/sid/ndc 54458-872-10}\">Lisinopril, 30 TABLET in 1 BLISTER PACK (54458-872-10) (package)</span></p><p><b>subject</b>: <a href=\"Patient-1.html\">Johnny Appleseed  Male, DoB: 1986-01-01 ( Member Number)</a></p><h3>Performers</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Actor</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Practitioner-4.html\">Practitioner Susan Smith </a></td></tr></table><p><b>location</b>: <a href=\"Location-5.html\">Location MyFavorite Pharmacy</a></p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode RF}\">Refill</span></p><p><b>quantity</b>: 60</p><p><b>daysSupply</b>: 30</p></div>"
        },
        "status" : "completed",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/sid/ndc",
              "code" : "54458-872-10"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/1"
        },
        "performer" : [
          {
            "actor" : {
              "reference" : "Practitioner/4"
            }
          }
        ],
        "location" : {
          "reference" : "Location/5"
        },
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
              "code" : "RF"
            }
          ]
        },
        "quantity" : {
          "value" : 60
        },
        "daysSupply" : {
          "value" : 30
        }
      },
      "search" : {
        "mode" : "match"
      }
    },
    {
      "fullUrl" : "https://example.com/base/Provenance/321000001",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "321000001",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2020-09-28T23:26:23.217+00:00",
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/pdex-provenance"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_321000001\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance 321000001</b></p><a name=\"321000001\"> </a><a name=\"hc321000001\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2020-09-28 23:26:23+0000</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-pdex-provenance.html\">PDex Provenance</a></p></div><p>Provenance for <a href=\"MedicationDispense-1000001.html\">MedicationDispense: extension = 1; status = completed; medication[x] = Lisinopril, 30 TABLET in 1 BLISTER PACK (54458-872-10) (package); type = Refill; quantity = 60; daysSupply = 30; whenHandedOver = 2024-04-15 09:00:23+0000</a></p><p>Summary</p><table class=\"grid\"><tr><td>Recorded</td><td>2020-07-12 18:26:23+0000</td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://hl7.org/fhir/us/core/CodeSystem/us-core-provenance-participant-type transmitter}\">Transmitter</span></td><td><a href=\"Organization-Payer1.html\">Organization Payer 1</a></td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "MedicationDispense/1000001"
          }
        ],
        "recorded" : "2020-07-12T18:26:23.217+00:00",
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-provenance-participant-type",
                  "code" : "transmitter",
                  "display" : "Transmitter"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/Payer1"
            }
          }
        ],
        "entity" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/ProvenanceSourceFrom",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-pdex/CodeSystem/ProvenancePayerDataSource",
                      "code" : "hl7ccda",
                      "display" : "HL7 C-CDA"
                    }
                  ]
                }
              }
            ],
            "role" : "source",
            "what" : {
              "display" : "No reference available"
            }
          }
        ]
      },
      "search" : {
        "mode" : "include"
      }
    }
  ]
}

```
