# ExampleBundle1 - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **ExampleBundle1**

## Example Bundle: ExampleBundle1



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "2000002",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/Bundle"]
  },
  "type" : "searchset",
  "timestamp" : "2020-07-16T20:26:23.217+00:00",
  "total" : 2,
  "link" : [
    {
      "relation" : "self",
      "url" : "https://example.com/base/fhir/MedicationDispense?ct=W3sidG9rZW4iOiIrUklEOn53MThjQUk5RlVPZ0lEQUFBQUFBQU"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "https://example.com/base/Patient/1",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient 1</b></p><a name=\"1\"> </a><a name=\"hc1\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Anonymous Patient (no stated gender), DoB Unknown</p><hr/></div>"
        }
      },
      "search" : {
        "mode" : "include"
      }
    },
    {
      "fullUrl" : "https://example.com/base/MedicationDispense/1000001",
      "resource" : {
        "resourceType" : "MedicationDispense",
        "id" : "1000001",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationDispense_1000001\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationDispense 1000001</b></p><a name=\"1000001\"> </a><a name=\"hc1000001\"> </a><p><b>status</b>: Completed</p><p><b>medication</b>: <span title=\"Codes:{http://hl7.org/fhir/sid/ndc 54458-872-10}\">Lisinopril, 30 TABLET in 1 BLISTER PACK (54458-872-10) (package)</span></p><p><b>subject</b>: <a href=\"Patient-1.html\">Johnny Appleseed  Male, DoB: 1986-01-01 ( Member Number)</a></p><h3>Performers</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Actor</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Practitioner-4.html\">Practitioner Susan Smith </a></td></tr></table><p><b>location</b>: <a href=\"Location-5.html\">Location MyFavorite Pharmacy</a></p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode RF}\">Refill</span></p><p><b>quantity</b>: 60</p><p><b>daysSupply</b>: 30</p></div>"
        },
        "status" : "completed",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/sid/ndc",
              "code" : "54458-872-10"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/1"
        },
        "performer" : [
          {
            "actor" : {
              "reference" : "Practitioner/4"
            }
          }
        ],
        "location" : {
          "reference" : "Location/5"
        },
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
              "code" : "RF"
            }
          ]
        },
        "quantity" : {
          "value" : 60
        },
        "daysSupply" : {
          "value" : 30
        }
      },
      "search" : {
        "mode" : "match"
      }
    }
  ]
}

```
