# BundleExamplePayer1 - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **BundleExamplePayer1**

## Example Bundle: BundleExamplePayer1



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "1000000-1",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/Bundle"]
  },
  "type" : "transaction-response",
  "timestamp" : "2019-12-31T20:26:23.217+00:00",
  "link" : [
    {
      "relation" : "self",
      "url" : "https://example.com/base/fhir/Patient?ct=W2idG9rZW4iOiIrUklEOn53MThjQUk5RlVPZ0lEQUFBQUFBQU"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "https://example.com/base/Patient/1",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "1",
        "meta" : {
          "lastUpdated" : "2019-07-07T13:26:22.0314215+00:00",
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient"
          ]
        },
        "language" : "en-US",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en-US\" lang=\"en-US\"><a name=\"Patient_1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient 1</b></p><a name=\"1\"> </a><a name=\"hc1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">Last updated: 2019-07-07 13:26:22+0000; Language: en-US</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-patient.html\">US Core Patient Profile</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Johnny Appleseed  Male, DoB: 1986-01-01 ( Member Number)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Record is active\">Active:</td><td>true</td><td style=\"background-color: #f3f5da\" title=\"Known Marital status of Patient\">Marital Status:</td><td colspan=\"3\"><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-NullFlavor UNK}\">unknown</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Other Ids (see the one above)\">Other Ids:</td><td colspan=\"3\"><ul><li>Medical record number/1234-234-1243-12345678901m</li><li>Health Plan Identifier/1234-234-1243-12345678901u</li><li>Patient external identifier/1234-234-1243-12345678901a</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\"><ul><li>ph: (443)555-1212</li><li>ph: (410)678-2323</li><li>123 Main Street Pittsburgh PA 12519 </li></ul></td></tr></table></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "MB"
                }
              ]
            },
            "system" : "https://www.xxxhealthplan.com/fhir/memberidentifier",
            "value" : "https://www.xxxhealthplan.com/fhir/memberidentifier#1234-234-1243-12345678901"
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "MR"
                }
              ]
            },
            "system" : "https://www.xxxhealthplan.com/fhir/medicalrecordnumber",
            "value" : "1234-234-1243-12345678901m"
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "XV"
                }
              ]
            },
            "system" : "https://www.xxxhealthplan.com/fhir/uniquememberidentifier",
            "value" : "1234-234-1243-12345678901u"
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "PT"
                }
              ]
            },
            "system" : "https://www.xxxhealthplan.com/fhir/patacctnum",
            "value" : "1234-234-1243-12345678901a"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Appleseed",
            "given" : ["Johnny"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "(443)555-1212",
            "rank" : 1
          },
          {
            "system" : "phone",
            "value" : "(410)678-2323",
            "rank" : 2
          }
        ],
        "gender" : "male",
        "birthDate" : "1986-01-01",
        "address" : [
          {
            "type" : "physical",
            "line" : ["123 Main Street"],
            "city" : "Pittsburgh",
            "state" : "PA",
            "postalCode" : "12519"
          }
        ],
        "maritalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
              "code" : "UNK"
            }
          ]
        }
      },
      "response" : {
        "status" : "200"
      }
    },
    {
      "fullUrl" : "https://example.com/base/Encounter/6-1",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "6-1",
        "meta" : {
          "lastUpdated" : "2019-07-14T19:26:23.217+00:00",
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Encounter_6-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Encounter 6-1</b></p><a name=\"6-1\"> </a><a name=\"hc6-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">Last updated: 2019-07-14 19:26:23+0000</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html\">US Core Encounter Profile</a></p></div><p><b>status</b>: Finished</p><p><b>class</b>: <a href=\"http://terminology.hl7.org/6.3.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB\">ActCode: AMB</a> (Ambulatory)</p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>subject</b>: <a href=\"Patient-1.html\">Johnny Appleseed  Male, DoB: 1986-01-01 ( Member Number)</a></p></div>"
        },
        "status" : "finished",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB",
          "display" : "Ambulatory"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "version" : "http://snomed.info/sct/731000124108",
                "code" : "11429006",
                "display" : "Consultation"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "Patient/1"
        }
      },
      "response" : {
        "status" : "200"
      }
    },
    {
      "fullUrl" : "https://example.com/base/Encounter/7-1",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "7-1",
        "meta" : {
          "lastUpdated" : "2019-10-15T20:26:23.217+00:00",
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Encounter_7-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Encounter 7-1</b></p><a name=\"7-1\"> </a><a name=\"hc7-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">Last updated: 2019-10-15 20:26:23+0000</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html\">US Core Encounter Profile</a></p></div><p><b>status</b>: Finished</p><p><b>class</b>: <a href=\"http://terminology.hl7.org/6.3.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB\">ActCode: AMB</a> (Ambulatory)</p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>subject</b>: <a href=\"Patient-1.html\">Johnny Appleseed  Male, DoB: 1986-01-01 ( Member Number)</a></p></div>"
        },
        "status" : "finished",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB",
          "display" : "Ambulatory"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "version" : "http://snomed.info/sct/731000124108",
                "code" : "11429006",
                "display" : "Consultation"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "Patient/1"
        }
      },
      "response" : {
        "status" : "200"
      }
    },
    {
      "fullUrl" : "https://example.com/base/Provenance/1000002-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "1000002-1",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2019-07-14T19:26:23.217+00:00",
          "profile" : [
            "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/pdex-provenance"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_1000002-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance 1000002-1</b></p><a name=\"1000002-1\"> </a><a name=\"hc1000002-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2019-07-14 19:26:23+0000</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-pdex-provenance.html\">PDex Provenance</a></p></div><p>Provenance for <a href=\"Bundle-1000000-1.html#https-//example.com/base/Encounter/6-1\">Encounter: status = finished; class = Ambulatory (ActCode#AMB); type = Consultation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Recorded</td><td>2020-07-10 16:26:23+0000</td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td><a href=\"Organization-ProviderOrg1.html\">Organization Provider 1</a></td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "https://example.com/base/Encounter/6-1"
          }
        ],
        "recorded" : "2020-07-10T16:26:23.217+00:00",
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author",
                  "display" : "Author"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/ProviderOrg1"
            }
          }
        ],
        "entity" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/ProvenanceSourceFrom",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-pdex/CodeSystem/ProvenancePayerDataSource",
                      "code" : "hl7ccda",
                      "display" : "HL7 C-CDA"
                    }
                  ]
                }
              }
            ],
            "role" : "source",
            "what" : {
              "display" : "No reference available"
            }
          }
        ]
      },
      "response" : {
        "status" : "200"
      }
    },
    {
      "fullUrl" : "https://example.com/base/Provenance/1000003-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "1000003-1",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2019-10-15T20:26:23.217+00:00"
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_1000003-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance 1000003-1</b></p><a name=\"1000003-1\"> </a><a name=\"hc1000003-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2019-10-15 20:26:23+0000</p></div><p>Provenance for <a href=\"Bundle-1000000-1.html#Encounter_7-1\">Encounter: status = finished; class = Ambulatory (ActCode#AMB); type = Consultation</a></p><p>Summary</p><table class=\"grid\"><tr><td>Recorded</td><td>2020-07-10 16:26:23+0000</td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/provenance-participant-type author}\">Author</span></td><td><a href=\"Organization-ProviderOrg1.html\">Organization Provider 1</a></td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "Encounter/7-1"
          }
        ],
        "recorded" : "2020-07-10T16:26:23.217+00:00",
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                  "code" : "author",
                  "display" : "Author"
                }
              ]
            },
            "who" : {
              "reference" : "Organization/ProviderOrg1"
            }
          }
        ],
        "entity" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/ProvenanceSourceFrom",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/davinci-pdex/CodeSystem/ProvenancePayerDataSource",
                      "code" : "hl7ccda",
                      "display" : "HL7 C-CDA"
                    }
                  ]
                }
              }
            ],
            "role" : "source",
            "what" : {
              "display" : "No reference available"
            }
          }
        ]
      },
      "response" : {
        "status" : "200"
      }
    },
    {
      "fullUrl" : "https://example.com/base/Provenance/1000004-1",
      "resource" : {
        "resourceType" : "Provenance",
        "id" : "1000004-1",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2019-12-31T20:26:23.217+00:00"
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Provenance_1000004-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Provenance 1000004-1</b></p><a name=\"1000004-1\"> </a><a name=\"hc1000004-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2019-12-31 20:26:23+0000</p></div><p>Provenance for <a href=\"Bundle-1000000-1.html\">Bundle: type = transaction-response; timestamp = 2019-12-31 20:26:23+0000</a></p><p>Summary</p><table class=\"grid\"><tr><td>Recorded</td><td>2019-12-31 20:26:23+0000</td></tr></table><p><b>Agents</b></p><table class=\"grid\"><tr><td><b>Type</b></td><td><b>Role</b></td><td><b>who</b></td></tr><tr><td><span title=\"Codes:{http://hl7.org/fhir/us/core/CodeSystem/us-core-provenance-participant-type transmitter}\">Transmitter</span></td><td/><td><a href=\"Organization-Payer1.html\">Organization Payer 1</a></td></tr></table></div>"
        },
        "target" : [
          {
            "reference" : "Bundle/1000000-1"
          }
        ],
        "recorded" : "2019-12-31T20:26:23.217+00:00",
        "agent" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-provenance-participant-type",
                  "code" : "transmitter",
                  "display" : "Transmitter"
                }
              ]
            },
            "role" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/contractsignertypecodes",
                    "code" : "TRANS"
                  }
                ]
              }
            ],
            "who" : {
              "reference" : "Organization/Payer1"
            }
          }
        ]
      },
      "response" : {
        "status" : "200"
      }
    }
  ]
}

```
