# US Core DiagnosticReport for Report and Note Exchange - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* [**PDex Implementation, Actors, Interactions, Data Payloads and Methods**](pdeximplementationactorsinteractionsdatapayloadsandmethods.md)
* [**Data Mapping**](datamapping.md)
* **US Core DiagnosticReport for Report and Note Exchange**

## US Core DiagnosticReport for Report and Note Exchange

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

[Previous Page - US Core DiagnosticReport for Laboratory Results Reporting](USCoreDiagnosticReportforLaboratoryResultsReporting.md)

Where a Health Plan has access to clinical notes and associated diagnostic information, they **SHALL** make the information available using the [US Core DiagnosticReport for Report and Note Exchange](http://hl7.org/fhir/us/core/StructureDefinition-us-core-diagnosticreport-note.html) resource.

The essential fields (Must Support or Cardinality greater than 0..*) to be provided in the US Core DiagnosticReport for Report and Note Exchange resource are:

| | | | |
| :--- | :--- | :--- | :--- |
| DiagnosticReport.status | status | 1..1 | code |
| DiagnosticReport.category | category | 1..* | (Slice Definition) |
| DiagnosticReport.category:LaboratorySlice | category:LaboratorySlice | 1..1 | CodeableConcept |
| DiagnosticReport.category:LaboratorySlice.coding | coding | 1..* | Coding |
| DiagnosticReport.category:LaboratorySlice.coding.system | system | 1..1 | uri |
| DiagnosticReport.category:LaboratorySlice.coding.code | code | 1..1 | code |
| DiagnosticReport.code | code | 1..1 | CodeableConcept |
| DiagnosticReport.subject | subject | 1..1 | Reference(US Core Patient Profile) |
| DiagnosticReport.effective[x] | effective[x] | 1..1 |   |
| DiagnosticReport.issued | issued | 1..1 | instant |
| DiagnosticReport.performer | performer | 0..* | Reference(US Core Practitioner Profile | US Core Organization Profile) |
| DiagnosticReport.result | result | 0..* | Reference(US Core Laboratory Result Observation Profile) |

*[Table Definition](index.md#mapping-adjudicated-claims-encounter-and-prior-authorization-information)*

#### Example DiagnosticReport for Report and Note exchange Resource

An example mapping of a DiagnosticReport for urinalysis is shown below:

```

{
  "resourceType" : "DiagnosticReport",
  "id" : "urinalysis",
  "meta" : {
    "versionId" : "209563",
    "lastUpdated" : "2016-04-19T17:28:11.308+00:00",
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-lab"
    ]
  },
  "text" : {
    "status" : "generated",
    "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Generated Narrative with Detailsid: urinalysismeta: status: finalcategory: Laboratory <span style=\"background: LightGoldenRodYellow\">(Details : {http://terminology.hl7.org/CodeSystem/v2-0074 code 'LAB' = 'Laboratory', given as 'Laboratory'})</span>code: Complete Urinalysis <span style=\"background: LightGoldenRodYellow\">(Details : {LOINC code '24356-8' = 'Urinalysis complete panel - Urine', given as 'Urinalysis complete panel - Urine'})</span>subject: <a href=\"Patient-example.html\">Amy Shaw. Generated Summary: id: example; Medical Record Number = 1032702 (USUAL); active; Amy V. Shaw ; ph: 555-555-5555(HOME), amy.shaw@example.com; gender: female; birthDate: Feb 20, 2007</a>effective: Jul 5, 2005, 12:00:00 AMissued: Jul 6, 2005, 12:45:33 AMperformer: <a href=\"Organization-acme-lab.html\">Acme Laboratory, Inc. Generated Summary: id: acme-lab; 1144221847, 2523423456; active; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/organization-type prov}\">Healthcare Provider</span>; name: Acme Labs; ph: (+1) 734-677-7777, hq@acme.org</a>result: <a href=\"Observation-urine-color.html\">COLOR=Yellow. Generated Summary: id: urine-color; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 5778-6}\">COLOR</span>; effective: Jul 5, 2005, 12:00:00 AM; <span title=\"Codes: {http://snomed.inbnm,fo/sct 371244009}\">Yellow</span></a><a href=\"Observation-urine-clarity.html\">APPEARANCE=Hazy. Generated Summary: id: urine-clarity; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 32167-9}\">APPEARANCE</span>; effective: Jul 5, 2005, 12:00:00 AM; <span title=\"Codes: {http://snomed.info/sct 81858005}\">Hazy</span></a><a href=\"Observation-urine-glucose.html\">GLUCOSE=Negative. Generated Summary: id: urine-glucose; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 25428-4}\">GLUCOSE</span>; effective: Jul 5, 2005, 12:00:00 AM; <span title=\"Codes: {http://snomed.info/sct 260385009}\">Negative</span></a><a href=\"Observation-urine-bilirubin.html\">BILIRUBIN=Negative. Generated Summary: id: urine-bilirubin; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 5770-3}\">BILIRUBIN</span>; effective: Jul 5, 2005, 12:00:00 AM; <span title=\"Codes: {http://snomed.info/sct 260385009}\">Negative</span></a><a href=\"Observation-urine-ketone.html\">KETONE=Negative. Generated Summary: id: urine-ketone; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 2514-8}\">KETONE</span>; effective: Jul 5, 2005, 12:00:00 AM; <span title=\"Codes: {http://snomed.info/sct 260385009}\">Negative</span></a><a href=\"Observation-usg.html\">SPEC GRAV=1.017. Generated Summary: id: usg; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 5811-5}\">SPEC GRAV</span>; effective: Jul 5, 2005, 12:00:00 AM; 1.017 {urine specific gravity}</a><a href=\"Observation-urine-ph.html\">PH=6 (pH). Generated Summary: id: urine-ph; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 5803-2}\">PH</span>; effective: Jul 5, 2005, 12:00:00 AM; 6.0 (pH)</a><a href=\"Observation-urine-protein.html\">PROTEIN=Negative. Generated Summary: id: urine-protein; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 20454-5}\">PROTEIN</span>; effective: Jul 5, 2005, 12:00:00 AM; <span title=\"Codes: {http://snomed.info/sct 260385009}\">Negative</span></a><a href=\"Observation-urobilinogen.html\">UROBILINOGEN=0.3 mg/dL. Generated Summary: id: urobilinogen; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 20405-7}\">UROBILINOGEN</span>; effective: Jul 5, 2005, 12:00:00 AM; 0.3 mg/dL</a><a href=\"Observation-urine-nitrite.html\">NITRITE=Positive. Generated Summary: id: urine-nitrite; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 5802-4}\">NITRITE</span>; effective: Jul 5, 2005, 12:00:00 AM; <span title=\"Codes: {http://snomed.info/sct 10828004}\">Positive</span></a><a href=\"Observation-urine-hemoglobin.html\">BLOOD=Trace. Generated Summary: id: urine-hemoglobin; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 5794-3}\">BLOOD</span>; effective: Jul 5, 2005, 12:00:00 AM; <span title=\"Codes: {http://snomed.info/sct 260405006}\">Trace</span></a><a href=\"Observation-urine-leukocyte-esterase.html\">LEUK ESTERASE=2+e. Generated Summary: id: urine-leukocyte-esterase; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 5799-2}\">LEUK ESTERASE</span>; effective: Jul 5, 2005, 12:00:00 AM; <span title=\"Codes: {http://snomed.info/sct 260348001}\">2+</span></a><a href=\"Observation-urine-sediment.html\">COMMENT=Recommend Urine Culture. Generated Summary: id: urine-sediment; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 11279-7}\">COMMENT</span>; effective: Jul 5, 2005, 12:00:00 AM; value: Recommend Urine Culture</a><a href=\"Observation-urine-bacteria.html\">BACTERIA=4+. Generated Summary: id: urine-bacteria; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 25145-4}\">BACTERIA</span>; effective: Jul 5, 2005, 12:00:00 AM; <span title=\"Codes: {http://snomed.info/sct 260350009}\">4+</span></a><a href=\"Observation-urine-epi-cells.html\">EPITHELIAL CELLS=1-5 cells/HPF. Generated Summary: id: urine-epi-cells; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 5787-7}\">EPITHELIAL CELLS</span>; effective: Jul 5, 2005, 12:00:00 AM; </a><a href=\"Observation-urine-wbcs.html\">WBC=20-30 cells/HPF. Generated Summary: id: urine-wbcs; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 5821-4}\">WBC</span>; effective: Jul 5, 2005, 12:00:00 AM; </a><a href=\"Observation-urine-rbcs.html\">RBC=Occasional cells/HPF. Generated Summary: id: urine-rbcs; <span title=\"Codes: {http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>; <span title=\"Codes: {http://loinc.org 13945-1}\">RBC</span>; effective: Jul 5, 2005, 12:00:00 AM; <span title=\"Codes: {http://snomed.info/sct 84638005}\">Occasional</span></a></div>"
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "LAB",
          "display" : "Laboratory"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "24356-8",
        "display" : "Urinalysis complete panel - Urine"
      }
    ],
    "text" : "Complete Urinalysis"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectiveDateTime" : "2005-07-05",
  "issued" : "2005-07-06T11:45:33+11:00",
  "performer" : [
    {
      "reference" : "Organization/acme-lab",
      "display" : "Acme Laboratory, Inc"
    }
  ],
  "result" : [
    {
      "reference" : "Observation/urine-color",
      "display" : "COLOR=Yellow"
    },
    {
      "reference" : "Observation/urine-clarity",
      "display" : "APPEARANCE=Hazy"
    },
    {
      "reference" : "Observation/urine-glucose",
      "display" : "GLUCOSE=Negative"
    },
    {
      "reference" : "Observation/urine-bilirubin",
      "display" : "BILIRUBIN=Negative"
    },
    {
      "reference" : "Observation/urine-ketone",
      "display" : "KETONE=Negative"
    },
    {
      "reference" : "Observation/usg",
      "display" : "SPEC GRAV=1.017"
    },
    {
      "reference" : "Observation/urine-ph",
      "display" : "PH=6 (pH)"
    },
    {
      "reference" : "Observation/urine-protein",
      "display" : "PROTEIN=Negative"
    },
    {
      "reference" : "Observation/urobilinogen",
      "display" : "UROBILINOGEN=0.3 mg/dL"
    },
    {
      "reference" : "Observation/urine-nitrite",
      "display" : "NITRITE=Positive"
    },
    {
      "reference" : "Observation/urine-hemoglobin",
      "display" : "BLOOD=Trace"
    },
    {
      "reference" : "Observation/urine-leukocyte-esterase",
      "display" : "LEUK ESTERASE=2+e"
    },
    {
      "reference" : "Observation/urine-sediment",
      "display" : "COMMENT=Recommend Urine Culture"
    },
    {
      "reference" : "Observation/urine-bacteria",
      "display" : "BACTERIA=4+"
    },
    {
      "reference" : "Observation/urine-epi-cells",
      "display" : "EPITHELIAL CELLS=1-5 cells/HPF"
    },
    {
      "reference" : "Observation/urine-wbcs",
      "display" : "WBC=20-30 cells/HPF"
    },
    {
      "reference" : "Observation/urine-rbcs",
      "display" : "RBC=Occasional cells/HPF"
    }
  ]
}

```

[Next Page - US Core DocumentReference](USCoreDocumentReference.md)

