# Provider-Member-Match Request Example - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **Provider-Member-Match Request Example**

## Example Parameters: Provider-Member-Match Request Example



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "provider-member-match-request-001",
  "parameter" : [
    {
      "name" : "MembersToMatch",
      "part" : [
        {
          "name" : "MemberPatient",
          "resource" : {
            "resourceType" : "Patient",
            "id" : "patient-prov-001",
            "identifier" : [
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "MB"
                    }
                  ]
                },
                "system" : "http://example.org/provider-org/patient-ids",
                "value" : "PAT-001",
                "assigner" : {
                  "display" : "Provider Organization"
                }
              }
            ],
            "name" : [
              {
                "use" : "official",
                "family" : "Johnson",
                "given" : ["Robert", "Michael"]
              }
            ],
            "telecom" : [
              {
                "system" : "phone",
                "value" : "555-123-4567"
              }
            ],
            "gender" : "male",
            "birthDate" : "1965-08-15",
            "address" : [
              {
                "use" : "home",
                "line" : ["123 Main Street"],
                "city" : "Springfield",
                "state" : "IL",
                "postalCode" : "62701"
              }
            ]
          }
        },
        {
          "name" : "CoverageToMatch",
          "resource" : {
            "resourceType" : "Coverage",
            "id" : "coverage-to-match-001",
            "meta" : {
              "profile" : [
                "http://hl7.org/fhir/us/davinci-hrex/StructureDefinition/hrex-coverage"
              ]
            },
            "status" : "draft",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "EHPLANS"
                }
              ]
            },
            "subscriber" : {
              "reference" : "Patient/patient-prov-001"
            },
            "subscriberId" : "12345678",
            "beneficiary" : {
              "reference" : "Patient/patient-prov-001"
            },
            "relationship" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
                  "code" : "self"
                }
              ]
            },
            "period" : {
              "start" : "2023-01-01",
              "end" : "2023-12-31"
            },
            "payor" : [
              {
                "identifier" : {
                  "system" : "http://hl7.org/fhir/sid/us-npi",
                  "value" : "9876543210"
                },
                "display" : "Previous Health Plan"
              }
            ],
            "class" : [
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                      "code" : "group"
                    }
                  ]
                },
                "value" : "EMPLOY-12345"
              },
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                      "code" : "plan"
                    }
                  ]
                },
                "value" : "PPO-GOLD"
              }
            ]
          }
        },
        {
          "name" : "TreatmentAttestation",
          "resource" : {
            "resourceType" : "Consent",
            "id" : "treatment-attestation-001",
            "meta" : {
              "profile" : [
                "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/provider-treatment-relationship-consent"
              ]
            },
            "status" : "active",
            "scope" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/consentscope",
                  "code" : "treatment"
                }
              ]
            },
            "category" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/consentcategorycodes",
                    "code" : "treat",
                    "display" : "Treatment"
                  }
                ]
              },
              {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "64292-6",
                    "display" : "Release of information consent"
                  }
                ]
              }
            ],
            "patient" : {
              "reference" : "Patient/patient-prov-001"
            },
            "dateTime" : "2024-12-10T14:30:00Z",
            "performer" : [
              {
                "reference" : "Practitioner/provider-001",
                "display" : "Dr. Susan Smith, MD"
              }
            ],
            "organization" : [
              {
                "reference" : "Organization/provider-org-001",
                "display" : "Springfield Medical Center"
              }
            ],
            "sourceReference" : {
              "reference" : "DocumentReference/treatment-attestation-form-001",
              "display" : "Provider Attestation Form"
            },
            "policy" : [
              {
                "authority" : "https://example.org/compliance",
                "uri" : "https://example.org/provider-attestation-policy"
              }
            ],
            "provision" : {
              "type" : "permit",
              "period" : {
                "start" : "2024-01-15"
              },
              "actor" : [
                {
                  "role" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                        "code" : "IRCP",
                        "display" : "information recipient"
                      }
                    ]
                  },
                  "reference" : {
                    "reference" : "Practitioner/provider-001",
                    "display" : "Dr. Susan Smith"
                  }
                }
              ],
              "purpose" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "TREATMENT",
                  "display" : "Treatment"
                }
              ]
            }
          }
        },
        {
          "name" : "CoverageToLink",
          "resource" : {
            "resourceType" : "Coverage",
            "id" : "coverage-link-001",
            "meta" : {
              "profile" : [
                "http://hl7.org/fhir/us/davinci-hrex/StructureDefinition/hrex-coverage"
              ]
            },
            "status" : "draft",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "EHPLANS"
                }
              ]
            },
            "subscriber" : {
              "reference" : "Patient/patient-prov-001"
            },
            "subscriberId" : "NEW-12345678",
            "beneficiary" : {
              "reference" : "Patient/patient-prov-001"
            },
            "relationship" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
                  "code" : "self"
                }
              ]
            },
            "period" : {
              "start" : "2024-01-01",
              "end" : "2024-12-31"
            },
            "payor" : [
              {
                "identifier" : {
                  "system" : "http://hl7.org/fhir/sid/us-npi",
                  "value" : "5555555555"
                },
                "display" : "Current Payer"
              }
            ],
            "class" : [
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                      "code" : "group"
                    }
                  ]
                },
                "value" : "EMPLOY-NEW"
              },
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                      "code" : "plan"
                    }
                  ]
                },
                "value" : "PPO-PREMIUM"
              }
            ]
          }
        }
      ]
    },
    {
      "name" : "MembersToMatch",
      "part" : [
        {
          "name" : "MemberPatient",
          "resource" : {
            "resourceType" : "Patient",
            "id" : "patient-prov-002",
            "identifier" : [
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "MB"
                    }
                  ]
                },
                "system" : "http://example.org/provider-org/patient-ids",
                "value" : "PAT-002",
                "assigner" : {
                  "display" : "Provider Organization"
                }
              }
            ],
            "name" : [
              {
                "use" : "official",
                "family" : "Williams",
                "given" : ["Sarah", "Elizabeth"]
              }
            ],
            "telecom" : [
              {
                "system" : "phone",
                "value" : "555-987-6543"
              }
            ],
            "gender" : "female",
            "birthDate" : "1978-03-22",
            "address" : [
              {
                "use" : "home",
                "line" : ["456 Oak Avenue"],
                "city" : "Columbus",
                "state" : "OH",
                "postalCode" : "43085"
              }
            ]
          }
        },
        {
          "name" : "CoverageToMatch",
          "resource" : {
            "resourceType" : "Coverage",
            "id" : "coverage-to-match-002",
            "meta" : {
              "profile" : [
                "http://hl7.org/fhir/us/davinci-hrex/StructureDefinition/hrex-coverage"
              ]
            },
            "status" : "draft",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "EHPLANS"
                }
              ]
            },
            "subscriber" : {
              "reference" : "Patient/patient-prov-002"
            },
            "subscriberId" : "87654321",
            "beneficiary" : {
              "reference" : "Patient/patient-prov-002"
            },
            "relationship" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
                  "code" : "self"
                }
              ]
            },
            "period" : {
              "start" : "2023-06-01",
              "end" : "2024-05-31"
            },
            "payor" : [
              {
                "identifier" : {
                  "system" : "http://hl7.org/fhir/sid/us-npi",
                  "value" : "1111111111"
                },
                "display" : "Another Health Plan"
              }
            ],
            "class" : [
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                      "code" : "group"
                    }
                  ]
                },
                "value" : "EMPLOY-67890"
              },
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                      "code" : "plan"
                    }
                  ]
                },
                "value" : "HMO-BASIC"
              }
            ]
          }
        },
        {
          "name" : "TreatmentAttestation",
          "resource" : {
            "resourceType" : "Consent",
            "id" : "treatment-attestation-002",
            "meta" : {
              "profile" : [
                "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/provider-treatment-relationship-consent"
              ]
            },
            "status" : "active",
            "scope" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/consentscope",
                  "code" : "treatment"
                }
              ]
            },
            "category" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/consentcategorycodes",
                    "code" : "treat",
                    "display" : "Treatment"
                  }
                ]
              },
              {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "64292-6",
                    "display" : "Release of information consent"
                  }
                ]
              }
            ],
            "patient" : {
              "reference" : "Patient/patient-prov-002"
            },
            "dateTime" : "2024-12-09T10:15:00Z",
            "performer" : [
              {
                "reference" : "Practitioner/provider-002",
                "display" : "Dr. James Brown, MD"
              }
            ],
            "organization" : [
              {
                "reference" : "Organization/provider-org-002",
                "display" : "Columbus Clinic"
              }
            ],
            "sourceReference" : {
              "reference" : "DocumentReference/treatment-attestation-form-002",
              "display" : "Provider Attestation Form"
            },
            "policy" : [
              {
                "uri" : "https://example.org/provider-attestation-policy"
              }
            ],
            "provision" : {
              "type" : "permit",
              "period" : {
                "start" : "2024-02-01"
              },
              "actor" : [
                {
                  "role" : {
                    "coding" : [
                      {
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                        "code" : "IRCP",
                        "display" : "information recipient"
                      }
                    ]
                  },
                  "reference" : {
                    "reference" : "Practitioner/provider-002",
                    "display" : "Dr. James Brown"
                  }
                }
              ],
              "purpose" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
                  "code" : "TREATMENT",
                  "display" : "Treatment"
                }
              ]
            }
          }
        }
      ]
    }
  ]
}

```
