# Provider Bulk Member Match Response Example - Da Vinci Payer Data Exchange v2.1.1

* [**Table of Contents**](toc.md)
* [**FHIR Artifacts**](artifacts.md)
* **Provider Bulk Member Match Response Example**

## Example Parameters: Provider Bulk Member Match Response Example



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "provider-bulk-member-match-out",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/provider-parameters-multi-member-match-bundle-out"
    ]
  },
  "parameter" : [
    {
      "name" : "MatchedMembers",
      "resource" : {
        "resourceType" : "Group",
        "id" : "provider-matched-group-001",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Matched members group - members authorized for provider access</div>"
        },
        "contained" : [
          {
            "resourceType" : "Patient",
            "id" : "provider-submitted-patient-1",
            "identifier" : [
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "MR"
                    }
                  ]
                },
                "system" : "http://example.org/provider-emr/identifiers/patient",
                "value" : "EMR-98765",
                "assigner" : {
                  "display" : "Provider 1 EMR System"
                }
              }
            ],
            "name" : [
              {
                "use" : "official",
                "family" : "Person",
                "given" : ["Patricia", "Ann"]
              }
            ],
            "gender" : "female",
            "birthDate" : "1974-12-25"
          },
          {
            "resourceType" : "Patient",
            "id" : "provider-submitted-patient-2",
            "identifier" : [
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "MR"
                    }
                  ]
                },
                "system" : "http://example.org/provider-emr/identifiers/patient",
                "value" : "EMR-45678",
                "assigner" : {
                  "display" : "Provider 1 EMR System"
                }
              }
            ],
            "name" : [
              {
                "use" : "official",
                "family" : "Doe",
                "given" : ["John", "Michael"]
              }
            ],
            "gender" : "male",
            "birthDate" : "1985-06-15"
          }
        ],
        "identifier" : [
          {
            "system" : "http://hl7.org/fhir/sid/us-npi",
            "value" : "1982947230",
            "assigner" : {
              "display" : "Provider 1"
            }
          }
        ],
        "type" : "person",
        "actual" : true,
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pdex/CodeSystem/PdexMultiMemberMatchResultCS",
              "code" : "match",
              "display" : "Matched"
            }
          ]
        },
        "managingEntity" : {
          "identifier" : {
            "system" : "http://hl7.org/fhir/sid/us-npi",
            "value" : "1234567890"
          },
          "display" : "Example Health Plan"
        },
        "characteristic" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/davinci-pdex/CodeSystem/PdexMultiMemberMatchResultCS",
                  "code" : "match",
                  "display" : "Matched"
                }
              ]
            },
            "valueReference" : {
              "identifier" : {
                "system" : "http://hl7.org/fhir/sid/us-npi",
                "value" : "1982947230"
              },
              "display" : "Provider 1"
            },
            "exclude" : false,
            "period" : {
              "start" : "2024-11-14"
            }
          }
        ],
        "member" : [
          {
            "entity" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/base-ext-match-parameters",
                  "valueReference" : {
                    "reference" : "#provider-submitted-patient-1"
                  }
                }
              ],
              "reference" : "Patient/payer-patient-1001",
              "display" : "Patricia Ann Person - Payer Record"
            }
          },
          {
            "entity" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/base-ext-match-parameters",
                  "valueReference" : {
                    "reference" : "#provider-submitted-patient-2"
                  }
                }
              ],
              "reference" : "Patient/payer-patient-2002",
              "display" : "John Michael Doe - Payer Record"
            }
          }
        ]
      }
    },
    {
      "name" : "NonMatchedMembers",
      "resource" : {
        "resourceType" : "Group",
        "id" : "provider-nomatch-group-001",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Non-matched members group - members not found in payer system</div>"
        },
        "contained" : [
          {
            "resourceType" : "Patient",
            "id" : "provider-submitted-patient-3",
            "identifier" : [
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "MR"
                    }
                  ]
                },
                "system" : "http://example.org/provider-emr/identifiers/patient",
                "value" : "EMR-99999",
                "assigner" : {
                  "display" : "Provider 1 EMR System"
                }
              }
            ],
            "name" : [
              {
                "use" : "official",
                "family" : "Smith",
                "given" : ["Jane", "Marie"]
              }
            ],
            "gender" : "female",
            "birthDate" : "1990-03-20"
          }
        ],
        "identifier" : [
          {
            "system" : "http://hl7.org/fhir/sid/us-npi",
            "value" : "1982947230",
            "assigner" : {
              "display" : "Provider 1"
            }
          }
        ],
        "type" : "person",
        "actual" : true,
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pdex/CodeSystem/PdexMultiMemberMatchResultCS",
              "code" : "nomatch",
              "display" : "Not Matched"
            }
          ]
        },
        "managingEntity" : {
          "identifier" : {
            "system" : "http://hl7.org/fhir/sid/us-npi",
            "value" : "1234567890"
          },
          "display" : "Example Health Plan"
        },
        "member" : [
          {
            "entity" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/base-ext-match-parameters",
                  "valueReference" : {
                    "reference" : "#provider-submitted-patient-3"
                  }
                }
              ],
              "reference" : "#provider-submitted-patient-3",
              "display" : "Jane Marie Smith - Not Found"
            }
          }
        ]
      }
    },
    {
      "name" : "ConsentConstrainedMembers",
      "resource" : {
        "resourceType" : "Group",
        "id" : "provider-consent-constraint-group-001",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Consent-constrained members group - members who opted out of Provider Access API</div>"
        },
        "contained" : [
          {
            "resourceType" : "Patient",
            "id" : "provider-submitted-patient-4",
            "identifier" : [
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                      "code" : "MR"
                    }
                  ]
                },
                "system" : "http://example.org/provider-emr/identifiers/patient",
                "value" : "EMR-77777",
                "assigner" : {
                  "display" : "Provider 1 EMR System"
                }
              }
            ],
            "name" : [
              {
                "use" : "official",
                "family" : "Wilson",
                "given" : ["Robert", "James"]
              }
            ],
            "gender" : "male",
            "birthDate" : "1978-11-30"
          }
        ],
        "identifier" : [
          {
            "system" : "http://hl7.org/fhir/sid/us-npi",
            "value" : "1982947230",
            "assigner" : {
              "display" : "Provider 1"
            }
          }
        ],
        "type" : "person",
        "actual" : true,
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/davinci-pdex/CodeSystem/PdexMultiMemberMatchResultCS",
              "code" : "consentconstraint",
              "display" : "Consent Constraint"
            }
          ]
        },
        "managingEntity" : {
          "identifier" : {
            "system" : "http://hl7.org/fhir/sid/us-npi",
            "value" : "1234567890"
          },
          "display" : "Example Health Plan"
        },
        "member" : [
          {
            "entity" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/us/davinci-pdex/StructureDefinition/base-ext-match-parameters",
                  "valueReference" : {
                    "reference" : "#provider-submitted-patient-4"
                  }
                }
              ],
              "reference" : "#provider-submitted-patient-4",
              "display" : "Robert James Wilson - Opted Out"
            }
          }
        ]
      }
    }
  ]
}

```
